/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.util;

import com.ibm.es.nuvo.api.CrawlService;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.CrawlServiceFactory;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.crawlspace.WebCrawlspace;
import com.ibm.es.nuvo.util.Constants;

public class ConfigurationUtils {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static ConfigurationManager getConfiguration() {
        return ConfigurationManager.getConfigurationManager();
    }

    public static CollectionConfiguration getCollection(String collectionId) throws ConfigurationManagerException {
        return ConfigurationUtils.getConfiguration().getCollection(collectionId);
    }

    public static boolean collectionExists(String collectionId) {
        return ConfigurationUtils.getConfiguration().collectionExists(collectionId);
    }

    public static WebCrawlspace createDefaultWebCrawlspace() {
        WebCrawlspace webCs = new WebCrawlspace();
        webCs.setCrawlerName("");
        webCs.setPolitness(2000);
        webCs.setEmailId("");
        return webCs;
    }

    public static void createCollection(CollectionConfiguration collConfig) throws ExtendedException {
        String collectionId = collConfig.getId();
        ConfigurationUtils.getConfiguration().createCollection(collConfig);
        CollectionCrawlspaceConfigurationManager csConfigMgr = CollectionCrawlspaceConfigurationManager.getConfigurationManager();
        CollectionCrawlspace cs = csConfigMgr.createDefaultCrawlspaceConfig();
        csConfigMgr.createCrawlspace(cs, collectionId);
    }

    public static CrawlService getWebCrawlService() {
        return CrawlServiceFactory.getInstance().getServiceFor(Constants.CrawlerType.Web);
    }

    public static CrawlService getFileCrawlService() {
        System.out.println("obsolete code using old file crawler in ConfigurationUtils ");
        return null;
    }

    public static CollectionCrawlspaceConfigurationManager getCollectionCrawlspaceConfigurationManager() {
        return CollectionCrawlspaceConfigurationManager.getConfigurationManager();
    }

    public static CollectionCrawlspace getCollectionCrawlspace(String collectionId) throws ExtendedException {
        CollectionCrawlspaceConfigurationManager csConfigMgr = CollectionCrawlspaceConfigurationManager.getConfigurationManager();
        return csConfigMgr.getCrawlspace(collectionId);
    }

    public static CollectionCrawlspace getCollectionCrawlspaceForUpdate(String collectionId) throws ExtendedException {
        CollectionCrawlspaceConfigurationManager csConfigMgr = CollectionCrawlspaceConfigurationManager.getConfigurationManager();
        return csConfigMgr.getCrawlspaceForUpdate(collectionId);
    }

    public static WebCrawlspace getWebCrawlspaceForUpdate(String collectionId) throws ExtendedException {
        return ConfigurationUtils.getCollectionCrawlspaceForUpdate(collectionId).getWebCrawlspace();
    }

    public static WebCrawlspace getWebCrawlspace(String collectionId) throws ExtendedException {
        return ConfigurationUtils.getCollectionCrawlspace(collectionId).getWebCrawlspace();
    }
}

