/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.ui.beans;

import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.admin.ui.beans.CustomUiBackgroundBean;
import com.ibm.es.nuvo.common.admin.ui.beans.CustomUiFontBean;
import com.ibm.es.nuvo.common.admin.ui.beans.CustomUiImageBean;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.httplistener.HttpListenerManager;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import java.util.logging.Level;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionMessages;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CustomUiBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String PROPERTIES_RELATIVE_DIR = "/config/customization/";
    public static final String SEARCH_URL_FILE_NAME = "UrlRequestString.properties";
    private static final String SEARCH_URL_DEFAULT_VALUE = "/search/?pageSize=3&preview=true";
    private Locale locale = Locale.ENGLISH;
    private String propertiesAbsoluteDir = "";
    public static final String IMAGES_RELATIVE_DIR = "/config/customization/images/";
    private String absoluteWhitneyPackageDir = "";
    public static final Integer DEFAULT_FILE_FLAG = 1;
    private static final String DEFAULT_FILE_PREFIX = "customization_default";
    public static final Integer PERSISTENT_FILE_FLAG = 2;
    private static final String PERSISTENT_FILE_PREFIX = "customization_persistent";
    public static final Integer TEMPORARY_FILE_FLAG = 3;
    private static final String TEMPORARY_FILE_PREFIX = "customization_temporary";
    protected CustomUiBackgroundBean background = new CustomUiBackgroundBean("background");
    protected CustomUiImageBean logoLeft = new CustomUiImageBean("logoLeft");
    protected CustomUiImageBean logoRight = new CustomUiImageBean("logoRight");
    protected String searchButtonText = "Search";
    protected String searchButtonTextEdited = "false";
    protected String titleBarText = "";
    protected String titleBarTextEdited = "false";
    protected String enterpriseLinkText = "";
    protected String enterpriseLinkTextEdited = "false";
    protected String toolbarBannerEnabled = "true";
    protected String searchLinksEnabled = "true";
    protected String collectionListEnabled = "true";
    protected String advancedSearchLinkEnabled = "true";
    protected String languagePreferencesLinkEnabled = "true";
    protected String helpLinkEnabled = "true";
    protected String searchPageDividerBarEnabled = "true";
    protected String searchResultsSummaryEnabled = "true";
    protected String webSearchEnabled = "true";
    protected String copyrightEnabled = "true";
    protected String yahooFeaturesEnabled = "false";
    protected String yahooShortcutEnabled = "false";
    protected String yahooToolbarEnabled = "false";
    protected String yahooLinksEnabled = "false";
    protected String yahooLinkWebEnabled = "false";
    protected String yahooLinkImagesEnabled = "false";
    protected String yahooLinkVideoEnabled = "false";
    protected String yahooLinkAudioEnabled = "false";
    protected String yahooLinkDirectoryEnabled = "false";
    protected String yahooLinkLocalEnabled = "false";
    protected String yahooLinkNewsEnabled = "false";
    protected CustomUiFontBean resultSearchBar = new CustomUiFontBean("resultSearchBar");
    protected CustomUiFontBean resultHeaderNumber = new CustomUiFontBean("resultHeaderNumber");
    protected CustomUiFontBean resultHeaderTitle = new CustomUiFontBean("resultHeaderTitle");
    protected CustomUiFontBean resultHeaderRelevancy = new CustomUiFontBean("resultHeaderRelevancy");
    protected CustomUiFontBean resultSummary = new CustomUiFontBean("resultSummary");
    protected CustomUiFontBean resultHighlight = new CustomUiFontBean("resultHighlight");
    protected CustomUiFontBean resultFooterDocumentUrl = new CustomUiFontBean("resultFooterDocumentUrl");
    protected CustomUiFontBean resultFooterDocumentSize = new CustomUiFontBean("resultFooterDocumentSize");
    protected CustomUiFontBean resultFooterModificationDate = new CustomUiFontBean("resultFooterModificationDate");
    protected CustomUiFontBean resultFooterHtmlCachedLink = new CustomUiFontBean("resultFooterHtmlCachedLink");
    protected CustomUiFontBean resultFooterOriginalCachedLink = new CustomUiFontBean("resultFooterOriginalCachedLink");
    protected CustomUiFontBean resultNavigationSelected = new CustomUiFontBean("resultNavigationSelected");
    protected CustomUiFontBean resultNavigationUnselected = new CustomUiFontBean("resultNavigationUnselected");
    protected List<String> availableImages = new Vector<String>();
    protected String lastRequestedSearchUrl = null;
    protected String sectionPageExpanded = "false";
    protected String sectionResultsExpanded = "false";
    protected String sectionYahooExpanded = "false";
    protected String selectedPane = "";
    protected String imageUploadRequested = "false";

    public CustomUiBean(String hostName) {
        this.lastRequestedSearchUrl = CustomUiBean.getSearchURL(hostName);
        this.absoluteWhitneyPackageDir = GlobalConfiguration.getConfiguration().getInstallPath();
        this.propertiesAbsoluteDir = this.absoluteWhitneyPackageDir + PROPERTIES_RELATIVE_DIR;
        this.updateAvailableImages();
    }

    public static String getSearchURL(String hostname) {
        String searchURL = HttpListenerManager.getSingleInstanceListenerServer().getSearchAppURL(hostname);
        return searchURL + SEARCH_URL_DEFAULT_VALUE;
    }

    public static String getAbsoluteCustomizationImagesDir() {
        return GlobalConfiguration.getConfiguration().getInstallPath() + IMAGES_RELATIVE_DIR;
    }

    public void updateAvailableImages() {
        this.availableImages.clear();
        File dir = new File(CustomUiBean.getAbsoluteCustomizationImagesDir());
        FilenameFilter filenameFilter = new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.toUpperCase().endsWith(".BMP") || name.toUpperCase().endsWith(".JPG") || name.toUpperCase().endsWith(".GIF") || name.toUpperCase().endsWith(".PNG");
            }
        };
        File[] files = dir.listFiles(filenameFilter);
        for (int i = 0; i < files.length; ++i) {
            this.availableImages.add(files[i].getName());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadValuesFromPropertiesFile(Integer fileType, Locale localeIn) {
        File requestedFile;
        this.locale = localeIn;
        String customFileName = this.evaluateAbsoluteFileName(fileType);
        if (fileType == PERSISTENT_FILE_FLAG && !(requestedFile = new File(customFileName)).exists()) {
            customFileName = GlobalConfiguration.getConfiguration().getConfigFileName("customization", "customization_default.properties");
        }
        Properties properties = new Properties();
        FileInputStream fis = null;
        try {
            Message msg;
            fis = new FileInputStream(customFileName);
            properties.load(fis);
            CustomUiBackgroundBean.loadBackgroundValues(properties, this.background);
            CustomUiImageBean.loadImageValues(properties, this.logoLeft);
            CustomUiImageBean.loadImageValues(properties, this.logoRight);
            this.searchButtonText = properties.getProperty("searchButtonText");
            if (this.searchButtonText == null || this.searchButtonText.equals("") || this.searchButtonText.equals("Search")) {
                msg = new Message("A2001I.default.search.button.label");
                this.searchButtonText = msg.getFormattedText(localeIn);
            }
            this.titleBarText = properties.getProperty("titleBarText");
            if (this.titleBarText == null || this.titleBarText.equals("")) {
                msg = new Message("A2002I.default.title.bar.label");
                this.titleBarText = msg.getFormattedText(localeIn);
            }
            this.toolbarBannerEnabled = properties.getProperty("toolbarBannerEnabled");
            this.searchLinksEnabled = properties.getProperty("searchLinksEnabled");
            this.collectionListEnabled = properties.getProperty("collectionListEnabled");
            this.languagePreferencesLinkEnabled = properties.getProperty("languagePreferencesLinkEnabled");
            this.searchPageDividerBarEnabled = properties.getProperty("searchPageDividerBarEnabled");
            this.searchResultsSummaryEnabled = properties.getProperty("searchResultsSummaryEnabled");
            this.webSearchEnabled = properties.getProperty("webSearchEnabled");
            this.copyrightEnabled = properties.getProperty("copyrightEnabled");
            this.advancedSearchLinkEnabled = properties.getProperty("advancedSearchEnabled");
            if (this.advancedSearchLinkEnabled == null || this.advancedSearchLinkEnabled.equals("")) {
                this.advancedSearchLinkEnabled = "true";
            }
            this.helpLinkEnabled = properties.getProperty("helpLinkEnabled");
            if (this.helpLinkEnabled == null || this.helpLinkEnabled.equals("")) {
                this.helpLinkEnabled = "true";
            }
            this.enterpriseLinkText = properties.getProperty("enterpriseLinkText");
            if (this.enterpriseLinkText == null || this.enterpriseLinkText.equals("")) {
                msg = new Message("A2000I.default.enterprise.label");
                this.enterpriseLinkText = msg.getFormattedText(localeIn);
            }
            CustomUiFontBean.loadFontValues(properties, this.resultSearchBar);
            CustomUiFontBean.loadFontValues(properties, this.resultHeaderNumber);
            CustomUiFontBean.loadFontValues(properties, this.resultHeaderTitle);
            CustomUiFontBean.loadFontValues(properties, this.resultHeaderRelevancy);
            CustomUiFontBean.loadFontValues(properties, this.resultSummary);
            CustomUiFontBean.loadFontValues(properties, this.resultHighlight);
            CustomUiFontBean.loadFontValues(properties, this.resultFooterDocumentUrl);
            CustomUiFontBean.loadFontValues(properties, this.resultFooterDocumentSize);
            CustomUiFontBean.loadFontValues(properties, this.resultFooterModificationDate);
            CustomUiFontBean.loadFontValues(properties, this.resultFooterHtmlCachedLink);
            CustomUiFontBean.loadFontValues(properties, this.resultFooterOriginalCachedLink);
            String resultNaviSelExists = properties.getProperty("resultNavigationSelected.textEnabled");
            if (resultNaviSelExists == null || resultNaviSelExists.equals("")) {
                this.resultNavigationSelected.setFontColor("black");
                this.resultNavigationSelected.setFontFamily("Arial");
                this.resultNavigationSelected.setFontWeight("bold");
                this.resultNavigationSelected.setTextEnabled("true");
                this.resultNavigationSelected.setFontSize("12px");
            } else {
                CustomUiFontBean.loadFontValues(properties, this.resultNavigationSelected);
            }
            String resultNaviUnselExists = properties.getProperty("resultNavigationUnselected.textEnabled");
            if (resultNaviUnselExists == null || resultNaviUnselExists.equals("")) {
                this.resultNavigationUnselected.setFontColor("blue");
                this.resultNavigationUnselected.setFontFamily("Arial");
                this.resultNavigationUnselected.setTextEnabled("true");
                this.resultNavigationUnselected.setFontDecoration("underline");
                this.resultNavigationUnselected.setFontSize("12px");
            } else {
                CustomUiFontBean.loadFontValues(properties, this.resultNavigationUnselected);
            }
        }
        catch (IOException e) {
            if (Loggers.logger.isLoggable(Level.WARNING)) {
                Message msg = new Message("A0710E.UNABLE_TO_ACCESS_CUSTOMIZATION_FILE", customFileName);
                Loggers.logger.log(Level.WARNING, msg);
                System.err.println(msg.getFormattedText());
            }
        }
        finally {
            try {
                if (fis != null) {
                    fis.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveValuesToPropertiesFile(Integer fileType, Locale localeIn) {
        this.locale = localeIn;
        String customFileName = this.evaluateAbsoluteFileName(fileType);
        Properties properties = new Properties();
        FileOutputStream fos = null;
        try {
            CustomUiBackgroundBean.saveBackgroundValuesToPropertiesFile(properties, this.background);
            CustomUiImageBean.saveImageValuesToPropertiesFile(properties, this.logoLeft);
            CustomUiImageBean.saveImageValuesToPropertiesFile(properties, this.logoRight);
            Message msg1 = new Message("A2001I.default.search.button.label");
            if (this.searchButtonText.equals(msg1.getFormattedText(localeIn))) {
                properties.setProperty("searchButtonText", "");
            } else {
                properties.setProperty("searchButtonText", this.searchButtonText);
            }
            Message msg2 = new Message("A2002I.default.title.bar.label");
            if (this.titleBarText.equals(msg2.getFormattedText(localeIn))) {
                properties.setProperty("titleBarText", "");
            } else {
                properties.setProperty("titleBarText", this.titleBarText);
            }
            properties.setProperty("toolbarBannerEnabled", this.toolbarBannerEnabled);
            properties.setProperty("searchLinksEnabled", this.searchLinksEnabled);
            properties.setProperty("collectionListEnabled", this.collectionListEnabled);
            properties.setProperty("languagePreferencesLinkEnabled", this.languagePreferencesLinkEnabled);
            properties.setProperty("helpLinkEnabled", this.helpLinkEnabled);
            properties.setProperty("searchPageDividerBarEnabled", this.searchPageDividerBarEnabled);
            properties.setProperty("searchResultsSummaryEnabled", this.searchResultsSummaryEnabled);
            properties.setProperty("webSearchEnabled", this.webSearchEnabled);
            properties.setProperty("copyrightEnabled", this.copyrightEnabled);
            properties.setProperty("advancedSearchEnabled", this.advancedSearchLinkEnabled);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultSearchBar);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultHeaderNumber);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultHeaderTitle);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultHeaderRelevancy);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultSummary);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultHighlight);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultFooterDocumentUrl);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultFooterDocumentSize);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultFooterModificationDate);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultFooterHtmlCachedLink);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultFooterOriginalCachedLink);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultNavigationSelected);
            CustomUiFontBean.saveFontValuesToPropertiesFile(properties, this.resultNavigationUnselected);
            Message msg = new Message("A2000I.default.enterprise.label");
            if (this.enterpriseLinkText.equals(msg.getFormattedText(localeIn))) {
                properties.setProperty("enterpriseLinkText", "");
            } else {
                properties.setProperty("enterpriseLinkText", this.enterpriseLinkText);
            }
            fos = new FileOutputStream(customFileName);
            properties.store(fos, null);
        }
        catch (IOException e) {
            if (Loggers.logger.isLoggable(Level.WARNING)) {
                Message msg = new Message("A0710E.UNABLE_TO_ACCESS_CUSTOMIZATION_FILE", customFileName);
                Loggers.logger.log(Level.WARNING, msg);
                System.err.println(msg.getFormattedText());
            }
        }
        finally {
            try {
                if (fos != null) {
                    fos.close();
                }
            }
            catch (Exception ignore) {}
        }
    }

    public synchronized String getCssString() {
        String s = "";
        s = s + "body { \n";
        s = s + "  font-family: Verdana; \n";
        s = s + "  font-size: 12px; \n";
        if (this.background.backgroundEnabled.toLowerCase().equals("true")) {
            s = !this.background.imageRepeatHorizontal.equals("") && !this.background.imageRepeatVertical.equals("") ? s + "  background-repeat: repeat; \n" : (!this.background.imageRepeatHorizontal.equals("") || !this.background.imageRepeatVertical.equals("") ? s + "  background-repeat: " + this.background.imageRepeatHorizontal + this.background.imageRepeatVertical + "; \n" : s + "  background-repeat: no-repeat; \n");
            s = s + "  background-color: " + this.background.backgroundColor + "; \n";
        }
        s = s + "} \n";
        s = s + CustomUiBackgroundBean.getBackgroundCssString(this.background);
        s = s + CustomUiImageBean.getImageCssString(this.logoLeft);
        s = s + CustomUiImageBean.getImageCssString(this.logoRight);
        s = s + CustomUiFontBean.getFontCssString(this.resultHeaderNumber);
        s = s + CustomUiFontBean.getFontCssString(this.resultHeaderTitle);
        s = s + CustomUiFontBean.getFontCssString(this.resultHeaderRelevancy);
        s = s + CustomUiFontBean.getFontCssString(this.resultSummary);
        s = s + CustomUiFontBean.getFontCssString(this.resultHighlight);
        s = s + CustomUiFontBean.getFontCssString(this.resultFooterDocumentUrl);
        s = s + CustomUiFontBean.getFontCssString(this.resultFooterDocumentSize);
        s = s + CustomUiFontBean.getFontCssString(this.resultFooterModificationDate);
        s = s + CustomUiFontBean.getFontCssString(this.resultFooterHtmlCachedLink);
        s = s + CustomUiFontBean.getFontCssString(this.resultFooterOriginalCachedLink);
        return s;
    }

    public boolean isValid(HttpServletRequest request, String errorProperty) {
        return this.getErrors(request, errorProperty).size() == 0;
    }

    public ActionMessages getErrors(HttpServletRequest request, String errorProperty) {
        ActionMessages errors = new ActionMessages();
        return errors;
    }

    private String evaluateAbsoluteFileName(Integer fileType) {
        String fileName = "";
        String directory = this.propertiesAbsoluteDir;
        String fileSuffix = "";
        if (fileType.equals(DEFAULT_FILE_FLAG)) {
            fileName = GlobalConfiguration.getConfiguration().getConfigFileName("customization", "customization_default.properties");
            return fileName;
        }
        if (fileType.equals(PERSISTENT_FILE_FLAG)) {
            fileName = PERSISTENT_FILE_PREFIX;
        } else if (fileType.equals(TEMPORARY_FILE_FLAG)) {
            fileName = TEMPORARY_FILE_PREFIX;
        }
        fileName = fileName + fileSuffix;
        return directory + fileName + ".properties";
    }

    public CustomUiBackgroundBean getBackground() {
        return this.background;
    }

    public void setBackground(CustomUiBackgroundBean background) {
        this.background = background;
    }

    public CustomUiImageBean getLogoLeft() {
        return this.logoLeft;
    }

    public void setLogoLeft(CustomUiImageBean logoLeft) {
        this.logoLeft = logoLeft;
    }

    public CustomUiImageBean getLogoRight() {
        return this.logoRight;
    }

    public void setLogoRight(CustomUiImageBean logoRight) {
        this.logoRight = logoRight;
    }

    public CustomUiFontBean getResultFooterDocumentSize() {
        return this.resultFooterDocumentSize;
    }

    public void setResultFooterDocumentSize(CustomUiFontBean resultFooterDocumentSize) {
        this.resultFooterDocumentSize = resultFooterDocumentSize;
    }

    public CustomUiFontBean getResultFooterDocumentUrl() {
        return this.resultFooterDocumentUrl;
    }

    public void setResultFooterDocumentUrl(CustomUiFontBean resultFooterDocumentUrl) {
        this.resultFooterDocumentUrl = resultFooterDocumentUrl;
    }

    public CustomUiFontBean getResultFooterHtmlCachedLink() {
        return this.resultFooterHtmlCachedLink;
    }

    public void setResultFooterHtmlCachedLink(CustomUiFontBean resultFooterHtmlCachedLink) {
        this.resultFooterHtmlCachedLink = resultFooterHtmlCachedLink;
    }

    public CustomUiFontBean getResultFooterModificationDate() {
        return this.resultFooterModificationDate;
    }

    public void setResultFooterModificationDate(CustomUiFontBean resultFooterModificationDate) {
        this.resultFooterModificationDate = resultFooterModificationDate;
    }

    public CustomUiFontBean getResultFooterOriginalCachedLink() {
        return this.resultFooterOriginalCachedLink;
    }

    public void setResultFooterOriginalCachedLink(CustomUiFontBean resultFooterOriginalCachedLink) {
        this.resultFooterOriginalCachedLink = resultFooterOriginalCachedLink;
    }

    public CustomUiFontBean getResultHeaderNumber() {
        return this.resultHeaderNumber;
    }

    public void setResultHeaderNumber(CustomUiFontBean resultHeaderNumber) {
        this.resultHeaderNumber = resultHeaderNumber;
    }

    public CustomUiFontBean getResultHeaderRelevancy() {
        return this.resultHeaderRelevancy;
    }

    public void setResultHeaderRelevancy(CustomUiFontBean resultHeaderRelevancy) {
        this.resultHeaderRelevancy = resultHeaderRelevancy;
    }

    public CustomUiFontBean getResultHeaderTitle() {
        return this.resultHeaderTitle;
    }

    public void setResultHeaderTitle(CustomUiFontBean resultHeaderTitle) {
        this.resultHeaderTitle = resultHeaderTitle;
    }

    public CustomUiFontBean getResultSummary() {
        return this.resultSummary;
    }

    public void setResultSummary(CustomUiFontBean resultSummary) {
        this.resultSummary = resultSummary;
    }

    public CustomUiFontBean getResultHighlight() {
        return this.resultHighlight;
    }

    public void setResultHighlight(CustomUiFontBean resultHighlight) {
        this.resultHighlight = resultHighlight;
    }

    public String getSearchButtonText() {
        if (this.searchButtonText.equals("")) {
            Message msg = new Message("A2001I.default.search.button.label");
            this.searchButtonText = msg.getFormattedText(this.locale);
        }
        return this.searchButtonText;
    }

    public void setSearchButtonText(String searchButtonText) {
        if (searchButtonText.equals("")) {
            Message msg = new Message("A2001I.default.search.button.label");
            searchButtonText = msg.getFormattedText(this.locale);
        }
        this.searchButtonText = searchButtonText;
    }

    public String getSearchButtonTextEdited() {
        Message msg = new Message("A2001I.default.search.button.label");
        if (this.getSearchButtonText().equals(msg.getFormattedText(this.locale))) {
            return "false";
        }
        return "true";
    }

    public void setSearchButtonTextEdited(String searchButtonTextEdited) {
        this.searchButtonTextEdited = searchButtonTextEdited;
    }

    public String getTitleBarText() {
        if (this.titleBarText.equals("")) {
            Message msg = new Message("A2002I.default.title.bar.label");
            this.titleBarText = msg.getFormattedText(this.locale);
        }
        return this.titleBarText;
    }

    public void setTitleBarText(String titleBarText) {
        if (titleBarText.equals("")) {
            Message msg = new Message("A2002I.default.title.bar.label");
            titleBarText = msg.getFormattedText(this.locale);
        }
        this.titleBarText = titleBarText;
    }

    public String getTitleBarTextEdited() {
        Message msg = new Message("A2002I.default.title.bar.label");
        if (this.getTitleBarText().equals(msg.getFormattedText(this.locale))) {
            return "false";
        }
        return "true";
    }

    public void setTitleBarTextEdited(String titleBarTextEdited) {
        this.titleBarTextEdited = titleBarTextEdited;
    }

    public String getEnterpriseLinkText() {
        if (this.enterpriseLinkText.equals("")) {
            Message msg = new Message("A2000I.default.enterprise.label");
            this.enterpriseLinkText = msg.getFormattedText(this.locale);
        }
        return this.enterpriseLinkText;
    }

    public void setEnterpriseLinkText(String enterpriseLinkText) {
        if (enterpriseLinkText.equals("")) {
            Message msg = new Message("A2000I.default.enterprise.label");
            enterpriseLinkText = msg.getFormattedText(this.locale);
        }
        this.enterpriseLinkText = enterpriseLinkText;
    }

    public String getEnterpriseLinkTextEdited() {
        Message msg = new Message("A2000I.default.enterprise.label");
        if (this.getEnterpriseLinkText().equals(msg.getFormattedText(this.locale))) {
            return "false";
        }
        return "true";
    }

    public void setEnterpriseLinkTextEdited(String enterpriseLinkTextEdited) {
        this.enterpriseLinkTextEdited = enterpriseLinkTextEdited;
    }

    public String getCollectionListEnabled() {
        return this.collectionListEnabled;
    }

    public void setCollectionListEnabled(String collectionListEnabled) {
        this.collectionListEnabled = collectionListEnabled;
    }

    public String getCopyrightEnabled() {
        return this.copyrightEnabled;
    }

    public void setCopyrightEnabled(String copyrightEnabled) {
        this.copyrightEnabled = copyrightEnabled;
    }

    public String getSearchLinksEnabled() {
        return this.searchLinksEnabled;
    }

    public void setSearchLinksEnabled(String searchLinksEnabled) {
        this.searchLinksEnabled = searchLinksEnabled;
    }

    public String getSearchPageDividerBarEnabled() {
        return this.searchPageDividerBarEnabled;
    }

    public void setSearchPageDividerBarEnabled(String searchPageDividerBarEnabled) {
        this.searchPageDividerBarEnabled = searchPageDividerBarEnabled;
    }

    public String getSearchResultsSummaryEnabled() {
        return this.searchResultsSummaryEnabled;
    }

    public void setSearchResultsSummaryEnabled(String searchResultsSummaryEnabled) {
        this.searchResultsSummaryEnabled = searchResultsSummaryEnabled;
    }

    public String getToolbarBannerEnabled() {
        return this.toolbarBannerEnabled;
    }

    public void setToolbarBannerEnabled(String toolbarBannerEnabled) {
        this.toolbarBannerEnabled = toolbarBannerEnabled;
    }

    public String getWebSearchEnabled() {
        return this.webSearchEnabled;
    }

    public void setWebSearchEnabled(String webSearchEnabled) {
        this.webSearchEnabled = webSearchEnabled;
    }

    public List<String> getAvailableImages() {
        return this.availableImages;
    }

    public void setAvailableImages(List<String> availableImages) {
        this.availableImages = availableImages;
    }

    public String getLastRequestedSearchUrl() {
        return this.lastRequestedSearchUrl;
    }

    public void setLastRequestedSearchUrl(String lastRequestedSearchUrl) {
        this.lastRequestedSearchUrl = lastRequestedSearchUrl;
    }

    public String getLanguagePreferencesLinkEnabled() {
        return this.languagePreferencesLinkEnabled;
    }

    public void setLanguagePreferencesLinkEnabled(String languagePreferencesLinkEnabled) {
        this.languagePreferencesLinkEnabled = languagePreferencesLinkEnabled;
    }

    public String getAdvancedSearchLinkEnabled() {
        return this.advancedSearchLinkEnabled;
    }

    public void setAdvancedSearchLinkEnabled(String advancedSearchLinkEnabled) {
        this.advancedSearchLinkEnabled = advancedSearchLinkEnabled;
    }

    public String getSectionPageExpanded() {
        return this.sectionPageExpanded;
    }

    public void setSectionPageExpanded(String sectionPageExpanded) {
        this.sectionPageExpanded = sectionPageExpanded;
    }

    public String getSectionResultsExpanded() {
        return this.sectionResultsExpanded;
    }

    public void setSectionResultsExpanded(String sectionResultsExpanded) {
        this.sectionResultsExpanded = sectionResultsExpanded;
    }

    public String getSectionYahooExpanded() {
        return this.sectionYahooExpanded;
    }

    public void setSectionYahooExpanded(String sectionYahooExpanded) {
        this.sectionYahooExpanded = sectionYahooExpanded;
    }

    public String getSelectedPane() {
        return this.selectedPane;
    }

    public void setSelectedPane(String selectedPane) {
        this.selectedPane = selectedPane;
    }

    public String getYahooFeaturesEnabled() {
        return this.yahooFeaturesEnabled;
    }

    public void setYahooFeaturesEnabled(String yahooFeaturesEnabled) {
    }

    public String getImageUploadRequested() {
        return this.imageUploadRequested;
    }

    public void setImageUploadRequested(String imageUploadRequested) {
        this.imageUploadRequested = imageUploadRequested;
    }

    public String getYahooLinkAudioEnabled() {
        return this.yahooLinkAudioEnabled;
    }

    public void setYahooLinkAudioEnabled(String yahooLinkAudioEnabled) {
    }

    public String getYahooLinkDirectoryEnabled() {
        return this.yahooLinkDirectoryEnabled;
    }

    public void setYahooLinkDirectoryEnabled(String yahooLinkDirectoryEnabled) {
    }

    public String getYahooLinkImagesEnabled() {
        return this.yahooLinkImagesEnabled;
    }

    public void setYahooLinkImagesEnabled(String yahooLinkImagesEnabled) {
    }

    public String getYahooLinkLocalEnabled() {
        return this.yahooLinkLocalEnabled;
    }

    public void setYahooLinkLocalEnabled(String yahooLinkLocalEnabled) {
    }

    public String getYahooLinkNewsEnabled() {
        return this.yahooLinkNewsEnabled;
    }

    public void setYahooLinkNewsEnabled(String yahooLinkNewsEnabled) {
    }

    public String getYahooLinksEnabled() {
        return this.yahooLinksEnabled;
    }

    public void setYahooLinksEnabled(String yahooLinksEnabled) {
    }

    public String getYahooLinkVideoEnabled() {
        return this.yahooLinkVideoEnabled;
    }

    public void setYahooLinkVideoEnabled(String yahooLinkVideoEnabled) {
    }

    public String getYahooLinkWebEnabled() {
        return this.yahooLinkWebEnabled;
    }

    public void setYahooLinkWebEnabled(String yahooLinkWebEnabled) {
    }

    public String getYahooShortcutEnabled() {
        return this.yahooShortcutEnabled;
    }

    public void setYahooShortcutEnabled(String yahooShortcutEnabled) {
    }

    public String getYahooToolbarEnabled() {
        return this.yahooToolbarEnabled;
    }

    public void setYahooToolbarEnabled(String yahooToolbarEnabled) {
    }

    public CustomUiFontBean getResultSearchBar() {
        return this.resultSearchBar;
    }

    public void setResultSearchBar(CustomUiFontBean resultSearchBar) {
        this.resultSearchBar = resultSearchBar;
    }

    public String getHelpLinkEnabled() {
        return this.helpLinkEnabled;
    }

    public void setHelpLinkEnabled(String helpLinkEnabled) {
        this.helpLinkEnabled = helpLinkEnabled;
    }

    public CustomUiFontBean getResultNavigationSelected() {
        return this.resultNavigationSelected;
    }

    public void setResultNavigationSelected(CustomUiFontBean resultNavigationSelected) {
        this.resultNavigationSelected = resultNavigationSelected;
    }

    public CustomUiFontBean getResultNavigationUnselected() {
        return this.resultNavigationUnselected;
    }

    public void setResultNavigationUnselected(CustomUiFontBean resultNavigationUnselected) {
        this.resultNavigationUnselected = resultNavigationUnselected;
    }
}

