/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.admin.beans.BranchBean;
import com.ibm.es.nuvo.common.admin.beans.HttpBasicAuthBean;
import com.ibm.es.nuvo.common.admin.beans.HttpFormAuthBean;
import com.ibm.es.nuvo.common.admin.beans.WebCrawlerBean;
import com.ibm.es.nuvo.common.admin.util.ConfigurationUtils;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.WebCrawlServiceImpl;
import com.ibm.es.nuvo.crawler.framework.configuration.validator.HistoryEntry;
import com.ibm.es.nuvo.crawler.web.configuration.validator.WCValidator;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.crawlspace.HttpAuth;
import com.ibm.es.nuvo.crawlspace.HttpBasicAuth;
import com.ibm.es.nuvo.crawlspace.HttpFormAuth;
import com.ibm.es.nuvo.crawlspace.WebCrawlspace;
import com.ibm.es.nuvo.crawlspace.WebCrawlspaceBranch;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebsiteBean
extends BranchBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected HttpBasicAuthBean httpBasicAuth = new HttpBasicAuthBean();
    protected HttpFormAuthBean httpFormAuth = new HttpFormAuthBean();
    protected String authType = "";
    protected String allowRules = "";
    protected static List<WCValidator.Type> errorCodes = new ArrayList<WCValidator.Type>();

    @Override
    public List<HistoryEntry> validate(String collectionId) throws ExtendedException {
        String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, collectionId);
        HashMap<String, HistoryEntry<WCValidator.Type>> errorMap = new HashMap<String, HistoryEntry<WCValidator.Type>>();
        ArrayList<String> newAllowRules = new ArrayList<String>();
        String massagedRoot = WebCrawlerBean.massageRoot(this.getRoot());
        List<HistoryEntry<WCValidator.Type>> results = WebCrawlServiceImpl.getCrawlService().validate(crawlspaceId, true, massagedRoot, this.getAllowRulesList(), this.getDenyRulesList(), newAllowRules);
        if (results == null) {
            return new ArrayList<HistoryEntry>();
        }
        for (int i = 0; i < results.size(); ++i) {
            HistoryEntry<WCValidator.Type> entry = results.get(i);
            if (!errorCodes.contains((Object)entry.getType())) continue;
            errorMap.put(entry.getKey(), entry);
        }
        this.allowRules = "";
        for (String rule : newAllowRules) {
            this.allowRules = this.allowRules + rule + "\r\n";
        }
        List<HistoryEntry> errors = Arrays.asList(errorMap.values().toArray(new HistoryEntry[0]));
        return errors;
    }

    public void update() throws ExtendedException {
        WebCrawlspaceBranch updatedWebBranch = WebsiteBean.toWebCrawlspaceBranch(this, true);
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(this.crawlerId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        Vector<WebCrawlspaceBranch> webBranches = webCs.getBranches();
        Vector<WebCrawlspaceBranch> updatedWebBranches = new Vector<WebCrawlspaceBranch>(webBranches.size());
        for (WebCrawlspaceBranch webBranch : webBranches) {
            if (webBranch.getRoot().equalsIgnoreCase(updatedWebBranch.getRoot())) continue;
            updatedWebBranches.add(webBranch);
        }
        updatedWebBranches.add(updatedWebBranch);
        webCs.setBranches(updatedWebBranches);
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(this.crawlerId, collCs);
        csMgr.publish(this.crawlerId);
    }

    public static void addWebsite(String collectionId, WebsiteBean websiteBean) throws ExtendedException {
        CollectionCrawlspace collCs;
        WebCrawlspace webCs;
        CollectionCrawlspaceConfigurationManager csConfigMgr = CollectionCrawlspaceConfigurationManager.getConfigurationManager();
        if (!csConfigMgr.crawlspaceExists(collectionId)) {
            CollectionCrawlspace cs = csConfigMgr.createDefaultCrawlspaceConfig();
            csConfigMgr.createCrawlspace(cs, collectionId);
        }
        if ((webCs = (collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(collectionId)).getWebCrawlspace()) == null) {
            webCs = ConfigurationUtils.createDefaultWebCrawlspace();
            collCs.setWebCrawlspace(webCs);
        }
        Vector<WebCrawlspaceBranch> webBranches = webCs.getBranches();
        webBranches.add(WebsiteBean.toWebCrawlspaceBranch(websiteBean));
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(collectionId, collCs);
        csMgr.publish(collectionId);
        String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, collectionId);
        if (!WebCrawlServiceImpl.getCrawlService().isCrawling(crawlspaceId)) {
            WebCrawlServiceImpl.getCrawlService().startCrawl(crawlspaceId, false);
        }
    }

    public static void addWebsites(String collectionId, List<WebsiteBean> websiteBeans) throws ExtendedException {
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(collectionId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        Vector<WebCrawlspaceBranch> webBranches = webCs.getBranches();
        webBranches.clear();
        for (WebsiteBean websiteBean : websiteBeans) {
            webBranches.add(WebsiteBean.toWebCrawlspaceBranch(websiteBean));
        }
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(collectionId, collCs);
        csMgr.publish(collectionId);
    }

    public static void appendWebsites(String collectionId, List<WebsiteBean> websiteBeans) throws ExtendedException {
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(collectionId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        Vector<WebCrawlspaceBranch> webBranches = webCs.getBranches();
        for (WebsiteBean websiteBean : websiteBeans) {
            webBranches.add(WebsiteBean.toWebCrawlspaceBranch(websiteBean));
        }
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(collectionId, collCs);
        csMgr.publish(collectionId);
    }

    public static void delete(String crawlerId, String rootToDelete) throws ExtendedException {
        List<WebsiteBean> websites = WebsiteBean.getWebsites(crawlerId);
        for (int i = 0; i < websites.size(); ++i) {
            String root = websites.get(i).getRoot();
            if (!root.equals(rootToDelete)) continue;
            websites.remove(i);
        }
        WebsiteBean.addWebsites(crawlerId, websites);
    }

    public static WebsiteBean getWebsiteBean(String crawlerId, String root) throws ExtendedException {
        WebCrawlspace webCs = ConfigurationUtils.getWebCrawlspace(crawlerId);
        Vector<WebCrawlspaceBranch> webBranches = webCs.getBranches();
        try {
            root = URLDecoder.decode(root, "UTF-8");
            for (WebCrawlspaceBranch webBranch : webBranches) {
                String webRoot = URLDecoder.decode(webBranch.getRoot(), "UTF-8");
                if (!root.equals(webRoot)) continue;
                return WebsiteBean.toWebsiteBean(crawlerId, webBranch);
            }
        }
        catch (UnsupportedEncodingException e) {
            // empty catch block
        }
        return null;
    }

    public static List<WebsiteBean> getWebsites(String crawlerId) throws ExtendedException {
        ArrayList<WebsiteBean> websites = new ArrayList<WebsiteBean>();
        WebCrawlspace webCs = ConfigurationUtils.getWebCrawlspace(crawlerId);
        if (webCs == null) {
            return websites;
        }
        Vector<WebCrawlspaceBranch> webBranches = webCs.getBranches();
        for (WebCrawlspaceBranch webBranch : webBranches) {
            websites.add(WebsiteBean.toWebsiteBean(crawlerId, webBranch));
        }
        return websites;
    }

    public static WebsiteBean toWebsiteBean(String crawlerId, WebCrawlspaceBranch csBranch) {
        WebsiteBean bean = new WebsiteBean();
        bean.setCrawlerId(crawlerId);
        bean.setRoot(csBranch.getRoot());
        bean.setAllowRulesList(csBranch.getAllowRules());
        bean.setDenyRules(csBranch.getDenyPatterns());
        HttpAuth httpAuth = csBranch.getHttpAuth();
        if (httpAuth != null) {
            if (httpAuth instanceof HttpBasicAuth) {
                bean.setHttpBasicAuth(new HttpBasicAuthBean(crawlerId, (HttpBasicAuth)httpAuth));
                bean.setAuthType("Basic");
            } else if (httpAuth instanceof HttpFormAuth) {
                bean.setHttpFormAuth(new HttpFormAuthBean(crawlerId, (HttpFormAuth)httpAuth));
                bean.setAuthType("Form");
            }
        }
        return bean;
    }

    public void setAllowRulesList(Vector<String> allowRules) {
        this.allowRules = "";
        for (String currentRule : allowRules) {
            this.allowRules = this.allowRules + currentRule + "\r\n";
        }
    }

    public static WebCrawlspaceBranch toWebCrawlspaceBranch(WebsiteBean websiteBean, boolean isUpdate) {
        WebCrawlspaceBranch branch = new WebCrawlspaceBranch();
        String url = WebCrawlerBean.massageRoot(websiteBean.getRoot());
        branch.setRoot(url);
        if (!isUpdate) {
            if (websiteBean.allowRules != null && websiteBean.allowRules.length() > 0) {
                for (String currentRule : websiteBean.getAllowRulesList()) {
                    branch.addAllowRule(currentRule);
                }
            }
        } else {
            for (String currentRule : websiteBean.getAllowRulesList()) {
                branch.addAllowRule(currentRule);
            }
        }
        branch.setDenyPatterns(websiteBean.getDenyRulesList());
        String authType = websiteBean.getAuthType();
        if (StringUtils.empty(authType)) {
            branch.setHttpAuth(null);
        } else if (authType.equalsIgnoreCase("Basic")) {
            branch.setHttpAuth(HttpBasicAuthBean.toHttpBasicAuth(websiteBean.getHttpBasicAuth()));
        } else if (authType.equalsIgnoreCase("Form")) {
            branch.setHttpAuth(HttpFormAuthBean.toHttpFormAuth(websiteBean.getHttpFormAuth()));
        }
        return branch;
    }

    public static WebCrawlspaceBranch toWebCrawlspaceBranch(WebsiteBean websiteBean) {
        return WebsiteBean.toWebCrawlspaceBranch(websiteBean, false);
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public HttpBasicAuthBean getHttpBasicAuth() {
        return this.httpBasicAuth;
    }

    public void setHttpBasicAuth(HttpBasicAuthBean httpBasicAuth) {
        this.httpBasicAuth = httpBasicAuth;
    }

    public HttpFormAuthBean getHttpFormAuth() {
        return this.httpFormAuth;
    }

    public void setHttpFormAuth(HttpFormAuthBean httpFormAuth) {
        this.httpFormAuth = httpFormAuth;
    }

    public String getAllowRules() {
        return this.allowRules;
    }

    public Vector<String> getAllowRulesList() {
        Vector<String> vector = new Vector<String>();
        if (StringUtils.empty(this.allowRules)) {
            return vector;
        }
        StringTokenizer st = new StringTokenizer(this.allowRules, "\r\n");
        while (st.hasMoreTokens()) {
            vector.add(st.nextToken());
        }
        return vector;
    }

    public void setAllowRules(String allowRules) {
        if (!StringUtils.empty(allowRules) && !allowRules.endsWith("\r\n")) {
            allowRules = allowRules + "\r\n";
        }
        this.allowRules = allowRules;
    }

    static {
        errorCodes.add(WCValidator.Type.INVALID_URL);
        errorCodes.add(WCValidator.Type.UNKNOWN_HOST);
        errorCodes.add(WCValidator.Type.BAD_DNS);
        errorCodes.add(WCValidator.Type.BAD_ROBOTS);
        errorCodes.add(WCValidator.Type.ROBOTS_DISALLOW);
        errorCodes.add(WCValidator.Type.PAGE_NOT_FOUND);
        errorCodes.add(WCValidator.Type.NO_LINK_FOUND);
        errorCodes.add(WCValidator.Type.BAD_PROXY);
    }
}

