/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.admin.beans.HttpProxyServerBean;
import com.ibm.es.nuvo.common.admin.beans.WebsiteBean;
import com.ibm.es.nuvo.common.admin.util.ConfigurationUtils;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.WebCrawlServiceImpl;
import com.ibm.es.nuvo.crawler.CrawlerMonitor;
import com.ibm.es.nuvo.crawler.web.WebCrawler;
import com.ibm.es.nuvo.crawler.web.admin.WCMonitor;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.crawlspace.WebCrawlspace;
import com.ibm.es.nuvo.util.Constants;
import com.ibm.es.nuvo.util.StringUtils;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebCrawlerBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected WCMonitor monitor = null;
    protected String crawlerId = "";
    protected String collectionId = "";
    protected String emailAddress = "";
    protected String userAgent = "";
    protected String crawlerPoliteness = "";
    protected HttpProxyServerBean httpProxyServerBean = new HttpProxyServerBean();
    protected List<WebsiteBean> websiteBeans = Collections.EMPTY_LIST;

    public WebCrawlerBean() {
    }

    public WebCrawlerBean(String collectionId) {
        this();
        this.collectionId = collectionId;
        this.crawlerId = collectionId;
    }

    public boolean isDup(WebsiteBean wsBean) {
        if (wsBean == null) {
            return false;
        }
        String root = WebCrawlerBean.massageRoot(wsBean.getRoot());
        List<WebsiteBean> existingBeans = this.getWebsiteBeans();
        for (WebsiteBean existingBean : existingBeans) {
            if (!root.equals(existingBean.getRoot())) continue;
            return true;
        }
        return false;
    }

    public static boolean crawlerExists(String aCollectionId) {
        return ConfigurationUtils.getWebCrawlService().crawlspaceExistsForCollection(aCollectionId);
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public String getCrawlerPoliteness() {
        return this.crawlerPoliteness;
    }

    public void setCrawlerPoliteness(String crawlerPoliteness) {
        this.crawlerPoliteness = crawlerPoliteness;
    }

    public String getEmailAddress() {
        return this.emailAddress;
    }

    public void setEmailAddress(String emailAddress) {
        this.emailAddress = emailAddress;
    }

    public String getUserAgent() {
        return this.userAgent;
    }

    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    public List<WebsiteBean> getWebsiteBeans() {
        return this.websiteBeans;
    }

    public void setWebsiteBeans(List<WebsiteBean> websiteBeans) {
        this.websiteBeans = websiteBeans;
    }

    public static WebCrawlerBean retrieve(String collectionId) throws ExtendedException {
        return WebCrawlerBean.toWebCrawlerBean(collectionId);
    }

    public static WebCrawlerBean toWebCrawlerBean(String collectionId) throws ExtendedException {
        WebCrawlerBean wcBean = new WebCrawlerBean(collectionId);
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspace(collectionId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        wcBean.setHttpProxyServerBean(HttpProxyServerBean.getHttpProxyServer(collectionId));
        wcBean.setEmailAddress(webCs.getEmailId());
        wcBean.setUserAgent(webCs.getCrawlerName());
        int p = webCs.getPolitness();
        wcBean.setCrawlerPoliteness(String.valueOf(p));
        wcBean.setMonitor(WCMonitor.forName(collectionId));
        wcBean.setWebsiteBeans(WebsiteBean.getWebsites(collectionId));
        return wcBean;
    }

    public void update() throws ExtendedException {
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(this.crawlerId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        webCs.setEmailId(this.getEmailAddress());
        if (!StringUtils.empty(this.getCrawlerPoliteness())) {
            webCs.setPolitness(Integer.valueOf(this.getCrawlerPoliteness()));
        }
        webCs.setCrawlerName(this.getUserAgent());
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(this.crawlerId, collCs);
        csMgr.publish(this.crawlerId);
    }

    public String getCrawlerId() {
        return this.crawlerId;
    }

    public void setCrawlerId(String crawlerId) {
        this.crawlerId = crawlerId;
    }

    public String getCrawlerState() {
        try {
            String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.collectionId);
            GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
            WebCrawler webCrawler = globalSystem.getWebCrawler();
            if (webCrawler != null && WebCrawlerBean.crawlerExists(this.collectionId)) {
                CrawlerMonitor.CrawlerState state = webCrawler.getCrawlSpaceState(crawlspaceId);
                if (CrawlerMonitor.CrawlerState.IDLE.equals((Object)state)) {
                    return "IDLE";
                }
                if (CrawlerMonitor.CrawlerState.CRAWLING.equals((Object)state)) {
                    return "CRAWLING";
                }
                return "INACTIVE";
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "INACTIVE";
    }

    public boolean isIdle() {
        try {
            String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.collectionId);
            GlobalSystem globalSystem = GlobalSystem.getSingleInstance();
            WebCrawler webCrawler = globalSystem.getWebCrawler();
            if (webCrawler != null && WebCrawlerBean.crawlerExists(this.collectionId)) {
                CrawlerMonitor.CrawlerState state = webCrawler.getCrawlSpaceState(crawlspaceId);
                return CrawlerMonitor.CrawlerState.IDLE.equals((Object)state);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isRunning() {
        try {
            String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.collectionId);
            return WebCrawlServiceImpl.getCrawlService().isCrawling(crawlspaceId);
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void stop() throws ExtendedException {
        if (this.isRunning()) {
            WebCrawlServiceImpl.getCrawlService().stopCrawl(CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.collectionId));
        }
    }

    public void start(boolean fullRecrawl) throws ExtendedException {
        if (!this.isRunning()) {
            WebCrawlServiceImpl.getCrawlService().startCrawl(CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.collectionId), fullRecrawl);
        }
    }

    public List<String> getForbiddenHosts() throws ExtendedException {
        return WebCrawlServiceImpl.getCrawlService().getForbiddenHosts(CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.collectionId));
    }

    public List<String> getRecentlyCrawledUrls() {
        if (this.monitor == null) {
            return Collections.EMPTY_LIST;
        }
        List<String> allRecentUrls = this.monitor.getRecentlyCrawledURLs();
        int max = 20;
        if (allRecentUrls.size() < 20) {
            max = allRecentUrls.size();
        }
        ArrayList<String> recentUrls = new ArrayList<String>(max);
        for (int i = 0; i < max; ++i) {
            recentUrls.add(allRecentUrls.get(i));
        }
        Collections.reverse(recentUrls);
        return recentUrls;
    }

    public String getUrlsCrawledPerMinute() {
        try {
            return NumberFormat.getInstance().format(this.monitor.getThroughput());
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getUrlsCrawledThisSession() {
        try {
            return NumberFormat.getInstance().format(this.monitor.getNURLsReportedThisSession());
        }
        catch (Exception e) {
            return "0";
        }
    }

    public String getLastCrawlDate() {
        return null;
    }

    public static String massageRoot(String url) {
        String newUrl = WebCrawlerBean.prefixHttp(url);
        return newUrl;
    }

    public static String prefixHttp(String url) {
        if ((url = url.trim()).charAt(0) == '*') {
            return url;
        }
        if (!url.startsWith("http://") && !url.startsWith("https://")) {
            return "http://" + url;
        }
        return url;
    }

    public HttpProxyServerBean getHttpProxyServerBean() {
        return this.httpProxyServerBean;
    }

    public void setHttpProxyServerBean(HttpProxyServerBean httpProxyServerBean) {
        this.httpProxyServerBean = httpProxyServerBean;
    }

    public WCMonitor getMonitor() {
        return this.monitor;
    }

    public void setMonitor(WCMonitor monitor) {
        this.monitor = monitor;
    }
}

