/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import java.io.ByteArrayInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class UrlStatus {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String status = null;
    protected String lastCrawlDate = null;
    protected String nextCrawlDate = null;
    protected String lastModifiedTime = null;
    protected String lastHttpCode = null;
    protected String referringUrl = null;

    public UrlStatus(String xml) throws ExtendedException {
        try {
            DOMResult domResult = new DOMResult();
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.transform(new StreamSource(new ByteArrayInputStream(xml.getBytes())), domResult);
            Node node = domResult.getNode();
            Node urlStatus = node.getFirstChild();
            NodeList children = urlStatus.getChildNodes();
            int length = children.getLength();
            Node child = null;
            String childNodeName = null;
            for (int i = 0; i < length; ++i) {
                child = children.item(i);
                childNodeName = child.getNodeName();
                if ("Url".equalsIgnoreCase(childNodeName)) {
                    this.status = child.getAttributes().getNamedItem("Status").getNodeValue();
                    continue;
                }
                if ("LastCrawlDate".equalsIgnoreCase(childNodeName)) {
                    this.lastCrawlDate = child.getAttributes().getNamedItem("Value").getNodeValue();
                    continue;
                }
                if ("NextCrawlDate".equalsIgnoreCase(childNodeName)) {
                    this.nextCrawlDate = child.getAttributes().getNamedItem("Value").getNodeValue();
                    continue;
                }
                if ("LastHTTPCode".equalsIgnoreCase(childNodeName)) {
                    this.lastHttpCode = child.getAttributes().getNamedItem("Value").getNodeValue();
                    continue;
                }
                if ("ReferringURL".equalsIgnoreCase(childNodeName)) {
                    this.referringUrl = child.getAttributes().getNamedItem("Value").getNodeValue();
                    continue;
                }
                if ("IndexFlag".equalsIgnoreCase(childNodeName) || !"LastModifiedTime".equalsIgnoreCase(childNodeName)) continue;
                this.lastModifiedTime = child.getAttributes().getNamedItem("Value").getNodeValue();
            }
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
    }

    public String getLastHttpCode() {
        return this.lastHttpCode;
    }

    public void setLastHttpCode(String lastHttpCode) {
        this.lastHttpCode = lastHttpCode;
    }

    public String getReferringUrl() {
        return this.referringUrl;
    }

    public void setReferringUrl(String referringUrl) {
        this.referringUrl = referringUrl;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getLastCrawlDate() {
        return this.lastCrawlDate;
    }

    public void setLastCrawlDate(String lastCrawlDate) {
        this.lastCrawlDate = lastCrawlDate;
    }

    public String getLastModifiedTime() {
        return this.lastModifiedTime;
    }

    public void setLastModifiedTime(String lastModifiedTime) {
        this.lastModifiedTime = lastModifiedTime;
    }

    public String getNextCrawlDate() {
        return this.nextCrawlDate;
    }

    public void setNextCrawlDate(String nextCrawlDate) {
        this.nextCrawlDate = nextCrawlDate;
    }
}

