/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.spell.querylog.QueryRuntimeStatistics;
import java.util.Vector;

public class SystemStatusBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public String getAverageNumberQueriesPerMinute() {
        try {
            QueryRuntimeStatistics instance = GlobalSystem.getSingleInstance().getQueryRuntimeStatistics();
            return String.valueOf(instance.getAverageNumberQueriesPerMinute());
        }
        catch (Exception exception) {
            return "n/a";
        }
    }

    public String getAverageQueriesResponseTime() {
        try {
            QueryRuntimeStatistics instance = GlobalSystem.getSingleInstance().getQueryRuntimeStatistics();
            return String.valueOf(instance.getAverageQueriesResponseTime());
        }
        catch (Exception exception) {
            return "n/a";
        }
    }

    public String getTotalSize() {
        try {
            long totalSize = 0L;
            ConfigurationManager configMgr = GlobalSystem.getSingleInstance().getConfigurationManager();
            IndexerMonitor indexerMonitor = GlobalSystem.getSingleInstance().getIndexerMonitor();
            Vector<String> collections = configMgr.getCollectionIds();
            for (String col : collections) {
                totalSize += indexerMonitor.getIndexSize(col);
            }
            return String.valueOf(totalSize / 0x100000L);
        }
        catch (Exception exception) {
            return "n/a";
        }
    }

    public String getTotalNumberOfDocs() {
        try {
            long totalNumDocs = 0L;
            ConfigurationManager configMgr = GlobalSystem.getSingleInstance().getConfigurationManager();
            IndexerMonitor indexerMonitor = GlobalSystem.getSingleInstance().getIndexerMonitor();
            Vector<String> collections = configMgr.getCollectionIds();
            for (String col : collections) {
                totalNumDocs += indexerMonitor.getNumberOfDocuments(col);
            }
            return String.valueOf(totalNumDocs);
        }
        catch (Exception exception) {
            return "n/a";
        }
    }
}

