/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.synonym.factory.SynonymGroup;
import com.ibm.es.nuvo.synonym.factory.SynonymGroups;
import com.ibm.es.nuvo.synonym.index.SynonymIndexReader;
import com.ibm.es.nuvo.synonym.request.AddSynonymRequest;
import com.ibm.es.nuvo.synonym.request.ImportSynonymRequest;
import com.ibm.es.nuvo.synonym.request.RemoveSynonymRequest;
import com.ibm.es.nuvo.synonym.request.ReplaceSynonymRequest;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class SynonymBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String collectionId = "";
    protected String id = "";
    protected String synonyms = "";

    public SynonymBean() {
    }

    public SynonymBean(String collectionId) {
        this();
        this.collectionId = collectionId;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void create() throws ExtendedException {
        AddSynonymRequest request = new AddSynonymRequest(SynonymBean.toSynonymGroup(this));
        ConfigurationManager.getConfigurationManager().updateCollection(this.collectionId, request);
    }

    public void delete() throws ExtendedException {
        SynonymBean.delete(this.collectionId, this.id);
    }

    public void replace() throws ExtendedException {
        ReplaceSynonymRequest request = new ReplaceSynonymRequest(this.id, SynonymBean.toSynonymGroup(this));
        ConfigurationManager.getConfigurationManager().updateCollection(this.collectionId, request);
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<SynonymGroup>");
        sb.append("<collectionId>");
        sb.append(this.getCollectionId());
        sb.append("</collectionId>");
        sb.append("<id>");
        sb.append(this.getId());
        sb.append("</id>");
        sb.append("<synonyms>");
        sb.append(this.getSynonyms());
        sb.append("</synonyms>");
        sb.append("</SynonymGroup>");
        return sb.toString();
    }

    public static String toXml(String collectionId, String synonymId) throws ExtendedException {
        return SynonymBean.retrieve(collectionId, synonymId).toXml();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SynonymBean retrieve(String collectionId, String synonymId) throws ExtendedException {
        SynonymIndexReader reader = null;
        SynonymBean sBean = null;
        try {
            reader = SynonymIndexReader.open(collectionId);
            SynonymGroup synonymGroup = reader.get(synonymId);
            sBean = SynonymBean.fromSynonymGroup(collectionId, synonymGroup);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return sBean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List retrieveAll(String collectionId) throws ExtendedException {
        ArrayList<SynonymBean> synonymBeans = new ArrayList<SynonymBean>();
        SynonymGroups synonymGroups = null;
        SynonymIndexReader reader = null;
        try {
            if (SynonymIndexReader.indexExists(collectionId)) {
                reader = SynonymIndexReader.open(collectionId);
                synonymGroups = reader.getSynonymGroups();
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        if (null != synonymGroups) {
            for (SynonymGroup synonymGroup : synonymGroups) {
                SynonymBean synonymBean = SynonymBean.fromSynonymGroup(collectionId, synonymGroup);
                synonymBeans.add(synonymBean);
            }
        }
        return synonymBeans;
    }

    public String getSynonyms() {
        return this.synonyms;
    }

    public String getSynonymsForDisplay() {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.synonyms, "\r\n");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void setSynonyms(String synonyms) {
        this.synonyms = synonyms;
    }

    public static void importAll(String collectionId, InputStream is) throws ExtendedException {
        ImportSynonymRequest request = new ImportSynonymRequest(is);
        ConfigurationManager.getConfigurationManager().updateCollection(collectionId, request);
    }

    public static byte[] exportAll(String collectionId) throws ExtendedException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SynonymIndexReader reader = null;
        try {
            reader = SynonymIndexReader.open(collectionId);
            reader.exportToXML(baos, "utf-8");
        }
        catch (Exception e) {
            Message msg = new Message("A0152E.UNABLE_TO_EXPORT_SYNONYMS");
            msg.addArgument(collectionId);
            throw new ExtendedException(msg, (Throwable)e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return baos.toByteArray();
    }

    public static void delete(String collectionId, String synonymId) throws ExtendedException {
        RemoveSynonymRequest request = new RemoveSynonymRequest(synonymId);
        ConfigurationManager.getConfigurationManager().updateCollection(collectionId, request);
    }

    public static SynonymGroup toSynonymGroup(SynonymBean synonymBean) {
        SynonymGroup synonymGroup = new SynonymGroup();
        StringTokenizer st = new StringTokenizer(synonymBean.getSynonyms(), "\r\n");
        while (st.hasMoreTokens()) {
            synonymGroup.add(st.nextToken());
        }
        return synonymGroup;
    }

    public static SynonymBean fromSynonymGroup(String collectionId, SynonymGroup synonymGroup) {
        SynonymBean synBean = new SynonymBean(collectionId);
        synBean.setId(synonymGroup.getBase64Key());
        StringBuffer sb = new StringBuffer();
        Iterator it = synonymGroup.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
            if (!it.hasNext()) continue;
            sb.append("\r\n");
        }
        synBean.setSynonyms(sb.toString());
        return synBean;
    }
}

