/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.quicklinks.factory.IKeyword;
import com.ibm.es.nuvo.quicklinks.factory.IKeywords;
import com.ibm.es.nuvo.quicklinks.factory.IPageLanguage;
import com.ibm.es.nuvo.quicklinks.factory.IPageLanguages;
import com.ibm.es.nuvo.quicklinks.factory.IQuickLink;
import com.ibm.es.nuvo.quicklinks.factory.IQuickLinks;
import com.ibm.es.nuvo.quicklinks.factory.Keyword;
import com.ibm.es.nuvo.quicklinks.factory.Keywords;
import com.ibm.es.nuvo.quicklinks.factory.PageLanguage;
import com.ibm.es.nuvo.quicklinks.factory.PageLanguages;
import com.ibm.es.nuvo.quicklinks.factory.QuickLink;
import com.ibm.es.nuvo.quicklinks.index.AddQuicklinkRequest;
import com.ibm.es.nuvo.quicklinks.index.DeleteQuicklinkRequest;
import com.ibm.es.nuvo.quicklinks.index.ImportQuicklinkRequest;
import com.ibm.es.nuvo.quicklinks.index.QuicklinksReader;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;

public class QuickLinkBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String collectionId = "";
    protected String id = "";
    protected String url = "";
    protected String keywords = "";
    protected String title = "";
    protected String summary = "";
    protected String rank = "";
    protected String pageLanguages = "";

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public String getKeywords() {
        return this.keywords;
    }

    public String getKeywordsForDisplay() {
        StringBuffer sb = new StringBuffer();
        StringTokenizer st = new StringTokenizer(this.keywords, "\r\n");
        while (st.hasMoreTokens()) {
            sb.append(st.nextToken());
            if (!st.hasMoreTokens()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void setKeywords(String keywords) {
        this.keywords = keywords;
    }

    public String getSummary() {
        return this.summary;
    }

    public void setSummary(String summary) {
        this.summary = summary;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getPageLanguages() {
        return this.pageLanguages;
    }

    public void setPageLanguages(String pageLanguages) {
        this.pageLanguages = pageLanguages;
    }

    public String getRank() {
        return this.rank;
    }

    public void setRank(String rank) {
        this.rank = rank;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public void delete() throws ExtendedException {
        QuickLinkBean.delete(this.collectionId, this.getId());
    }

    public void replace() throws ExtendedException {
        this.create();
    }

    public void create() throws ExtendedException {
        AddQuicklinkRequest request = new AddQuicklinkRequest(QuickLinkBean.toQuickLink(this.collectionId, this));
        ConfigurationManager.getConfigurationManager().updateCollection(this.collectionId, request);
    }

    public static IQuickLink toQuickLink(String collectionId, QuickLinkBean qlBean) {
        QuickLink quickLink = new QuickLink();
        quickLink.setID(qlBean.getId());
        quickLink.setRank(qlBean.getRank());
        quickLink.setSummary(qlBean.getSummary());
        quickLink.setTitle(qlBean.getTitle());
        String url = qlBean.getUrl();
        try {
            URI testUri = URI.create(url);
            if (testUri.getScheme() == null) {
                url = "http://" + url;
            }
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        quickLink.setURL(url);
        String keywords = qlBean.getKeywords();
        Keywords iKeywords = new Keywords();
        StringTokenizer keywordTokenizer = new StringTokenizer(keywords, "\r\n");
        Keyword keyword = null;
        while (keywordTokenizer.hasMoreTokens()) {
            keyword = new Keyword();
            keyword.setValue(keywordTokenizer.nextToken());
            iKeywords.addKeyword(keyword);
        }
        quickLink.setKeywords(iKeywords);
        String pageLanguages = qlBean.getPageLanguages();
        if (!StringUtils.empty(pageLanguages)) {
            PageLanguages iPageLanguages = new PageLanguages();
            StringTokenizer pageLanguageTokenizer = new StringTokenizer(pageLanguages, "\r\n");
            PageLanguage pageLanguage = null;
            while (pageLanguageTokenizer.hasMoreTokens()) {
                pageLanguage = new PageLanguage();
                pageLanguage.setValue(pageLanguageTokenizer.nextToken());
                iPageLanguages.addPageLanguage(pageLanguage);
            }
            quickLink.setPageLanguages(iPageLanguages);
        }
        return quickLink;
    }

    public static QuickLinkBean fromQuickLink(String collectionId, IQuickLink quickLink) {
        QuickLinkBean qlBean = new QuickLinkBean();
        qlBean.setCollectionId(collectionId);
        qlBean.setId(quickLink.getID());
        qlBean.setRank(quickLink.getRank());
        qlBean.setSummary(quickLink.getSummary());
        qlBean.setTitle(quickLink.getTitle());
        qlBean.setUrl(quickLink.getURL());
        IKeywords iKeywords = quickLink.getKeywords();
        IKeyword[] keywordArray = iKeywords.getKeywords();
        IKeyword keyword = null;
        StringBuffer keywords = new StringBuffer();
        int keywordCnt = keywordArray.length;
        for (int i = 0; i < keywordCnt; ++i) {
            keyword = keywordArray[i];
            keywords.append(keyword.getValue());
            if (i + 1 >= keywordCnt) continue;
            keywords.append("\r\n");
        }
        qlBean.setKeywords(keywords.toString());
        String pageLanguagesStr = null;
        IPageLanguages iPageLanguages = quickLink.getPageLanguages();
        if (iPageLanguages != null) {
            IPageLanguage[] pageLanguageArray = iPageLanguages.getPageLanguages();
            IPageLanguage pageLanguage = null;
            StringBuffer pageLanguages = new StringBuffer();
            int pageLanguageCnt = pageLanguageArray.length;
            for (int i = 0; i < pageLanguageCnt; ++i) {
                pageLanguage = pageLanguageArray[i];
                pageLanguages.append(pageLanguage.getValue());
                if (i + 1 >= pageLanguageCnt) continue;
                pageLanguages.append("\r\n");
            }
            pageLanguagesStr = pageLanguages.toString();
        }
        qlBean.setPageLanguages(pageLanguagesStr);
        return qlBean;
    }

    public static QuickLinkBean retrieve(String collectionId, String quickLinkId) throws ExtendedException {
        QuicklinksReader qlReader = null;
        QuickLinkBean qlBean = null;
        try {
            qlReader = QuicklinksReader.open(collectionId);
            IQuickLinks quickLinks = qlReader.getQuicklinks();
            IQuickLink[] qlArray = quickLinks.getQuicklinks();
            for (int i = 0; i < qlArray.length; ++i) {
                IQuickLink ql = qlArray[i];
                if (!ql.getID().equals(quickLinkId)) continue;
                QuickLinkBean quickLinkBean = QuickLinkBean.fromQuickLink(collectionId, ql);
                return quickLinkBean;
            }
        }
        catch (Exception e) {
            Message msg = new Message("A0141E.UNABLE_TO_RETRIEVE_QUICKLINKS");
            msg.addArgument(collectionId);
            throw new ExtendedException(msg, (Throwable)e);
        }
        finally {
            if (qlReader != null) {
                try {
                    qlReader.close();
                }
                catch (IOException e) {}
            }
        }
        return qlBean;
    }

    public static List retrieveAll(String collectionId) throws ExtendedException {
        ArrayList<QuickLinkBean> quickLinkBeans = new ArrayList<QuickLinkBean>();
        QuicklinksReader qlReader = null;
        IQuickLinks quickLinks = null;
        try {
            try {
                qlReader = QuicklinksReader.open(collectionId);
            }
            catch (Exception e) {
                List list = Collections.EMPTY_LIST;
                if (qlReader != null) {
                    try {
                        qlReader.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return list;
            }
            quickLinks = qlReader.getQuicklinks();
        }
        catch (Exception e) {
            Message msg = new Message("A0141E.UNABLE_TO_RETRIEVE_QUICKLINKS");
            msg.addArgument(collectionId);
            throw new ExtendedException(msg, (Throwable)e);
        }
        finally {
            if (qlReader != null) {
                try {
                    qlReader.close();
                }
                catch (IOException e) {}
            }
        }
        IQuickLink[] qlArray = quickLinks.getQuicklinks();
        if (qlArray == null) {
            return Collections.EMPTY_LIST;
        }
        QuickLinkBean qlBean = null;
        for (int i = 0; i < qlArray.length; ++i) {
            IQuickLink ql = qlArray[i];
            qlBean = QuickLinkBean.fromQuickLink(collectionId, ql);
            quickLinkBeans.add(qlBean);
        }
        return quickLinkBeans;
    }

    public static void delete(String collectionId, String quickLinkId) throws ExtendedException {
        DeleteQuicklinkRequest request = new DeleteQuicklinkRequest(quickLinkId);
        ConfigurationManager.getConfigurationManager().updateCollection(collectionId, request);
    }

    public static void importAll(String collectionId, InputStream is) throws ExtendedException {
        ImportQuicklinkRequest request = new ImportQuicklinkRequest(is);
        ConfigurationManager.getConfigurationManager().updateCollection(collectionId, request);
    }

    public static byte[] exportAll(String collectionId) throws ExtendedException {
        QuicklinksReader qlReader = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            qlReader = QuicklinksReader.open(collectionId);
            qlReader.writeQuicklinks(baos);
        }
        catch (Exception e) {
            Message msg = new Message("A0157E.UNABLE_TO_EXPORT_QUICKLINKS");
            msg.addArgument(collectionId);
            throw new ExtendedException(msg, (Throwable)e);
        }
        finally {
            if (qlReader != null) {
                try {
                    qlReader.close();
                }
                catch (IOException e) {}
            }
        }
        return baos.toByteArray();
    }
}

