/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.util.XMLDOMUtils;
import com.ibm.supa.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.struts.action.ActionForm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class ParserSettingsBean
extends ActionForm
implements Cloneable {
    Document doc;
    private File parserFile;
    private static final long serialVersionUID = 1L;
    private String collectionId = null;
    private String readField = null;
    private String writeField = null;
    LinkedHashMap<String, String> rulesHashMap = null;
    private String rulesString = "";

    public ParserSettingsBean() {
    }

    public ParserSettingsBean(String collectionId) throws ParserConfigurationException, SAXException, IOException {
        this.collectionId = collectionId;
        this.parserFile = new File(ConfigurationLoader.getSupaDirectoryPath(collectionId), "preparse-config.xml");
        this.doc = XMLDOMUtils.readAsNonValidatingDOM(this.parserFile);
        this.getDataFromXML();
    }

    public void getDataFromXML() {
        this.getReadFieldFromXML();
        this.getWriteFieldFromXML();
        this.getRulesFromXML();
    }

    public void getReadFieldFromXML() {
        NodeList listOfProperties = this.doc.getElementsByTagName("property");
        int numberOfProperties = listOfProperties.getLength();
        for (int i = 0; i < numberOfProperties; ++i) {
            String value;
            String name = listOfProperties.item(i).getAttributes().getNamedItem("name").getNodeValue();
            if (name.compareTo("readField") != 0) continue;
            this.readField = value = listOfProperties.item(i).getAttributes().getNamedItem("value").getNodeValue();
        }
    }

    public void getWriteFieldFromXML() {
        NodeList listOfProperties = this.doc.getElementsByTagName("property");
        int numberOfProperties = listOfProperties.getLength();
        for (int i = 0; i < numberOfProperties; ++i) {
            String value;
            String name = listOfProperties.item(i).getAttributes().getNamedItem("name").getNodeValue();
            if (name.compareTo("writeField") != 0) continue;
            this.writeField = value = listOfProperties.item(i).getAttributes().getNamedItem("value").getNodeValue();
        }
    }

    public void getRulesFromXML() {
        NodeList listOfEntries = this.doc.getElementsByTagName("entry");
        int numberOfEntries = listOfEntries.getLength();
        this.rulesHashMap = new LinkedHashMap();
        StringBuilder rulesBuf = new StringBuilder();
        rulesBuf.append(numberOfEntries).append('{');
        for (int i = 0; i < numberOfEntries; ++i) {
            String key = listOfEntries.item(i).getAttributes().getNamedItem("key").getNodeValue();
            String value = listOfEntries.item(i).getAttributes().getNamedItem("value").getNodeValue();
            this.rulesHashMap.put(key, value);
            rulesBuf.append(key).append('\t').append(value).append('\n');
        }
        rulesBuf.append('}');
        this.rulesString = rulesBuf.toString();
    }

    public void setRulesHashMap() {
        int firstChar = this.rulesString.indexOf(123);
        int numberOfRules = Integer.parseInt(this.rulesString.substring(0, firstChar));
        String tempRulesString = this.rulesString.substring(firstChar + 1);
        this.rulesHashMap.clear();
        for (int i = 0; i < numberOfRules; ++i) {
            int signIndex = i == numberOfRules - 1 ? tempRulesString.lastIndexOf(125) : tempRulesString.indexOf(10);
            String currRule = tempRulesString.substring(0, signIndex);
            tempRulesString = tempRulesString.substring(signIndex + 1);
            signIndex = currRule.indexOf(9);
            String regularExpression = currRule.substring(0, signIndex);
            String value = currRule.substring(signIndex + 1);
            this.rulesHashMap.put(regularExpression, value);
        }
    }

    public String getRulesString() {
        return this.rulesString;
    }

    public void setRulesString(String rs) {
        this.rulesString = rs;
        this.setRulesHashMap();
    }

    public String getReadField() {
        return this.readField;
    }

    public void setReadField(String rf) {
        this.readField = rf;
    }

    public String getWriteField() {
        return this.writeField;
    }

    public void setWriteField(String wf) {
        this.writeField = wf;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public void setReadFieldToXML() throws TransformerException, IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("value", this.readField);
        Element[] elements = XMLDOMUtils.getElements("/beans/bean/property@name=readField", this.doc, 1);
        XMLDOMUtils.setNodeValueTo(elements[0], null, attributes);
    }

    public void setWriteFieldToXML() throws TransformerException, IOException {
        HashMap<String, String> attributes = new HashMap<String, String>();
        attributes.put("value", this.writeField);
        Element[] elements = XMLDOMUtils.getElements("/beans/bean/property@name=writeField", this.doc, 1);
        XMLDOMUtils.setNodeValueTo(elements[0], null, attributes);
    }

    public void setRulesToXML() throws TransformerException, IOException {
        Vector<Element> entry = XMLDOMUtils.getAllNodes(this.doc, "/beans/bean/property/map/entry");
        Element map = XMLDOMUtils.getAllNodes(this.doc, "/beans/bean/property/map").get(0);
        int numberOfEntries = entry.size();
        for (int i = 0; i < numberOfEntries; ++i) {
            map.removeChild(entry.get(i));
        }
        int numberOfRules = this.rulesHashMap.size();
        Object[] keysArray = this.rulesHashMap.keySet().toArray();
        for (int i = 0; i < numberOfRules; ++i) {
            Element elementEntry = this.doc.createElement("entry");
            elementEntry.setAttribute("key", keysArray[i].toString());
            elementEntry.setAttribute("value", this.rulesHashMap.get(keysArray[i]));
            map.appendChild(elementEntry);
        }
    }

    public void saveDataToXML() throws TransformerException, IOException {
        XMLDOMUtils.writeDOM(this.doc, this.parserFile);
    }

    public void update() throws TransformerException, IOException {
        this.setReadFieldToXML();
        this.setWriteFieldToXML();
        this.setRulesToXML();
        this.saveDataToXML();
    }
}

