/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.admin.beans.WebCrawlerBean;
import com.ibm.es.nuvo.common.admin.util.ConfigurationUtils;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.WebCrawlServiceImpl;
import com.ibm.es.nuvo.crawler.framework.configuration.validator.HistoryEntry;
import com.ibm.es.nuvo.crawler.web.configuration.validator.WCValidator;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.crawlspace.HttpProxySettings;
import com.ibm.es.nuvo.crawlspace.WebCrawlspace;
import com.ibm.es.nuvo.util.Constants;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProxyServerBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String dnsHostName = "";
    protected String domain = "*";
    protected String port = "";
    protected String user = "";
    protected String password = "";
    protected String crawlerId = "";
    protected String testUrl = "";
    protected static List<WCValidator.Type> errorCodes = new ArrayList<WCValidator.Type>();

    public List<HistoryEntry> validate(String url) throws ExtendedException {
        String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, this.crawlerId);
        ArrayList<HistoryEntry> errors = new ArrayList<HistoryEntry>();
        Vector<String> allowRules = new Vector<String>();
        allowRules.add(WebCrawlerBean.massageRoot(url));
        List<HistoryEntry<WCValidator.Type>> results = ((WebCrawlServiceImpl)WebCrawlServiceImpl.getCrawlService()).validateProxy(crawlspaceId, false, url, this.getDomain(), this.getDnsHostName(), Integer.valueOf(this.getPort()), this.getUser(), this.getPassword());
        if (results == null) {
            return errors;
        }
        for (int i = 0; i < results.size(); ++i) {
            HistoryEntry<WCValidator.Type> entry = results.get(i);
            if (!errorCodes.contains((Object)entry.getType())) continue;
            errors.add(entry);
        }
        return errors;
    }

    public String getDnsHostName() {
        return this.dnsHostName;
    }

    public void setDnsHostName(String dnsHostName) {
        this.dnsHostName = dnsHostName;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getPort() {
        return this.port;
    }

    public void setPort(String port) {
        this.port = port;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getId() {
        return this.getDomain();
    }

    public void update() throws ExtendedException {
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(this.crawlerId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        if (webCs == null) {
            webCs = ConfigurationUtils.createDefaultWebCrawlspace();
            collCs.setWebCrawlspace(webCs);
        }
        webCs.setHttpProxy(HttpProxyServerBean.toHttpProxySettings(this));
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(this.crawlerId, collCs);
        csMgr.publish(this.crawlerId);
    }

    public void delete() throws ExtendedException {
        HttpProxyServerBean.deleteHttpProxyServer(this.getCrawlerId());
    }

    public static void deleteHttpProxyServer(String crawlerId) throws ExtendedException {
        String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, crawlerId);
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(crawlspaceId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        webCs.setHttpProxy(null);
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(crawlspaceId, collCs);
        csMgr.publish(crawlspaceId);
    }

    public static HttpProxyServerBean getHttpProxyServer(String crawlerId) throws ExtendedException {
        String crawlspaceId = CollectionConfiguration.collectionIdToCrawlspaceId(Constants.CrawlerType.Web, crawlerId);
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(crawlspaceId);
        WebCrawlspace webCs = collCs.getWebCrawlspace();
        return HttpProxyServerBean.toHttpProxyServerBean(webCs.getHttpProxy());
    }

    public static HttpProxyServerBean toHttpProxyServerBean(HttpProxySettings httpProxySettings) {
        HttpProxyServerBean bean = new HttpProxyServerBean();
        if (httpProxySettings == null) {
            return bean;
        }
        bean.setDnsHostName(httpProxySettings.getHostName());
        bean.setDomain(httpProxySettings.getDomainName());
        bean.setPassword(httpProxySettings.getPassword());
        bean.setPort(String.valueOf(httpProxySettings.getPort()));
        bean.setUser(httpProxySettings.getUserId());
        return bean;
    }

    public static HttpProxySettings toHttpProxySettings(HttpProxyServerBean httpProxyBean) {
        HttpProxySettings settings = new HttpProxySettings();
        settings.setDomainName(httpProxyBean.getDomain());
        settings.setHostName(httpProxyBean.getDnsHostName());
        settings.setPassword(httpProxyBean.getPassword());
        settings.setPort(Integer.valueOf(httpProxyBean.getPort()));
        settings.setUserId(httpProxyBean.getUser());
        return settings;
    }

    public String getCrawlerId() {
        return this.crawlerId;
    }

    public void setCrawlerId(String crawlerId) {
        this.crawlerId = crawlerId;
    }

    public String getTestUrl() {
        return this.testUrl;
    }

    public void setTestUrl(String testUrl) {
        this.testUrl = testUrl;
    }

    static {
        errorCodes.add(WCValidator.Type.BAD_PROXY);
        errorCodes.add(WCValidator.Type.PROXY_AUTHENTICATION_REQUIRED);
    }
}

