/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.admin.beans.HttpAuthBean;
import com.ibm.es.nuvo.crawlspace.HttpFormAuth;
import com.ibm.es.nuvo.util.StringUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpFormAuthBean
extends HttpAuthBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String TYPE = "Form";
    protected String formName = "";
    protected String formAction = "";
    protected List<FormParam> formParameters = new ArrayList<FormParam>();
    protected String httpMethod = "";

    public HttpFormAuthBean() {
    }

    public HttpFormAuthBean(String crawlerId, HttpFormAuth formAuth) {
        this.crawlerId = crawlerId;
        this.formAction = formAuth.getFormAction();
        this.formName = formAuth.getFormName();
        this.httpMethod = formAuth.getHttpMethod().equals((Object)HttpFormAuth.HttpMethodType.Get) ? "Get" : "Post";
        HashMap<String, String> params = formAuth.getFormParameters();
        for (Map.Entry<String, String> entry : params.entrySet()) {
            this.formParameters.add(new FormParam(entry.getKey(), entry.getValue()));
        }
        Collections.sort(this.formParameters);
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public String getFormName() {
        return this.formName;
    }

    public void setFormName(String formName) {
        this.formName = formName;
    }

    public List<FormParam> getFormParameters() {
        return this.formParameters;
    }

    public void setFormParameters(List<FormParam> formParameters) {
        this.formParameters = formParameters;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public void setHttpMethod(String httpMethod) {
        this.httpMethod = httpMethod;
    }

    public String getFormAction() {
        return this.formAction;
    }

    public void setFormAction(String formAction) {
        this.formAction = formAction;
    }

    public void setFormParameter(int index, FormParam formParameter) {
        this.formParameters.add(index, formParameter);
    }

    public FormParam getFormParameter(int index) {
        while (this.formParameters.size() <= index) {
            this.formParameters.add(new FormParam());
        }
        return this.formParameters.get(index);
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<HttpFormAuth>");
        sb.append("<formAction>");
        sb.append(this.getFormAction());
        sb.append("</formAction>");
        sb.append("<formName>");
        sb.append(this.getFormName());
        sb.append("</formName>");
        sb.append("<httpMethod>");
        sb.append(this.getHttpMethod());
        sb.append("</httpMethod>");
        sb.append("<formParameters>");
        List<FormParam> formParams = this.getFormParameters();
        int i = 0;
        for (FormParam formParam : formParams) {
            sb.append("<formParameter" + i + ">");
            sb.append("<name>");
            sb.append(formParam.getName());
            sb.append("</name>");
            sb.append("<value>");
            sb.append(formParam.getValue());
            sb.append("</value>");
            sb.append("</formParameter" + i + ">");
            ++i;
        }
        sb.append("</formParameters>");
        sb.append("</HttpFormAuth>");
        return sb.toString();
    }

    public static HttpFormAuth toHttpFormAuth(HttpFormAuthBean bean) {
        HttpFormAuth auth = new HttpFormAuth();
        auth.setFormAction(bean.getFormAction());
        auth.setFormName(bean.getFormName());
        List<FormParam> formParams = bean.getFormParameters();
        HashMap<String, String> params = new HashMap<String, String>(formParams.size());
        for (FormParam formParam : formParams) {
            if (StringUtils.empty(formParam.getName())) continue;
            params.put(formParam.getName(), formParam.getValue());
        }
        auth.setFormParameters(params);
        auth.setHttpMethod(bean.getHttpMethod().equalsIgnoreCase("Get") ? HttpFormAuth.HttpMethodType.Get : HttpFormAuth.HttpMethodType.Post);
        return auth;
    }

    public static class FormParam
    implements Comparable {
        protected String name = null;
        protected String value = null;

        public FormParam() {
        }

        public FormParam(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public int compareTo(Object that) {
            if (this == that) {
                return 0;
            }
            FormParam thatParam = (FormParam)that;
            int comparison = this.name.compareTo(thatParam.getName());
            if (comparison != 0) {
                return comparison;
            }
            comparison = this.value.compareTo(thatParam.getValue());
            if (comparison != 0) {
                return comparison;
            }
            return 0;
        }
    }
}

