/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.Metadata;
import com.ibm.es.nuvo.common.admin.beans.DirectoryBean;
import com.ibm.es.nuvo.common.admin.beans.FieldBean;
import com.ibm.es.nuvo.common.admin.beans.NameComparator;
import com.ibm.es.nuvo.common.admin.util.ConfigurationUtils;
import com.ibm.es.nuvo.common.admin.util.MetadataFieldsExplorer;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionCrawlspaceConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.FieldDefinition;
import com.ibm.es.nuvo.configuration.FieldDefinitions;
import com.ibm.es.nuvo.configuration.FieldMappingManager;
import com.ibm.es.nuvo.crawler.GlobalCrawlerManager;
import com.ibm.es.nuvo.crawler.admin.Configuration;
import com.ibm.es.nuvo.crawler.admin.CrawlMode;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceControl;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceStatus;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfiguration;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerControl;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import com.ibm.es.nuvo.crawler.admin.CrawlerManager;
import com.ibm.es.nuvo.crawler.admin.CrawlerType;
import com.ibm.es.nuvo.crawler.admin.FieldConfiguration;
import com.ibm.es.nuvo.crawler.admin.SpaceConfiguration;
import com.ibm.es.nuvo.crawler.framework.configuration.validator.HistoryEntry;
import com.ibm.es.nuvo.crawler.fs.validator.FSValidator;
import com.ibm.es.nuvo.crawlspace.CollectionCrawlspace;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.Vector;
import java.util.logging.Level;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemCrawlerBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private CrawlerManager manager;
    private CrawlerConfiguration crawlerConfiguration;
    private static final String FileSystemCrawlerType = "com.ibm.es.nuvo.crawler.adapter.file";
    protected String collectionId = "";
    protected String crawlerId = "";
    protected String subdirectoryDepth = "";
    protected String crawlerPoliteness = "";
    protected List<DirectoryBean> directoryBeans = Collections.EMPTY_LIST;

    public FileSystemCrawlerBean() {
    }

    public FileSystemCrawlerBean(String collectionId) {
        this();
        this.collectionId = collectionId;
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        this.manager = globalCrawlerManager.getCrawlerManager(collectionId);
        this.crawlerConfiguration = this.getFileSystemCrawlerConfiguration(this.manager);
        this.crawlerId = this.crawlerConfiguration.getID();
        this.directoryBeans = this.getDirectories();
    }

    public boolean isDup(DirectoryBean dirBean) {
        if (dirBean == null) {
            return false;
        }
        String root = dirBean.getRoot();
        List<DirectoryBean> existingBeans = this.getDirectoryBeans();
        for (DirectoryBean existingBean : existingBeans) {
            if (!root.equals(existingBean.getRoot())) continue;
            return true;
        }
        return false;
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public List<DirectoryBean> getDirectoryBeans() {
        return this.directoryBeans;
    }

    public void setDirectoryBeans(List<DirectoryBean> directoryBeans) {
        this.directoryBeans = directoryBeans;
    }

    public void stop() throws ExtendedException {
        if (this.isRunning()) {
            CrawlSpaceControl[] controls = this.manager.getAvailableCrawlSpaceControls(this.crawlerId);
            for (int i = 0; i < controls.length; ++i) {
                controls[i].stopCrawl();
            }
        }
    }

    public void start(boolean fullRecrawl) throws ExtendedException {
        if (!this.isRunning()) {
            CrawlSpaceControl[] controls = this.manager.getAvailableCrawlSpaceControls(this.crawlerId);
            CrawlMode mode = fullRecrawl ? CrawlMode.FORCE : CrawlMode.NORMAL;
            for (int i = 0; i < controls.length; ++i) {
                controls[i].startCrawl(mode);
            }
        }
    }

    public void update() throws ExtendedException {
        CollectionCrawlspace collCs = ConfigurationUtils.getCollectionCrawlspaceForUpdate(this.crawlerId);
        CollectionCrawlspaceConfigurationManager csMgr = ConfigurationUtils.getCollectionCrawlspaceConfigurationManager();
        csMgr.updateCrawlspace(this.crawlerId, collCs);
        csMgr.publish(this.crawlerId);
    }

    public static List<HistoryEntry> validateDirectory(String collectionId, DirectoryBean dirBean) throws ExtendedException {
        String dirRoot;
        ArrayList<HistoryEntry> errors = new ArrayList<HistoryEntry>();
        CrawlerConfiguration crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(collectionId);
        SpaceConfiguration rootSpace = FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, dirRoot = dirBean.getRoot());
        if (rootSpace == null) {
            errors.add(new HistoryEntry<FSValidator.Type>("/Target", dirRoot, FSValidator.Type.INVALID_PATH, Level.SEVERE));
        } else if (!rootSpace.isAvailableAsCrawlSpace()) {
            errors.add(new HistoryEntry<FSValidator.Type>("/Target", dirRoot, FSValidator.Type.NO_READ_PERMISSION, Level.SEVERE));
        }
        return errors;
    }

    public static void updateDirectory(DirectoryBean directoryBean) throws ExtendedException {
        CrawlerConfiguration crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(directoryBean.getCrawlerId());
        SpaceConfiguration dirSpace = FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, directoryBean.getRoot());
        if (dirSpace != null) {
            FileSystemCrawlerBean.setExcludePatterns(dirSpace, directoryBean.getDenyRulesList());
            GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
            CrawlerManager manager = globalCrawlerManager.getCrawlerManager(directoryBean.getCrawlerId());
            FileSystemCrawlerBean.closeSpace(dirSpace);
            manager.submitCrawlerConfiguration(crawlerConfig);
        }
    }

    public static void deleteDirectory(String collectionId, String path) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionId);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        CrawlerConfiguration crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(collectionId);
        SpaceConfiguration dirSpace = FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, path, false);
        if (dirSpace != null) {
            if (dirSpace.hasSubSpaces()) {
                dirSpace.open();
                dirSpace.setAsCrawlSpace(false);
                dirSpace.close();
            } else {
                dirSpace.setEnabled(false);
            }
            GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
            CrawlerManager manager = globalCrawlerManager.getCrawlerManager(collectionId);
            fieldMappingManager.removeCrawlspace(dirSpace.getID());
            configurationManager.updateCollection(collectionConfiguration);
            manager.submitCrawlerConfiguration(crawlerConfig);
        }
    }

    public void addDirectory(DirectoryBean directoryBean, String collectionID) throws ExtendedException {
        SpaceConfiguration dirSpace;
        CrawlerConfiguration fsCrawlerConfig = this.manager.getCrawlerConfiguration(this.crawlerId);
        if (!fsCrawlerConfig.isOpen()) {
            fsCrawlerConfig.open();
        }
        if ((dirSpace = FileSystemCrawlerBean.getDirectorySpaceConfiguration(fsCrawlerConfig, directoryBean.getRoot())) != null) {
            if (dirSpace.isAvailableAsCrawlSpace()) {
                dirSpace.setAsCrawlSpace(true);
                FileSystemCrawlerBean.setExcludePatterns(dirSpace, directoryBean.getDenyRulesList());
                FileSystemCrawlerBean.setImplicitFields(dirSpace, directoryBean.getRoot(), collectionID);
                FileSystemCrawlerBean.closeSpace(dirSpace);
            }
            this.manager.submitCrawlerConfiguration(fsCrawlerConfig);
        }
        this.start(false);
    }

    public static void updateDirectoryImplicitFieldMapToField(String collectionID, String path, String fieldName, String mapToField) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        CrawlerConfiguration crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(collectionID);
        SpaceConfiguration dirSpace = FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, path);
        if (dirSpace != null) {
            Iterator<FieldConfiguration> fields = dirSpace.getFields();
            while (fields.hasNext()) {
                FieldConfiguration field = fields.next();
                if (!field.isSystemField() || !field.getName().equals(fieldName)) continue;
                fieldMappingManager.addMapping(dirSpace.getID(), field.getName(), mapToField, field.isSystemField());
                FileSystemCrawlerBean.closeSpace(dirSpace);
                configurationManager.updateCollection(collectionConfiguration);
            }
        }
    }

    public static void updateDirectoryImplicitFieldEnabled(String collectionID, String path, List<FieldBean> implicitFieldList) throws ExtendedException {
        CrawlerConfiguration crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(collectionID);
        SpaceConfiguration dirSpace = FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, path);
        if (dirSpace != null) {
            Iterator<FieldConfiguration> fields = dirSpace.getFields();
            while (fields.hasNext()) {
                FieldBean implicitFieldFromClient;
                FieldConfiguration field = fields.next();
                if (!field.isSystemField() || (implicitFieldFromClient = MetadataFieldsExplorer.getFieldBeanWithName(field.getName(), implicitFieldList)) == null) continue;
                field.setEnabled(implicitFieldFromClient.isEnabled());
            }
            FileSystemCrawlerBean.closeSpace(dirSpace);
            GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
            CrawlerManager manager = globalCrawlerManager.getCrawlerManager(collectionID);
            manager.submitCrawlerConfiguration(crawlerConfig);
        }
    }

    public static FieldBean[] getDirectoryImplicitFields(String collectionID, String path, Locale locale) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollection(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        CrawlerConfiguration crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(collectionID);
        SpaceConfiguration dirSpace = FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, path);
        if (dirSpace != null) {
            Vector<FieldBean> columns = new Vector<FieldBean>();
            Iterator<FieldConfiguration> fieldsItr = dirSpace.getFields();
            if (fieldsItr != null) {
                Map<String, FieldMappingManager.FieldMapping> mappings = fieldMappingManager.getFieldMappingMap(dirSpace.getID());
                while (fieldsItr.hasNext()) {
                    FieldConfiguration field = fieldsItr.next();
                    if (!field.isSystemField()) continue;
                    FieldBean fieldBean = new FieldBean();
                    fieldBean.setName(field.getName());
                    fieldBean.setType(field.getTypeName());
                    fieldBean.setMetadataType(field.getType().toString());
                    fieldBean.setEnabled(field.isEnabled());
                    FieldMappingManager.FieldMapping mapping = mappings.get(field.getName());
                    if (mapping != null) {
                        fieldBean.setMapToName(mapping.getFieldName());
                    }
                    columns.add(fieldBean);
                }
                FieldBean[] columnsArray = new FieldBean[columns.size()];
                for (int k = 0; k < columnsArray.length; ++k) {
                    columnsArray[k] = (FieldBean)columns.elementAt(k);
                }
                if (locale != null) {
                    NameComparator inameComparator = new NameComparator(locale);
                    Arrays.sort(columnsArray, inameComparator);
                }
                return columnsArray;
            }
        }
        return new FieldBean[0];
    }

    private static void setImplicitFields(SpaceConfiguration dirSpace, String path, String collectionID) throws ExtendedException {
        ConfigurationManager configurationManager = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration collectionConfiguration = configurationManager.getCollectionForUpdate(collectionID);
        FieldMappingManager fieldMappingManager = collectionConfiguration.getFieldMappingManager();
        FieldDefinitions fieldDefinitions = collectionConfiguration.getFieldDefinitions();
        Map<String, FieldDefinition> predefinedUserBuiltInFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Predefined, FieldDefinitions.FieldType.User, FieldDefinitions.FieldType.BuiltIn));
        Map<String, FieldDefinition> hiddenFieldDefinitionMap = fieldDefinitions.getFieldDefinitions(EnumSet.of(FieldDefinitions.FieldType.Hidden));
        Metadata meta = fieldMappingManager.getCrawlspaceMetadata(dirSpace.getID());
        if (meta == null) {
            meta = new Metadata();
        }
        Iterator<FieldConfiguration> fieldsItr = dirSpace.getFields();
        while (fieldsItr.hasNext()) {
            FieldConfiguration field = fieldsItr.next();
            if (!field.isSystemField()) continue;
            field.setEnabled(true);
            meta.add(Metadata.Type.CrawlerImplicit, field.getName(), field.getValue());
            String externalName = MetadataFieldsExplorer.calculateMapToName(field.getName(), hiddenFieldDefinitionMap);
            fieldMappingManager.addMapping(dirSpace.getID(), field.getName(), externalName, field.isSystemField());
            if (MetadataFieldsExplorer.fieldDefinitionExists(externalName, predefinedUserBuiltInFieldDefinitionMap)) continue;
            FieldDefinition newFieldDefinition = MetadataFieldsExplorer.createNewFieldDefinition(externalName, false, false, field.getType());
            fieldDefinitions.upsertFieldDefinition(newFieldDefinition, FieldDefinitions.FieldType.User);
        }
        fieldMappingManager.setCrawlspaceMetadata(dirSpace.getID(), meta);
        configurationManager.updateCollection(collectionConfiguration);
    }

    private static void setExcludePatterns(SpaceConfiguration dirSpace, Vector<String> excludePatterns) throws ExtendedException {
        Map<String, Configuration> crawlspaceConfig = dirSpace.getCrawlSpaceConfigurations();
        Configuration excludePatternConfig = crawlspaceConfig.get("exclude_patterns");
        excludePatternConfig.clear();
        for (String pattern : excludePatterns) {
            Configuration.ListItem excludePattern = excludePatternConfig.addItem(pattern);
            excludePattern.setSelected(true);
        }
    }

    private List<DirectoryBean> getDirectories() {
        ArrayList<DirectoryBean> directoryBeans;
        block2: {
            directoryBeans = new ArrayList<DirectoryBean>();
            try {
                CrawlerConfiguration fsCrawlerConfig = this.manager.getCrawlerConfiguration(this.crawlerId);
                this.getDirectories(null, directoryBeans, fsCrawlerConfig);
            }
            catch (CrawlerConfigurationException e) {
                directoryBeans = null;
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block2;
                Message msg = new Message("S0216E.CRAWLSPACES_RETRIEVE_FAILURE");
                msg.addArgument(this.collectionId);
                msg.addArgument(this.crawlerId);
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                Loggers.logger.log(exc);
            }
        }
        return directoryBeans;
    }

    public DirectoryBean getDirectory(String path) throws ExtendedException {
        DirectoryBean bean = null;
        for (DirectoryBean dirBean : this.directoryBeans) {
            if (!dirBean.getRoot().equals(path)) continue;
            bean = dirBean;
            break;
        }
        return bean;
    }

    private List<DirectoryBean> getDirectories(String path, List<DirectoryBean> directories, SpaceConfiguration space) throws CrawlerConfigurationException {
        if (space != null) {
            if (space.isOpen()) {
                space.close();
            }
            Iterator<SpaceConfiguration> subspaces = space.getSubSpaces();
            while (subspaces.hasNext()) {
                String dirPath;
                SpaceConfiguration child = subspaces.next();
                String name = child.getName();
                if (path == null) {
                    dirPath = name;
                } else {
                    String separator = File.separator;
                    if (path.endsWith(File.separator)) {
                        separator = "";
                    }
                    dirPath = path + separator + name;
                }
                if (child.isSetAsCrawlSpace()) {
                    Map<String, Configuration> crawlspaceConfig = child.getCrawlSpaceConfigurations();
                    Configuration excludePatternConfig = crawlspaceConfig.get("exclude_patterns");
                    Set<Configuration.ListItem> excludePatterns = excludePatternConfig.getItems();
                    Iterator<Configuration.ListItem> excludeIterator = excludePatterns.iterator();
                    Vector<String> denyRules = new Vector<String>();
                    while (excludeIterator.hasNext()) {
                        denyRules.add(excludeIterator.next().getValue());
                    }
                    directories.add(FileSystemCrawlerBean.toDirectoryBean(this.collectionId, child, dirPath));
                }
                this.getDirectories(dirPath, directories, child);
            }
        }
        return directories;
    }

    private static DirectoryBean toDirectoryBean(String collectionId, SpaceConfiguration dirSpace, String path) throws CrawlerConfigurationException {
        DirectoryBean dirBean = null;
        if (dirSpace != null) {
            Map<String, Configuration> crawlspaceConfig = dirSpace.getCrawlSpaceConfigurations();
            Configuration excludePatternConfig = crawlspaceConfig.get("exclude_patterns");
            Set<Configuration.ListItem> excludePatterns = excludePatternConfig.getItems();
            Iterator<Configuration.ListItem> excludeIterator = excludePatterns.iterator();
            Vector<String> denyRules = new Vector<String>();
            while (excludeIterator.hasNext()) {
                denyRules.add(excludeIterator.next().getValue());
            }
            dirBean = new DirectoryBean();
            dirBean.setCrawlerId(collectionId);
            dirBean.setRoot(path);
            dirBean.setDenyRules(denyRules);
        }
        return dirBean;
    }

    public static DirectoryBean toDirectoryBean(String collectionId, String path) throws ExtendedException {
        DirectoryBean dirBean = null;
        CrawlerConfiguration crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(collectionId);
        SpaceConfiguration dirSpaceConfig = FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, path);
        if (dirSpaceConfig != null) {
            dirBean = FileSystemCrawlerBean.toDirectoryBean(collectionId, dirSpaceConfig, path);
        }
        return dirBean;
    }

    protected CrawlSpaceStatus getStatus() {
        CrawlSpaceStatus status;
        block2: {
            status = null;
            try {
                CrawlSpaceControl[] controls = this.manager.getAvailableCrawlSpaceControls(this.crawlerId);
                CrawlSpaceControl control = controls[0];
                status = control.getCrawlSpaceStatus();
            }
            catch (Exception e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block2;
                Message msg = new Message("S0217E.CRAWLER_STATUS_RETRIEVE_FAILURE");
                msg.addArgument(this.crawlerId);
                msg.addArgument(this.collectionId);
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                Loggers.logger.log(exc);
            }
        }
        return status;
    }

    private CrawlSpaceStatus[] getStatuses() {
        CrawlSpaceStatus[] statuses = null;
        try {
            CrawlSpaceControl[] controls = this.manager.getAvailableCrawlSpaceControls(this.crawlerId);
            statuses = new CrawlSpaceStatus[controls.length];
            for (int i = 0; i < controls.length; ++i) {
                statuses[i] = controls[i].getCrawlSpaceStatus();
            }
            return statuses;
        }
        catch (CrawlerControlException e) {
            if (Loggers.logger.isLoggable(Level.SEVERE)) {
                Message msg = new Message("S0217E.CRAWLER_STATUS_RETRIEVE_FAILURE");
                msg.addArgument(this.crawlerId);
                msg.addArgument(this.collectionId);
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                Loggers.logger.log(exc);
            }
            return statuses;
        }
    }

    public String getDocumentsCrawledPerMinute() {
        CrawlSpaceStatus[] statuses = this.getStatuses();
        if (statuses.length == 0) {
            return "0";
        }
        long minStartTime = statuses[0].getStartTime().getTime();
        for (int i = 1; i < statuses.length; ++i) {
            if (statuses[i].getStartTime() == null || minStartTime <= statuses[i].getStartTime().getTime()) continue;
            minStartTime = statuses[i].getStartTime().getTime();
        }
        long numOfCrawledDocs = new Long(this.getDocumentsCrawledThisSession());
        long totalCrawlTime = System.currentTimeMillis() - minStartTime;
        String crawlRate = "0";
        if (totalCrawlTime > 0L) {
            crawlRate = Long.toString(numOfCrawledDocs * 60L * 1000L / totalCrawlTime);
        }
        return crawlRate;
    }

    public String getDocumentsCrawledThisSession() {
        CrawlSpaceStatus[] statuses = this.getStatuses();
        Long amOfCrawledDocs = new Long(0L);
        for (CrawlSpaceStatus curStatus : statuses) {
            amOfCrawledDocs = amOfCrawledDocs + curStatus.getNumberOfCrawledRecords();
        }
        return amOfCrawledDocs.toString();
    }

    public String getLastCrawlDate() {
        CrawlSpaceStatus[] statuses = this.getStatuses();
        long lastCrawlDate = 0L;
        for (CrawlSpaceStatus curStatus : statuses) {
            long curStatusLastCrawlDate;
            if (curStatus.getEndTime() == null || curStatus.getStatus() == CrawlSpaceStatus.Status.INIT || lastCrawlDate >= (curStatusLastCrawlDate = curStatus.getEndTime().getTime())) continue;
            lastCrawlDate = curStatusLastCrawlDate;
        }
        return Long.toString(lastCrawlDate);
    }

    public String getCrawlerPoliteness() {
        return this.crawlerPoliteness;
    }

    public void setCrawlerPoliteness(String crawlerPoliteness) {
        this.crawlerPoliteness = crawlerPoliteness;
    }

    public String getSubdirectoryDepth() {
        return this.subdirectoryDepth;
    }

    public void setSubdirectoryDepth(String subdirectoryDepth) {
        this.subdirectoryDepth = subdirectoryDepth;
    }

    public boolean isRunning() {
        try {
            CrawlSpaceControl[] controls = this.manager.getAvailableCrawlSpaceControls(this.crawlerId);
            for (int i = 0; i < controls.length; ++i) {
                if (controls[i].getCrawlSpaceStatus().getStatus() != CrawlSpaceStatus.Status.CRAWLING) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public String getCrawlerId() {
        return this.crawlerId;
    }

    public void setCrawlerId(String crawlerId) {
        this.crawlerId = crawlerId;
    }

    private CrawlerConfiguration getFileSystemCrawlerConfiguration(CrawlerManager manager) {
        CrawlerConfiguration crawlerConfig;
        block3: {
            crawlerConfig = null;
            try {
                crawlerConfig = FileSystemCrawlerBean.getFileSystemCrawlerConfiguration(this.collectionId);
                if (crawlerConfig == null) {
                    String crawlerName = "_fscrawler";
                    CrawlerType fsCrawlerType = manager.getCrawlerType(FileSystemCrawlerType);
                    List<Configuration> configs = fsCrawlerType.getRequiredConfigurations();
                    crawlerConfig = manager.newCrawlerConfiguration(crawlerName, fsCrawlerType, configs, null);
                    manager.submitCrawlerConfiguration(crawlerConfig);
                }
            }
            catch (Exception e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block3;
                Message msg = new Message("S0218E.CRAWLER_CONFIGURATION_RETRIEVE_FAILURE");
                msg.addArgument(this.crawlerId);
                msg.addArgument(this.collectionId);
                ExtendedException exc = new ExtendedException(msg, (Throwable)e);
                Loggers.logger.log(exc);
            }
        }
        return crawlerConfig;
    }

    public static CrawlerConfiguration getFileSystemCrawlerConfiguration(String collectionId) throws ExtendedException {
        CrawlerConfiguration crawlerConfig = null;
        GlobalCrawlerManager globalCrawlerManager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager();
        CrawlerManager manager = globalCrawlerManager.getCrawlerManager(collectionId);
        CrawlerControl fsCrawlerControl = null;
        CrawlerControl[] csControls = manager.getAvailableCrawlerControls();
        for (int i = 0; i < csControls.length; ++i) {
            if (!csControls[i].getType().equals(FileSystemCrawlerType)) continue;
            fsCrawlerControl = csControls[i];
            break;
        }
        if (fsCrawlerControl != null) {
            crawlerConfig = manager.getCrawlerConfiguration(fsCrawlerControl.getID());
        }
        return crawlerConfig;
    }

    private static SpaceConfiguration getDirectorySpaceConfiguration(CrawlerConfiguration crawlerConfig, String directoryPath) throws ExtendedException {
        return FileSystemCrawlerBean.getDirectorySpaceConfiguration(crawlerConfig, directoryPath, true);
    }

    private static SpaceConfiguration getDirectorySpaceConfiguration(CrawlerConfiguration crawlerConfig, String directoryPath, boolean discovery) throws ExtendedException {
        CrawlerConfiguration directorySpaceConfig;
        block9: {
            if (discovery && !crawlerConfig.isOpen()) {
                crawlerConfig.open();
            }
            directorySpaceConfig = null;
            try {
                Stack<File> stack = new Stack<File>();
                for (File directory = new File(directoryPath).getCanonicalFile(); directory != null; directory = directory.getParentFile()) {
                    stack.push(directory);
                }
                SpaceConfiguration space = crawlerConfig;
                boolean found = false;
                block3: while (!stack.isEmpty()) {
                    String name;
                    File file = (File)stack.pop();
                    String string = name = file.getName() == null || file.getName().length() == 0 ? file.getPath() : file.getName();
                    if (discovery && !space.isOpen()) {
                        space.open();
                    }
                    Iterator<SpaceConfiguration> subspaces = space.getSubSpaces();
                    found = false;
                    while (subspaces.hasNext()) {
                        SpaceConfiguration child = subspaces.next();
                        if (!name.equals(child.getName())) continue;
                        space = child;
                        found = true;
                        continue block3;
                    }
                }
                if (found) {
                    directorySpaceConfig = space;
                    if (discovery && !directorySpaceConfig.isOpen()) {
                        directorySpaceConfig.open();
                    }
                }
            }
            catch (Exception e) {
                if (!Loggers.logger.isLoggable(Level.SEVERE)) break block9;
                Loggers.logger.log(Level.SEVERE, new ExtendedException(e));
            }
        }
        return directorySpaceConfig;
    }

    private static void closeSpace(SpaceConfiguration space) throws CrawlerConfigurationException {
        while (space != null) {
            if (space.isOpen()) {
                space.setEnabled(true);
                space.close();
            }
            space = (SpaceConfiguration)space.getParent();
        }
    }
}

