/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.admin.beans.BranchBean;
import com.ibm.es.nuvo.common.admin.beans.FileSystemCrawlerBean;
import com.ibm.es.nuvo.crawler.framework.configuration.validator.HistoryEntry;
import com.ibm.es.nuvo.crawler.fs.validator.FSValidator;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectoryBean
extends BranchBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected static List<FSValidator.Type> errorCodes = new ArrayList<FSValidator.Type>();

    @Override
    public List<HistoryEntry> validate(String collectionId) throws ExtendedException {
        return FileSystemCrawlerBean.validateDirectory(collectionId, this);
    }

    public static void delete(String crawlerId, String rootToDelete) throws ExtendedException {
        FileSystemCrawlerBean.deleteDirectory(crawlerId, rootToDelete);
    }

    public void update() throws ExtendedException {
        FileSystemCrawlerBean.updateDirectory(this);
    }

    @Override
    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Directory>");
        sb.append(super.toXml());
        sb.append("</Directory>");
        return sb.toString();
    }

    public static String toXml(String crawlerId, String root) throws ExtendedException {
        return DirectoryBean.getDirectoryBean(crawlerId, root).toXml();
    }

    public static DirectoryBean getDirectoryBean(String crawlerId, String root) throws ExtendedException {
        return FileSystemCrawlerBean.toDirectoryBean(crawlerId, root);
    }

    static {
        errorCodes.add(FSValidator.Type.INVALID_PATH);
        errorCodes.add(FSValidator.Type.NOT_DIRECTORY);
        errorCodes.add(FSValidator.Type.FILE_NOT_FOUND);
        errorCodes.add(FSValidator.Type.NO_READ_PERMISSION);
    }
}

