/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.admin.beans.DatabaseBean;
import com.ibm.es.nuvo.common.admin.beans.DatabaseTableBean;
import com.ibm.es.nuvo.common.admin.util.DatabaseCrawlSpaceExplorer;
import com.ibm.es.nuvo.crawler.admin.CrawlSpaceStatus;
import com.ibm.es.nuvo.crawler.admin.CrawlerConfigurationException;
import com.ibm.es.nuvo.crawler.admin.CrawlerControlException;
import java.util.Date;
import java.util.List;

public class DatabaseCrawlerBean {
    private String collectionId;
    private DatabaseBean[] databaseBeans;

    public DatabaseCrawlerBean(String collectionId) throws ExtendedException {
        this.collectionId = collectionId;
        this.databaseBeans = DatabaseCrawlSpaceExplorer.getCrawlSpace(this.collectionId, null);
    }

    public DatabaseBean[] getDatabaseBeans() {
        try {
            this.databaseBeans = DatabaseCrawlSpaceExplorer.getCrawlSpace(this.collectionId, null);
        }
        catch (CrawlerControlException e) {
            e.printStackTrace();
        }
        catch (CrawlerConfigurationException e) {
            e.printStackTrace();
        }
        return this.databaseBeans;
    }

    public String getDocumentsCrawledPerMinute() {
        String crawlRate = "0";
        long numCrawled = new Long(this.getDocumentsCrawledThisSession());
        long totalCrawlTime = 0L;
        for (int i = 0; i < this.databaseBeans.length; ++i) {
            List<DatabaseTableBean> tableBeans = this.databaseBeans[i].getTables();
            for (DatabaseTableBean tableBean : tableBeans) {
                totalCrawlTime += tableBean.getTotalTime();
            }
        }
        if (totalCrawlTime > 0L) {
            crawlRate = Long.toString((long)((double)numCrawled / (double)totalCrawlTime * 60000.0));
        }
        return crawlRate;
    }

    public String getDocumentsCrawledThisSession() {
        long numCrawledRecs = 0L;
        for (int i = 0; i < this.databaseBeans.length; ++i) {
            List<DatabaseTableBean> tableBeans = this.databaseBeans[i].getTables();
            for (DatabaseTableBean tableBean : tableBeans) {
                numCrawledRecs += tableBean.getNumberOfCrawledRecords();
            }
        }
        return Long.toString(numCrawledRecs);
    }

    public boolean isRunning() {
        boolean running = false;
        for (int i = 0; i < this.databaseBeans.length; ++i) {
            List<DatabaseTableBean> tableBeans = this.databaseBeans[i].getTables();
            for (DatabaseTableBean tableBean : tableBeans) {
                String status = tableBean.getStatus();
                if (!status.equals(CrawlSpaceStatus.Status.CRAWLING.toString())) continue;
                running = true;
            }
        }
        return running;
    }

    public String getLastCrawlDate() {
        Date latestCrawlDate = null;
        String lastCrawlDate = "0";
        for (int i = 0; i < this.databaseBeans.length; ++i) {
            List<DatabaseTableBean> tableBeans = this.databaseBeans[i].getTables();
            for (DatabaseTableBean tableBean : tableBeans) {
                Date lastCrawledDate = tableBean.getEndTime();
                if (latestCrawlDate == null) {
                    latestCrawlDate = lastCrawledDate;
                    continue;
                }
                if (lastCrawledDate == null || !lastCrawledDate.after(latestCrawlDate)) continue;
                latestCrawlDate = lastCrawledDate;
            }
        }
        if (latestCrawlDate != null) {
            lastCrawlDate = Long.toString(latestCrawlDate.getTime());
        }
        return lastCrawlDate;
    }

    public String getCollectionId() {
        return this.collectionId;
    }
}

