/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.admin.util.ConfigurationUtils;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.ConfigurationObjectNotExistsException;
import com.ibm.es.nuvo.configuration.ScoringWeights;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;

public class CustomRankingBean
extends ActionForm {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected boolean ageWeight = true;
    protected boolean depthWeight = true;
    protected boolean linkCountWeight = true;

    public void loadFromConfig(String collectionId) throws ExtendedException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        CollectionConfiguration collConfig = mgr.getCollection(collectionId);
        ScoringWeights weights = collConfig.getScoringWeights();
        if (weights.getAgeWeight() > 0.0) {
            this.ageWeight = true;
        }
        if (weights.getDepthWeight() > 0.0) {
            this.depthWeight = true;
        }
        if (weights.getLinkCountWeight() > 0.0) {
            this.linkCountWeight = true;
        }
    }

    public void saveValues(String collectionId) throws ConfigurationManagerException, ConfigurationObjectNotExistsException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        CollectionConfiguration collConfig = mgr.getCollectionForUpdate(collectionId);
        ScoringWeights weights = collConfig.getScoringWeights();
        if (this.ageWeight) {
            weights.setAgeWeight(1.0);
        } else {
            weights.setAgeWeight(0.0);
        }
        if (this.depthWeight) {
            weights.setDepthWeight(1.0);
        } else {
            weights.setDepthWeight(0.0);
        }
        if (this.linkCountWeight) {
            weights.setLinkCountWeight(1.0);
        } else {
            weights.setLinkCountWeight(0.0);
        }
        mgr.updateCollection(collConfig);
    }

    public void reset(ActionMapping arg0, HttpServletRequest arg1) {
        this.ageWeight = false;
        this.depthWeight = false;
        this.linkCountWeight = false;
    }

    public void setDefault() {
        this.ageWeight = true;
        this.depthWeight = true;
        this.linkCountWeight = true;
    }

    public boolean isAgeWeight() {
        return this.ageWeight;
    }

    public void setAgeWeight(boolean ageWeight) {
        this.ageWeight = ageWeight;
    }

    public boolean isDepthWeight() {
        return this.depthWeight;
    }

    public void setDepthWeight(boolean depthWeight) {
        this.depthWeight = depthWeight;
    }

    public boolean isLinkCountWeight() {
        return this.linkCountWeight;
    }

    public void setLinkCountWeight(boolean linkCountWeight) {
        this.linkCountWeight = linkCountWeight;
    }
}

