/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.common.admin.beans.CategorizationSettingsBean;
import com.ibm.es.nuvo.common.admin.beans.CollectionListBean;
import com.ibm.es.nuvo.common.admin.beans.DatabaseCrawlerBean;
import com.ibm.es.nuvo.common.admin.beans.FileSystemCrawlerBean;
import com.ibm.es.nuvo.common.admin.beans.ParserSettingsBean;
import com.ibm.es.nuvo.common.admin.beans.QuickLinkBean;
import com.ibm.es.nuvo.common.admin.beans.SynonymBean;
import com.ibm.es.nuvo.common.admin.beans.WebCrawlerBean;
import com.ibm.es.nuvo.common.admin.util.ConfigurationUtils;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import com.ibm.es.nuvo.documentqueue.DocumentQueueInterface;
import com.ibm.es.nuvo.documentqueue.OptimizeIndexDocument;
import com.ibm.es.nuvo.documentqueue.UpdateIndexDocument;
import com.ibm.es.nuvo.indexer.IndexerMonitor;
import com.ibm.es.nuvo.spell.querylog.QueryRuntimeStatistics;
import java.io.IOException;
import java.text.NumberFormat;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.SAXException;

public class CollectionBean {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected String id = "";
    protected String name = "";
    protected int queryTimeout = 0;
    ParserSettingsBean parserSettingsBean = null;
    CategorizationSettingsBean categorizationSettingsBean = null;
    protected boolean cacheDocuments = true;
    protected boolean spellSuggestions = true;
    protected boolean enabledForSearch = true;
    protected boolean enabledForSecurity = false;
    protected boolean enabledForNgram = true;
    protected List synonymBeans = Collections.EMPTY_LIST;
    protected List quickLinkBeans = Collections.EMPTY_LIST;
    protected WebCrawlerBean webCrawlerBean = null;
    protected FileSystemCrawlerBean fileSystemCrawlerBean = null;
    protected DatabaseCrawlerBean databaseCrawlerBean = null;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCacheDocuments() {
        return this.cacheDocuments;
    }

    public void setCacheDocuments(boolean cacheDocuments) {
        this.cacheDocuments = cacheDocuments;
    }

    public FileSystemCrawlerBean getFileSystemCrawlerBean() throws ExtendedException {
        if (this.fileSystemCrawlerBean == null) {
            this.setFileSystemCrawlerBean(new FileSystemCrawlerBean(this.id));
        }
        return this.fileSystemCrawlerBean;
    }

    public void setFileSystemCrawlerBean(FileSystemCrawlerBean fileSystemCrawlerBean) {
        this.fileSystemCrawlerBean = fileSystemCrawlerBean;
    }

    public DatabaseCrawlerBean getDatabaseCrawlerBean() throws ExtendedException {
        if (this.databaseCrawlerBean == null) {
            this.setDatabaseCrawlerBean(new DatabaseCrawlerBean(this.id));
        }
        return this.databaseCrawlerBean;
    }

    public void setDatabaseCrawlerBean(DatabaseCrawlerBean databaseCrawlerBean) {
        this.databaseCrawlerBean = databaseCrawlerBean;
    }

    public List getQuickLinkBeans() throws ExtendedException {
        return this.quickLinkBeans;
    }

    public void setQuickLinkBeans(List quickLinkBeans) {
        this.quickLinkBeans = quickLinkBeans;
    }

    public boolean isSpellSuggestions() {
        return this.spellSuggestions;
    }

    public void setSpellSuggestions(boolean spellSuggestions) {
        this.spellSuggestions = spellSuggestions;
    }

    public List getSynonymBeans() throws ExtendedException {
        return this.synonymBeans;
    }

    public void setSynonymBeans(List synonymBeans) {
        this.synonymBeans = synonymBeans;
    }

    public WebCrawlerBean getWebCrawlerBean() {
        if (this.webCrawlerBean == null) {
            try {
                this.setWebCrawlerBean(WebCrawlerBean.retrieve(this.id));
            }
            catch (ExtendedException e) {
                this.webCrawlerBean = new WebCrawlerBean(this.id);
            }
        }
        return this.webCrawlerBean;
    }

    public ParserSettingsBean getParserSettingsBean() {
        return this.parserSettingsBean;
    }

    public void setParserSettingsBean(ParserSettingsBean parserSettingsBean) {
        this.parserSettingsBean = parserSettingsBean;
    }

    public CategorizationSettingsBean getCategorizationSettingsBean() {
        return this.categorizationSettingsBean;
    }

    public void setCategorizationSettingsBean(CategorizationSettingsBean categorizationSettingsBean) {
        this.categorizationSettingsBean = categorizationSettingsBean;
    }

    public void setWebCrawlerBean(WebCrawlerBean webCrawlerBean) {
        this.webCrawlerBean = webCrawlerBean;
    }

    public String getDocCount() {
        try {
            IndexerMonitor indexerMonitor = GlobalSystem.getSingleInstance().getIndexerMonitor();
            return String.valueOf(indexerMonitor.getNumberOfDocuments(this.id));
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public String getDocCountFormatted() {
        try {
            return NumberFormat.getInstance().format(Long.valueOf(this.getDocCount()));
        }
        catch (Exception exception) {
            return String.valueOf(this.getDocCount());
        }
    }

    public String getIndexSize() {
        try {
            IndexerMonitor indexerMonitor = GlobalSystem.getSingleInstance().getIndexerMonitor();
            return String.valueOf(indexerMonitor.getIndexSize(this.id));
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public String getIndexSizeKilobytesFormatted() {
        return NumberFormat.getInstance().format(this.getIndexSizeKilobytesAsLong());
    }

    public long getIndexSizeKilobytesAsLong() {
        String indexSizeBytes = this.getIndexSize();
        long sizeInBytes = Long.valueOf(indexSizeBytes);
        return sizeInBytes / 1024L;
    }

    public String getIndexSizeMegabytesFormatted() {
        return NumberFormat.getInstance().format(this.getIndexSizeMegabytesAsLong());
    }

    public long getIndexSizeMegabytesAsLong() {
        long kb = this.getIndexSizeKilobytesAsLong();
        return kb / 1024L;
    }

    public String getAverageQueryResponseTime() {
        try {
            QueryRuntimeStatistics instance = GlobalSystem.getSingleInstance().getQueryRuntimeStatistics();
            return String.valueOf(instance.getAverageQueriesResponseTime(this.id));
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public String getAverageQueriesPerMinute() {
        try {
            QueryRuntimeStatistics instance = GlobalSystem.getSingleInstance().getQueryRuntimeStatistics();
            return String.valueOf(instance.getAverageNumberQueriesPerMinute(this.id));
        }
        catch (Exception exception) {
            return "0";
        }
    }

    public boolean isCrawling() {
        return true;
    }

    public boolean isEnabledForSearch() {
        return this.enabledForSearch;
    }

    public void setEnabledForSearch(boolean enabledForSearch) {
        this.enabledForSearch = enabledForSearch;
    }

    public boolean isEnabledForSecurity() {
        return this.enabledForSecurity;
    }

    public void setEnabledForSecurity(boolean enabledForSecurity) {
        this.enabledForSecurity = enabledForSecurity;
    }

    public void recreate(Locale clientLocale) throws ExtendedException, InterruptedException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        if (mgr.collectionExists(this.getId())) {
            mgr.removeCollection(this.getId());
        }
        CollectionConfiguration collConfig = CollectionBean.toCollectionConfiguration(this, clientLocale);
        ConfigurationUtils.createCollection(collConfig);
    }

    public void create() throws ExtendedException {
        CollectionConfiguration collConfig = CollectionBean.toCollectionConfiguration(this);
        ConfigurationUtils.createCollection(collConfig);
        if (!ConfigurationUtils.collectionExists(this.id)) {
            Message msg = new Message("A0002E.COLLECTION_CREATION_ERROR");
            msg.addArgument(this.name);
            throw new ExtendedException(msg);
        }
    }

    protected static CollectionConfiguration toCollectionConfiguration(CollectionBean bean, Locale clientLocale) throws ExtendedException {
        CollectionConfiguration collConfig = CollectionConfiguration.createDefault();
        collConfig.setId(bean.getId());
        collConfig.setEnabledForSearch(bean.isEnabledForSearch());
        collConfig.setEnabledForSpellCorrection(bean.isSpellSuggestions());
        collConfig.setForceNgramForCJK(bean.isEnabledForNgram());
        if (!bean.isCacheDocuments()) {
            collConfig.getIndexDescriptors().remove(collConfig.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache));
        }
        return collConfig;
    }

    protected static CollectionConfiguration toCollectionConfiguration(CollectionBean bean) throws ExtendedException {
        return CollectionBean.toCollectionConfiguration(bean, Locale.getDefault());
    }

    public boolean delete() throws ExtendedException, InterruptedException {
        return CollectionBean.delete(this.getId());
    }

    public void update() throws ExtendedException, TransformerException, IOException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        CollectionConfiguration collConfig = mgr.getCollectionForUpdate(this.id);
        collConfig.setEnabledForSearch(this.enabledForSearch);
        collConfig.setEnabledForSpellCorrection(this.spellSuggestions);
        collConfig.setForceNgramForCJK(this.enabledForNgram);
        collConfig.setSecureSearch(this.enabledForSecurity);
        collConfig.setQueryTimeout(this.queryTimeout);
        boolean cacheExists = collConfig.isIndexDescriptorDefined(IndexDescriptor.IndexType.Cache);
        if (this.cacheDocuments) {
            if (!cacheExists) {
                IndexDescriptor newCacheIndex = IndexDescriptor.buildDescriptorFor(collConfig, IndexDescriptor.IndexType.Cache);
                Vector<IndexDescriptor> indexes = collConfig.getIndexDescriptors();
                indexes.add(newCacheIndex);
            }
        } else if (cacheExists) {
            Vector<IndexDescriptor> indexes = collConfig.getIndexDescriptors();
            IndexDescriptor cacheIndex = collConfig.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
            indexes.remove(cacheIndex);
        }
        this.parserSettingsBean.update();
        this.categorizationSettingsBean.update();
        mgr.updateCollection(collConfig);
    }

    public String toXml() {
        StringBuffer sb = new StringBuffer();
        sb.append("<Collection>");
        sb.append("<id>");
        sb.append(this.getId());
        sb.append("</id>");
        sb.append("<name>");
        sb.append(this.getName());
        sb.append("</name>");
        sb.append("<cacheDocuments>");
        sb.append(this.cacheDocuments);
        sb.append("</cacheDocuments>");
        sb.append("<spellSuggestions>");
        sb.append(this.spellSuggestions);
        sb.append("</spellSuggestions>");
        sb.append("<secureSearch");
        sb.append(this.enabledForSecurity);
        sb.append("</secureSearch>");
        sb.append("</Collection>");
        return sb.toString();
    }

    public static CollectionBean toCollectionBean(String collectionId) throws ExtendedException, ParserConfigurationException, SAXException, IOException {
        CollectionConfiguration collConfig = ConfigurationUtils.getConfiguration().getCollection(collectionId);
        return CollectionBean.toCollectionBean(collConfig);
    }

    public static String toXml(String collectionId) throws ExtendedException, ParserConfigurationException, SAXException, IOException {
        CollectionConfiguration collConfig = ConfigurationUtils.getConfiguration().getCollection(collectionId);
        return CollectionBean.toCollectionBean(collConfig).toXml();
    }

    public static CollectionBean toCollectionBean(CollectionConfiguration collConfig) throws ExtendedException, ParserConfigurationException, SAXException, IOException {
        CollectionBean collBean = new CollectionBean();
        collBean.parserSettingsBean = new ParserSettingsBean(collConfig.getId());
        collBean.categorizationSettingsBean = new CategorizationSettingsBean(collConfig.getId());
        collBean.setId(collConfig.getId());
        collBean.setName(collConfig.getId());
        collBean.setQueryTimeout(collConfig.getQueryTimeout());
        boolean cacheExists = collConfig.isIndexDescriptorDefined(IndexDescriptor.IndexType.Cache);
        collBean.setCacheDocuments(cacheExists);
        collBean.setSpellSuggestions(collConfig.isEnabledForSpellCorrection());
        collBean.setEnabledForSearch(collConfig.isEnabledForSearch());
        collBean.setEnabledForSecurity(collConfig.isSecureSearch());
        collBean.setEnabledForNgram(collConfig.isForceNgramForCJK());
        collBean.setSynonymBeans(SynonymBean.retrieveAll(collConfig.getId()));
        collBean.setQuickLinkBeans(QuickLinkBean.retrieveAll(collConfig.getId()));
        return collBean;
    }

    public static List list() throws ExtendedException, ParserConfigurationException, SAXException, IOException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        Vector<String> ids = mgr.getCollectionIds();
        CollectionListBean collections = new CollectionListBean();
        CollectionConfiguration collConfig = null;
        CollectionBean collBean = null;
        for (int i = 0; i < ids.size(); ++i) {
            collConfig = mgr.getCollection(ids.elementAt(i));
            collBean = CollectionBean.toCollectionBean(collConfig);
            collections.add(collBean);
        }
        return collections;
    }

    public static void deleteCache(String collectionId) throws ExtendedException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        CollectionConfiguration collConfig = mgr.getCollectionForUpdate(collectionId);
        boolean cacheExists = collConfig.isIndexDescriptorDefined(IndexDescriptor.IndexType.Cache);
        if (cacheExists) {
            Vector<IndexDescriptor> indexes = collConfig.getIndexDescriptors();
            IndexDescriptor cacheIndex = collConfig.getIndexDescriptorFor(IndexDescriptor.IndexType.Cache);
            indexes.remove(cacheIndex);
        }
        mgr.updateCollection(collConfig);
    }

    public static void startCache(String collectionId) throws ExtendedException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        CollectionConfiguration collConfig = mgr.getCollectionForUpdate(collectionId);
        boolean cacheExists = collConfig.isIndexDescriptorDefined(IndexDescriptor.IndexType.Cache);
        if (!cacheExists) {
            IndexDescriptor newCacheIndex = IndexDescriptor.buildDescriptorFor(collConfig, IndexDescriptor.IndexType.Cache);
            Vector<IndexDescriptor> indexes = collConfig.getIndexDescriptors();
            indexes.add(newCacheIndex);
        }
        mgr.updateCollection(collConfig);
    }

    public static boolean delete(String collectionId) throws ExtendedException, InterruptedException {
        ConfigurationManager mgr = ConfigurationUtils.getConfiguration();
        if (mgr.collectionExists(collectionId)) {
            mgr.removeCollection(collectionId);
        }
        return true;
    }

    public static boolean optimize(String collectionId) throws ExtendedException, InterruptedException {
        DocumentQueueInterface docQueue = GlobalSystem.getSingleInstance().getDocumentQueue();
        OptimizeIndexDocument document = new OptimizeIndexDocument();
        docQueue.addDocument(collectionId, document);
        UpdateIndexDocument updateIndexDocument = new UpdateIndexDocument();
        docQueue.addDocument(collectionId, updateIndexDocument);
        while (docQueue.getCounter() > 0) {
            Thread.sleep(100L);
        }
        return true;
    }

    public static String getStatistics(String collectionId, Locale locale) throws ExtendedException, ParserConfigurationException, SAXException, IOException {
        CollectionBean collBean = CollectionBean.toCollectionBean(collectionId);
        StringBuffer sb = new StringBuffer();
        sb.append("<Collection>");
        sb.append("<QueryResponseTime>");
        sb.append(collBean.getAverageQueryResponseTime());
        sb.append("</QueryResponseTime>");
        sb.append("<NumberOfQueries>");
        sb.append(collBean.getAverageQueriesPerMinute());
        sb.append("</NumberOfQueries>");
        sb.append("<UrlsPerSecond>");
        sb.append(collBean.getWebCrawlerBean().getUrlsCrawledPerMinute());
        sb.append("</UrlsPerSecond>");
        sb.append("<UrlsCrawledThisSession>");
        sb.append(collBean.getWebCrawlerBean().getUrlsCrawledThisSession());
        sb.append("</UrlsCrawledThisSession>");
        sb.append("<DocumentsCrawledPerSecond>");
        sb.append(collBean.getFileSystemCrawlerBean().getDocumentsCrawledPerMinute());
        sb.append("</DocumentsCrawledPerSecond>");
        sb.append("<DocumentsCrawledThisSession>");
        sb.append(collBean.getFileSystemCrawlerBean().getDocumentsCrawledThisSession());
        sb.append("</DocumentsCrawledThisSession>");
        sb.append("<DocCount>");
        sb.append(collBean.getDocCountFormatted());
        sb.append("</DocCount>");
        sb.append("<IndexSize>");
        sb.append(collBean.getIndexSizeMegabytesFormatted());
        sb.append("</IndexSize>");
        sb.append("</Collection>");
        return sb.toString();
    }

    public boolean isEnabledForNgram() {
        return this.enabledForNgram;
    }

    public void setEnabledForNgram(boolean enabledForNgram) {
        this.enabledForNgram = enabledForNgram;
    }

    public int getQueryTimeout() {
        return this.queryTimeout;
    }

    public void setQueryTimeout(int queryTimeout) {
        this.queryTimeout = queryTimeout;
    }
}

