/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common.admin.beans;

import com.ibm.es.nuvo.util.XMLDOMUtils;
import com.ibm.json.java.JSONArray;
import com.ibm.json.java.JSONObject;
import com.ibm.supa.config.ConfigurationLoader;
import java.io.File;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.struts.action.ActionForm;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CategorizationSettingsBean
extends ActionForm
implements Cloneable {
    private static final String WRITE_FIELD_VALUE = "categorization";
    Document doc;
    private File categorizationFile;
    Element[] beanElements = null;
    int beanElementsLength = 0;
    private JSONArray beanJSONArray = null;
    private static final long serialVersionUID = 1L;
    private String collectionId = null;

    public CategorizationSettingsBean() {
    }

    public CategorizationSettingsBean(String collectionId) throws ParserConfigurationException, SAXException, IOException {
        this.collectionId = collectionId;
        this.categorizationFile = new File(ConfigurationLoader.getSupaDirectoryPath(collectionId), "metadataPlugin-config.xml");
        this.doc = XMLDOMUtils.readAsNonValidatingDOM(this.categorizationFile);
        this.getDataFromXML();
    }

    public void getDataFromXML() {
        this.getRelevantBeansFromXML();
        try {
            this.beanJSONArray = new JSONArray();
        }
        catch (Exception e) {
            // empty catch block
        }
        for (int i = 0; i < this.beanElementsLength; ++i) {
            JSONObject beanJSONObject = null;
            try {
                beanJSONObject = new JSONObject();
                beanJSONObject.put((Object)"readField", (Object)this.getReadFieldFromXML(this.beanElements[i]));
                beanJSONObject.put((Object)"entries", (Object)this.getRulesFromXML(this.beanElements[i]));
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.beanJSONArray.add((Object)beanJSONObject);
        }
    }

    public void getRelevantBeansFromXML() {
        Element[] writeFieldElements = XMLDOMUtils.getElements("/beans/bean/property@name=writeField", this.doc, -1);
        if (writeFieldElements == null) {
            return;
        }
        this.beanElements = new Element[writeFieldElements.length];
        for (int i = 0; i < writeFieldElements.length; ++i) {
            if (!writeFieldElements[i].getAttribute("value").toString().equals(WRITE_FIELD_VALUE)) continue;
            this.beanElements[this.beanElementsLength] = (Element)writeFieldElements[i].getParentNode();
            ++this.beanElementsLength;
        }
    }

    public String getReadFieldFromXML(Element beanElement) {
        NodeList listOfProperties = beanElement.getElementsByTagName("property");
        for (int i = 0; i < listOfProperties.getLength(); ++i) {
            if (listOfProperties.item(i).getAttributes().getNamedItem("name").getNodeValue().compareTo("readField") != 0) continue;
            return listOfProperties.item(i).getAttributes().getNamedItem("value").getNodeValue();
        }
        return "";
    }

    public JSONArray getRulesFromXML(Element beanElement) {
        NodeList entry = beanElement.getElementsByTagName("entry");
        JSONArray entryJSONArray = null;
        try {
            entryJSONArray = new JSONArray();
        }
        catch (Exception e) {
            // empty catch block
        }
        int numberOfEntries = entry.getLength();
        for (int i = 0; i < numberOfEntries; ++i) {
            String regularExpression = entry.item(i).getAttributes().getNamedItem("key").getNodeValue();
            Element entryElem = (Element)entry.item(i);
            NodeList bean = entryElem.getElementsByTagName("bean");
            JSONArray valueJSONArray = null;
            try {
                valueJSONArray = new JSONArray();
            }
            catch (Exception e) {
                // empty catch block
            }
            int numberOfBeans = bean.getLength();
            for (int j = 0; j < numberOfBeans; ++j) {
                String valuesString = "";
                Element beanElem = (Element)bean.item(j);
                NodeList values = beanElem.getElementsByTagName("value");
                for (int k = 0; k < values.getLength(); ++k) {
                    valuesString = valuesString + "/" + values.item(k).getTextContent();
                }
                valueJSONArray.add((Object)valuesString.substring(1));
            }
            try {
                JSONObject entryJSONObject = new JSONObject();
                entryJSONObject.put((Object)"regularExpression", (Object)regularExpression);
                entryJSONObject.put((Object)"values", (Object)valueJSONArray);
                entryJSONArray.add((Object)entryJSONObject);
                continue;
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return entryJSONArray;
    }

    public String getBeanJSONArray() {
        return this.beanJSONArray.toString();
    }

    public void setBeanJSONArray(String jsonArray) {
        try {
            this.beanJSONArray = JSONArray.parse((String)jsonArray);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    public String getCollectionId() {
        return this.collectionId;
    }

    public void setCollectionId(String collectionId) {
        this.collectionId = collectionId;
    }

    public void update() throws TransformerException, IOException {
        this.setRulesToXML();
        this.setWriteFieldToXML();
        this.saveDataToXML();
    }

    private JSONObject getJSONElement(JSONArray array, int i) {
        return (JSONObject)array.get(i);
    }

    private JSONArray getJSONArray(JSONObject o, String key) {
        return (JSONArray)o.get((Object)key);
    }

    public void setRulesToXML() {
        this.deleteBeansFromXML();
        try {
            Element elementBeans = XMLDOMUtils.getAllNodes(this.doc, "/beans").get(0);
            Element firstBean = this.doc.createElement("bean");
            firstBean.setAttribute("id", "categorizer");
            firstBean.setAttribute("class", "com.ibm.supa.metadata.plugins.ChainedMetadataPlugin");
            firstBean.setAttribute("scope", "prototype");
            if (this.beanJSONArray.size() != 0) {
                Element firstBeanProperty = this.doc.createElement("property");
                firstBeanProperty.setAttribute("name", "next");
                firstBeanProperty.setAttribute("ref", "generated" + (this.beanJSONArray.size() - 1));
                firstBean.appendChild(firstBeanProperty);
            }
            elementBeans.appendChild(firstBean);
            for (int i = 0; i < this.beanJSONArray.size(); ++i) {
                Element elementOuterBean = this.doc.createElement("bean");
                elementOuterBean.setAttribute("id", "generated" + i);
                elementOuterBean.setAttribute("class", "com.ibm.supa.metadata.plugins.RegexMetadataPlugin");
                elementOuterBean.setAttribute("scope", "prototype");
                String readFieldString = (String)this.getJSONElement(this.beanJSONArray, i).get((Object)"readField");
                Element elementProperty1 = this.doc.createElement("property");
                elementProperty1.setAttribute("name", "readField");
                elementProperty1.setAttribute("value", readFieldString);
                Element elementProperty2 = this.doc.createElement("property");
                elementProperty2.setAttribute("name", "writeField");
                elementProperty2.setAttribute("value", WRITE_FIELD_VALUE);
                Element elementProperty3 = this.doc.createElement("property");
                elementProperty3.setAttribute("name", "patternMap");
                Element elementMap = this.doc.createElement("map");
                JSONArray entriesArray = this.getJSONArray(this.getJSONElement(this.beanJSONArray, i), "entries");
                for (int j = 0; j < entriesArray.size(); ++j) {
                    Element elementOuterList = this.doc.createElement("list");
                    JSONArray valuesArray = this.getJSONArray(this.getJSONElement(entriesArray, j), "values");
                    for (int k = 0; k < valuesArray.size(); ++k) {
                        String valueString = (String)valuesArray.get(k);
                        String[] valueStringArray = valueString.split("/");
                        Element[] elementValueArray = new Element[valueStringArray.length];
                        Element[] elementRefArray = new Element[valueStringArray.length - 1];
                        Element elementInnerList = this.doc.createElement("list");
                        for (int l = 0; l < valueStringArray.length; ++l) {
                            elementValueArray[l] = this.doc.createElement("value");
                            elementValueArray[l].setTextContent(valueStringArray[l]);
                            elementInnerList.appendChild(elementValueArray[l]);
                            if (l == valueStringArray.length - 1) continue;
                            elementRefArray[l] = this.doc.createElement("ref");
                            elementRefArray[l].setAttribute("bean", "FACET_DELIM");
                            elementInnerList.appendChild(elementRefArray[l]);
                        }
                        Element elementConstructorArg = this.doc.createElement("constructor-arg");
                        elementConstructorArg.appendChild(elementInnerList);
                        Element elementInnerBean = this.doc.createElement("bean");
                        elementInnerBean.setAttribute("factory-bean", "stringUtils");
                        elementInnerBean.setAttribute("factory-method", "buildString");
                        elementInnerBean.appendChild(elementConstructorArg);
                        elementOuterList.appendChild(elementInnerBean);
                    }
                    Element elementEntry = this.doc.createElement("entry");
                    String regularExpressionString = (String)this.getJSONElement(entriesArray, j).get((Object)"regularExpression");
                    elementEntry.setAttribute("key", regularExpressionString);
                    elementEntry.appendChild(elementOuterList);
                    elementMap.appendChild(elementEntry);
                }
                elementProperty3.appendChild(elementMap);
                if (i > 0) {
                    Element elementPropertyNext = this.doc.createElement("property");
                    elementPropertyNext.setAttribute("name", "next");
                    elementPropertyNext.setAttribute("ref", "generated" + (i - 1));
                    elementOuterBean.appendChild(elementPropertyNext);
                }
                elementOuterBean.appendChild(elementProperty1);
                elementOuterBean.appendChild(elementProperty2);
                elementOuterBean.appendChild(elementProperty3);
                elementBeans.appendChild(elementOuterBean);
            }
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public void deleteBeansFromXML() {
        Element beans = XMLDOMUtils.getAllNodes(this.doc, "/beans").get(0);
        Element[] beanElements = XMLDOMUtils.getElements("/beans/bean", this.doc, -1);
        for (int i = 0; i < beanElements.length; ++i) {
            if (!beanElements[i].getAttribute("id").toString().equals("categorizer")) continue;
            beans.removeChild(beanElements[i]);
        }
        Element[] writeFieldElements = XMLDOMUtils.getElements("/beans/bean/property@name=writeField", this.doc, -1);
        for (int i = 0; i < writeFieldElements.length; ++i) {
            if (!writeFieldElements[i].getAttribute("value").toString().equals(WRITE_FIELD_VALUE)) continue;
            Element bean = (Element)writeFieldElements[i].getParentNode();
            beans.removeChild(bean);
        }
    }

    public void saveDataToXML() throws TransformerException, IOException {
        XMLDOMUtils.writeDOM(this.doc, this.categorizationFile);
    }

    public void setWriteFieldToXML() {
    }
}

