/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.util.XMLDOMUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ReleaseInfo {
    private static final String KeyRelease = "release";
    private static final String ReleaseInfoRoot = "releaseinfo";
    private static final String ReleasePropertiesFile = "release.properties";
    private static final String ReleaseConfigPrefix = "Release";
    private static final String ReleaseConfigSuffix = ".xml";
    private static final String WhitneyCoreJar = "whitney_core.jar";
    private static final String ReleaseOYE = "oye";
    private static final String ReleaseOYEBeta = "oyebeta";
    private static final String XPathSeparator = "/";
    private static ReleaseInfo releaseInfo = null;
    private static final String ComponentSystem = "System";
    private static final String XMLRootElement = "ReleaseRoot";
    private String releaseFileName = null;
    private String releaseJarFileName = null;
    private Release release = null;
    private Platform platform = Platform.windows;
    private GlobalConfiguration globalConfig = null;
    private Document releaseInfoXmlDom = null;

    public static void initialize(String releaseFile) throws ExtendedException {
        FileInputStream ris = null;
        if (releaseFile == null) {
            releaseFile = GlobalConfiguration.getConfiguration().getConfigPath() + File.separator + ReleaseInfoRoot + File.separator + ReleasePropertiesFile;
        }
        Properties relProps = new Properties();
        try {
            ris = new FileInputStream(releaseFile);
            relProps.load(ris);
        }
        catch (IOException e) {
            Message msg = new Message("G0140E.COULD_NOT_LOAD_RELEASE_INFO_CONFIG");
            msg.addArgument(releaseFile);
            ExtendedException ee = new ExtendedException(msg, (Throwable)e);
            throw ee;
        }
        finally {
            if (ris != null) {
                try {
                    ris.close();
                }
                catch (IOException e) {}
            }
        }
        ReleaseInfo.initializeFromProp(relProps);
    }

    public static void initializeFromProp(Properties buildProperties) throws ExtendedException {
        if (buildProperties == null) {
            Message msg = new Message("G0009E.ARGUMENT_INVALID_VALUE");
            msg.addArgument("buildProperties");
            msg.addArgument("null");
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
        String relStr = buildProperties.getProperty(KeyRelease);
        if (relStr == null) {
            Message msg = new Message("G0150E.COULD_NOT_DETERMINE_RELEASE_TYPE");
            msg.addArgument(KeyRelease);
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
        releaseInfo = new ReleaseInfo();
        releaseInfo.setGlobalConfig(GlobalConfiguration.getConfiguration());
        releaseInfo.setPlatform();
        try {
            releaseInfo.setRelease(relStr);
        }
        catch (IllegalArgumentException e) {
            Message msg = new Message("G0151E.INVALID_RELEASE");
            msg.addArgument(relStr);
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
        try {
            releaseInfo.loadReleaseInfofromXMLFileDom();
        }
        catch (ExtendedException ee) {
            releaseInfo = null;
            throw ee;
        }
    }

    public static ReleaseInfo getReleaseInfo() {
        return releaseInfo;
    }

    private void setGlobalConfig(GlobalConfiguration _globalConfig) {
        this.globalConfig = _globalConfig;
    }

    private void setRelease(String rel) {
        this.release = rel.equalsIgnoreCase(ReleaseOYE) ? Release.whitney : (rel.equalsIgnoreCase(ReleaseOYEBeta) ? Release.whitney_beta : Release.valueOf(rel));
    }

    private void setPlatform() {
        if (this.globalConfig != null) {
            if (this.globalConfig.isLinux()) {
                this.platform = Platform.linux;
            } else if (this.globalConfig.isWindows()) {
                this.platform = Platform.windows;
            }
        }
    }

    private void loadReleaseInfofromXMLFileDom() throws ExtendedException {
        String releaseString = this.release.toString();
        String whitneyCoreJar = this.globalConfig.getInstallPath() + File.separator + "lib" + File.separator + WhitneyCoreJar;
        String releaseFile = ReleaseConfigPrefix + releaseString.toUpperCase().charAt(0) + releaseString.substring(1) + ReleaseConfigSuffix;
        InputStream ris = null;
        try {
            try {
                ris = ReleaseInfo.class.getResourceAsStream(XPathSeparator + releaseFile);
                this.releaseJarFileName = whitneyCoreJar;
            }
            catch (Throwable e) {
                ris = null;
            }
            if (ris == null) {
                releaseFile = this.globalConfig.getConfigPath() + File.separator + ReleaseInfoRoot + File.separator + ReleaseConfigPrefix + releaseString.toUpperCase().charAt(0) + releaseString.substring(1) + ReleaseConfigSuffix;
                ris = new FileInputStream(releaseFile);
            }
            this.releaseInfoXmlDom = XMLDOMUtils.readAsNonValidatingDOM(ris);
        }
        catch (Throwable e) {
            Message msg = new Message("G0140E.COULD_NOT_LOAD_RELEASE_INFO_CONFIG");
            msg.addArgument(releaseFile);
            ExtendedException ee = new ExtendedException(msg, e);
            throw ee;
        }
        this.releaseFileName = releaseFile;
    }

    public boolean getValueAsBoolean(String componentID, String key, boolean defaultValue) throws ExtendedException {
        String value = this.getValue(componentID, key);
        if (value == null) {
            return defaultValue;
        }
        if ((value = value.trim()).equals("true") || value.equals("yes") || value.equals("on") || value.equals("1")) {
            return true;
        }
        if (value.equals("false") || value.equals("no") || value.equals("off") || value.equals("0")) {
            return false;
        }
        Message msg = new Message("G0141E.RELEASE_INFO_KEY_NOT_BOOLEAN");
        msg.addArgument(key);
        msg.addArgument(componentID);
        msg.addArgument(value);
        ExtendedException ee = new ExtendedException(msg);
        throw ee;
    }

    public int getValueAsInt(String componentID, String key, int defaultValue) throws ExtendedException {
        String value = this.getValue(componentID, key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(value.trim());
        }
        catch (NumberFormatException nfe) {
            Message msg = new Message("G0142E.RELEASE_INFO_KEY_NOT_INT");
            msg.addArgument(key);
            msg.addArgument(componentID);
            msg.addArgument(value);
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
    }

    public long getValueAsLong(String componentID, String key, long defaultValue) throws ExtendedException {
        String value = this.getValue(componentID, key);
        if (value == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (NumberFormatException nfe) {
            Message msg = new Message("G0167E.RELEASE_INFO_KEY_NOT_LONG");
            msg.addArgument(key);
            msg.addArgument(componentID);
            msg.addArgument(value);
            ExtendedException ee = new ExtendedException(msg);
            throw ee;
        }
    }

    public String getValue(String componentID, String key) {
        String rootPrefixedComponentID = "/ReleaseRoot/" + componentID;
        String platformSpecificPath = rootPrefixedComponentID + XPathSeparator + this.platform.toString() + XPathSeparator + key;
        String platformDefaultPath = rootPrefixedComponentID + XPathSeparator + Platform.all.toString() + XPathSeparator + key;
        Vector<Element> elements = XMLDOMUtils.getAllNodes(this.releaseInfoXmlDom, platformSpecificPath);
        if (elements.isEmpty() && (elements = XMLDOMUtils.getAllNodes(this.releaseInfoXmlDom, platformDefaultPath)).isEmpty()) {
            return null;
        }
        return elements.get(0).getTextContent();
    }

    public boolean isKeyPresent(String componentID, String key) {
        return this.getValue(componentID, key) != null;
    }

    public String getReleaseName() {
        return this.release.toString();
    }

    public String getReleaseJarFileName() {
        return this.releaseJarFileName;
    }

    public String getReleaseFileName() {
        return this.releaseFileName;
    }

    @Deprecated
    public boolean isElbrus() {
        return this.release == Release.elbrus;
    }

    @Deprecated
    public boolean isSutter() {
        return this.release == Release.sutter;
    }

    @Deprecated
    public boolean isWhitney() {
        return this.release == Release.whitney;
    }

    public long getQueryPerDayLimit() throws ExtendedException {
        String qpdKey = "QueryPerDay";
        return this.getValueAsLong(ComponentSystem, qpdKey, Long.MAX_VALUE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Platform {
        windows,
        linux,
        aix,
        solaris,
        all;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Release {
        whitney,
        whitney_beta,
        elbrus,
        supa_external,
        elbrus_c,
        sutter,
        sutter_luw;

    }
}

