/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class MetadataSerializer<T> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private ParseTree parseTree;
    private SoftReferencePool<Parser> parsers;
    private SoftReferencePool<XMLTagger> taggers = new SoftReferencePool();

    protected abstract void writeTo(T var1, XMLTagger var2);

    protected abstract T createInstance();

    protected abstract void prepareParseTree(ParseTree var1);

    public MetadataSerializer() {
        this.parsers = new SoftReferencePool();
        this.parseTree = new ParseTree();
        this.prepareParseTree(this.parseTree);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void serialize(OutputStream os, T metadata) throws IOException {
        XMLTagger tagger = null;
        SoftReferencePool<XMLTagger> softReferencePool = this.taggers;
        synchronized (softReferencePool) {
            tagger = this.taggers.get();
            if (tagger == null) {
                tagger = new XMLTagger(false, 1024);
            } else {
                tagger.reset();
            }
        }
        try {
            tagger.writeText("<?xml version='1.0' encoding='UTF-8'?>", false);
            this.writeTo(metadata, tagger);
            os.write(tagger.getXML().getBytes("UTF-8"));
        }
        finally {
            softReferencePool = this.taggers;
            synchronized (softReferencePool) {
                this.taggers.add(tagger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    T deserialize(InputStream is) throws ParseException {
        Parser p = null;
        SoftReferencePool<Parser> softReferencePool = this.parsers;
        synchronized (softReferencePool) {
            p = this.parsers.get();
            if (p == null) {
                p = new Parser();
            }
        }
        try {
            T metadata = this.createInstance();
            p.parse(is, this.parseTree, metadata);
            T t = metadata;
            return t;
        }
        finally {
            SoftReferencePool<Parser> softReferencePool2 = this.parsers;
            synchronized (softReferencePool2) {
                this.parsers.add(p);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class SoftReferencePool<T> {
        private static int MAX_POOL_SIZE = 5;
        private List<SoftReference<T>> objs = new LinkedList<SoftReference<T>>();

        public void add(T obj) {
            while (this.objs.size() >= MAX_POOL_SIZE) {
                this.objs.remove(0);
            }
            this.objs.add(new SoftReference<T>(obj));
        }

        public T get() {
            T obj = null;
            while (obj == null && this.objs.size() > 0) {
                SoftReference<T> r = this.objs.remove(0);
                obj = r.get();
            }
            return obj;
        }
    }
}

