/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import com.ibm.es.nuvo.common.MetadataSerializer;
import com.ibm.es.nuvo.util.DateParser;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.decimal.Decimal;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataPart {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Map<String, Values> values = new LinkedHashMap<String, Values>();
    private static final String MetadataPartElement = "metadatapart";
    private static final String TypeAttribute = "type";
    private static final String PropertyElement = "property";
    private static final String[] ElementPropertyAttributes = new String[]{"name", "value", "numeric"};
    private static final String[] ElementPropertyAttributesDefaults = new String[]{"", "", ""};
    private static MetadataSerializer<MetadataPart> serializer = new MetadataSerializer<MetadataPart>(){

        @Override
        protected MetadataPart createInstance() {
            return new MetadataPart();
        }

        @Override
        protected void prepareParseTree(ParseTree tree) {
            MetadataPart.prepareParseTree("", tree);
        }

        @Override
        protected void writeTo(MetadataPart obj, XMLTagger tagger) {
            obj.writeTo(tagger, null);
        }
    };

    public static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        tree.addSetSubcomponent(parentPath + MetadataPartElement, "createMetadata", new String[]{TypeAttribute}, new String[]{null});
        parentPath = parentPath + "metadatapart/";
        tree.addCallMethod(parentPath + PropertyElement, "addFromXML", ElementPropertyAttributes, ElementPropertyAttributesDefaults);
    }

    public void writeTo(XMLTagger tagger, String type) {
        tagger.openStartElement(MetadataPartElement);
        if (type != null) {
            tagger.writeAttr(TypeAttribute, type);
        }
        tagger.closeTag();
        for (Map.Entry<String, Value> curEntry : this.keyValues()) {
            tagger.openStartElement(PropertyElement);
            tagger.writeAttr(ElementPropertyAttributes[0], curEntry.getKey());
            Value value = curEntry.getValue();
            tagger.writeAttr(ElementPropertyAttributes[1], value.toString());
            if (value.getNumericValue() != null) {
                tagger.writeAttr(ElementPropertyAttributes[2], value.getNumericValue().toString());
            }
            tagger.closeEndElementTag();
        }
        tagger.endElement(MetadataPartElement);
    }

    public static void serialize(OutputStream os, MetadataPart metadata) throws IOException {
        serializer.serialize(os, metadata);
    }

    public static MetadataPart deserialize(InputStream is) throws ParseException {
        return serializer.deserialize(is);
    }

    public boolean equals(Object o) {
        return o instanceof MetadataPart ? ((Object)this.values).equals(((MetadataPart)o).values) : false;
    }

    public int hashCode() {
        if (null != this.values) {
            return ((Object)this.values).hashCode();
        }
        return 0;
    }

    public void set(String key, Value value) {
        if (key == null || value == null) {
            return;
        }
        this.values.put(key, new Values(value));
    }

    public void set(String key, String value) {
        if (value == null) {
            return;
        }
        this.set(key, new Value(value));
    }

    public void set(String key, boolean value) {
        this.set(key, MetadataPart.createValue(value, null));
    }

    public void set(String key, boolean value, String textValue) {
        this.set(key, MetadataPart.createValue(value, textValue));
    }

    public void set(String key, Date value) {
        this.set(key, MetadataPart.createValue(value, null));
    }

    public void set(String key, Date value, String textValue) {
        this.set(key, MetadataPart.createValue(value, textValue));
    }

    public void set(String key, double value) {
        this.set(key, MetadataPart.createValue(value, null));
    }

    public void set(String key, double value, String textValue) {
        this.set(key, MetadataPart.createValue(value, textValue));
    }

    public void set(String key, long value) {
        this.set(key, MetadataPart.createValue(value, null));
    }

    public void set(String key, long value, String textValue) {
        this.set(key, MetadataPart.createValue(value, textValue));
    }

    public void remove(String key) {
        this.values.remove(key);
    }

    public void add(String key, Value value) {
        if (key == null || value == null) {
            return;
        }
        Values currentValues = this.values.get(key);
        if (currentValues == null) {
            currentValues = new Values(value);
            this.values.put(key, currentValues);
        } else {
            currentValues.add(value);
        }
    }

    public void add(String key, String value) {
        if (value == null) {
            return;
        }
        this.add(key, new Value(value));
    }

    public void addFromXML(String key, String value, String numeric) {
        if (value == null) {
            return;
        }
        Value val = new Value(value);
        if (numeric != null && numeric.trim().length() > 0) {
            try {
                val.setNumericValue(Decimal.parseDecimal(numeric));
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        this.add(key, val);
    }

    public void add(String key, boolean value) {
        this.add(key, MetadataPart.createValue(value, null));
    }

    public void add(String key, boolean value, String textValue) {
        this.add(key, MetadataPart.createValue(value, textValue));
    }

    public void add(String key, Date value) {
        this.add(key, MetadataPart.createValue(value, null));
    }

    public void add(String key, Date date, String textValue) {
        this.add(key, MetadataPart.createValue(date, textValue));
    }

    public void add(String key, double value) {
        this.add(key, MetadataPart.createValue(value, null));
    }

    public void add(String key, double value, String textValue) {
        this.add(key, MetadataPart.createValue(value, textValue));
    }

    public void add(String key, long value) {
        this.add(key, MetadataPart.createValue(value, null));
    }

    public void add(String key, long value, String textValue) {
        this.add(key, MetadataPart.createValue(value, textValue));
    }

    public String get(String key) {
        Values currentValues = this.values.get(key);
        return currentValues != null ? currentValues.getFirstValue().toString() : null;
    }

    public String get(String key, String defaultValue) {
        String ret = this.get(key);
        return ret != null ? ret : defaultValue;
    }

    public List<Value> getValues(String key) {
        Values value = this.values.get(key);
        return value != null ? new ArrayList<Value>(value.getValues()) : null;
    }

    public void putAll(MetadataPart other) {
        for (Map.Entry<String, Value> entry : other.keyValues()) {
            this.add(entry.getKey(), new Value(entry.getValue()));
        }
    }

    public void setAll(MetadataPart other) {
        for (Map.Entry<String, String> entry : other.entries()) {
            this.set(entry.getKey(), new Value(entry.getValue()));
        }
    }

    public Set<String> keySet() {
        return this.values.keySet();
    }

    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    public boolean contains(String key) {
        return this.values.containsKey(key);
    }

    public List<Map.Entry<String, String>> entries() {
        ArrayList<Map.Entry<String, String>> list = new ArrayList<Map.Entry<String, String>>();
        for (Map.Entry<String, Values> entry : this.values.entrySet()) {
            Values value = entry.getValue();
            value.addTo(list, entry.getKey());
        }
        return list;
    }

    public List<Map.Entry<String, Value>> keyValues() {
        ArrayList<Map.Entry<String, Value>> list = new ArrayList<Map.Entry<String, Value>>();
        for (Map.Entry<String, Values> entry : this.values.entrySet()) {
            Values value = entry.getValue();
            value.addAll(list, entry.getKey());
        }
        return list;
    }

    public int size() {
        int size = 0;
        for (Values value : this.values.values()) {
            size += value.size();
        }
        return size;
    }

    private static final Value createValue(boolean value, String text) {
        if (text == null) {
            text = Boolean.toString(value);
        }
        Value v = new Value(text);
        v.setNumericValue(new Decimal(value ? 1L : 0L));
        return v;
    }

    private static final Value createValue(Date value, String text) {
        if (value == null) {
            return null;
        }
        if (text == null) {
            text = DateParser.format(value);
        }
        Value v = new Value(text);
        v.setNumericValue(new Decimal(value));
        return v;
    }

    private static final Value createValue(double value, String text) {
        if (text == null) {
            text = Double.toString(value);
        }
        Value v = new Value(text);
        v.setNumericValue(new Decimal(value, 15));
        return v;
    }

    private static final Value createValue(long value, String text) {
        if (text == null) {
            text = Long.toString(value);
        }
        Value v = new Value(text);
        v.setNumericValue(new Decimal(value));
        return v;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Metadata : ").append(this.values.toString());
        return sb.toString();
    }

    public static class Value
    implements CharSequence {
        private CharSequence charValue;
        private Decimal numericValue;

        public boolean equals(Object o) {
            boolean ret = false;
            if (o instanceof Value) {
                Value other = (Value)o;
                boolean bl = this.charValue != null ? this.charValue.equals(other.charValue) : (ret = other.charValue == null);
                if (ret) {
                    ret = this.numericValue != null ? this.numericValue.equals(other.numericValue) : other.numericValue == null;
                }
            }
            return ret;
        }

        public int hashCode() {
            if (null != this.charValue) {
                return this.charValue.hashCode();
            }
            if (null != this.numericValue) {
                return this.numericValue.hashCode();
            }
            return 0;
        }

        Value(CharSequence charValue) {
            this.charValue = charValue;
        }

        Value(Value value) {
            this.charValue = value.charValue;
            this.numericValue = value.numericValue;
        }

        public char charAt(int index) {
            return this.charValue.charAt(index);
        }

        public int length() {
            return this.charValue.length();
        }

        public CharSequence subSequence(int start, int end) {
            return this.charValue.subSequence(start, end);
        }

        public Decimal getNumericValue() {
            return this.numericValue;
        }

        public void setNumericValue(Decimal value) {
            this.numericValue = value;
        }

        public String toString() {
            return ((Object)this.charValue).toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Values {
        private Value value;
        private List<Value> values;

        public boolean equals(Object o) {
            boolean ret = false;
            if (o instanceof Values) {
                Values other = (Values)o;
                boolean bl = this.value != null ? this.value.equals(other.value) : (ret = other.value == null);
                if (ret) {
                    ret = this.values != null ? ((Object)this.values).equals(other.values) : other.values == null;
                }
                return ret;
            }
            return ret;
        }

        public int hashCode() {
            if (null != this.value) {
                return this.value.hashCode();
            }
            if (null != this.values) {
                return ((Object)this.values).hashCode();
            }
            return 0;
        }

        Values(Value value) {
            this.value = value;
        }

        void add(Value newValue) {
            if (this.values == null) {
                if (this.value == null) {
                    this.value = newValue;
                    return;
                }
                this.values = new ArrayList<Value>();
                this.values.add(this.value);
                this.value = null;
            }
            this.values.add(newValue);
        }

        Value getFirstValue() {
            if (this.value != null) {
                return this.value;
            }
            if (this.values != null) {
                return this.values.get(0);
            }
            return null;
        }

        List<Value> getValues() {
            if (this.value != null) {
                ArrayList<Value> ret = new ArrayList<Value>();
                ret.add(this.value);
                return ret;
            }
            if (this.values != null) {
                return this.values;
            }
            return null;
        }

        void addTo(List<Map.Entry<String, String>> list, String myName) {
            if (this.values != null) {
                for (Value newValue : this.values) {
                    list.add(new Entry<String>(myName, newValue.toString()));
                }
            } else if (this.value != null) {
                list.add(new Entry<String>(myName, this.value.toString()));
            }
        }

        void addAll(List<Map.Entry<String, Value>> list, String myName) {
            if (this.values != null) {
                for (Value newValue : this.values) {
                    list.add(new Entry<Value>(myName, newValue));
                }
            } else if (this.value != null) {
                list.add(new Entry<Value>(myName, this.value));
            }
        }

        int size() {
            if (this.values != null) {
                return this.values.size();
            }
            return this.value != null ? 1 : 0;
        }

        public String toString() {
            if (this.value != null) {
                return this.value.toString();
            }
            if (this.values != null) {
                return this.values.toString();
            }
            return "(null)";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Entry<T>
    implements Map.Entry<String, T> {
        private String key;
        private T value;

        Entry(String key, T value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public T getValue() {
            return this.value;
        }

        @Override
        public T setValue(T value) {
            T prev = this.value;
            this.value = value;
            return prev;
        }

        public String toString() {
            return this.key + "," + this.value;
        }
    }
}

