/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import com.ibm.es.nuvo.common.ACL;
import com.ibm.es.nuvo.common.MetadataPart;
import com.ibm.es.nuvo.common.MetadataSerializer;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metadata {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String ATTR_CRAWLER_FIELDS = "fields";
    private static final String ATTR_CRAWLER_METADATA = "crawler";
    private static final String ATTR_IMPLICIT_FIELDS = "implicit";
    private static final String ATTR_PARSER_METADATA = "parser";
    public static final String ELEM_METADATA = "metadata";
    private static final String NL = System.getProperty("line.separator", "\r\n");
    private static MetadataSerializer<Metadata> serializer = new MetadataSerializer<Metadata>(){

        @Override
        protected Metadata createInstance() {
            return new Metadata();
        }

        @Override
        protected void prepareParseTree(ParseTree tree) {
            Metadata.prepareParseTree("", tree);
        }

        @Override
        protected void writeTo(Metadata obj, XMLTagger tagger) {
            obj.writeTo(tagger);
        }
    };
    private ACL acl;
    private MetadataPart crawlerFields;
    private MetadataPart crawlerImplicitFields;
    private MetadataPart crawlerMetadata = new MetadataPart();
    private boolean fixed = false;
    private MetadataPart parserMetadata;

    public static Metadata deserialize(InputStream is) throws ParseException {
        return serializer.deserialize(is);
    }

    public static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        parentPath = parentPath + ELEM_METADATA + "/";
        MetadataPart.prepareParseTree(parentPath, tree);
        ACL.prepareParseTree(parentPath, tree);
    }

    public static void serialize(OutputStream os, Metadata metadata) throws IOException {
        serializer.serialize(os, metadata);
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof Metadata) {
            Metadata other = (Metadata)o;
            ret = this.crawlerMetadata.equals(other.crawlerMetadata);
            if (ret) {
                ret = this.crawlerImplicitFields.equals(other.crawlerImplicitFields);
            }
            if (ret) {
                ret = this.crawlerFields.equals(other.crawlerFields);
            }
            if (ret) {
                ret = this.parserMetadata.equals(other.parserMetadata);
            }
            if (ret) {
                ret = this.acl != null ? this.acl.equals(other.acl) : other.acl == null;
            }
        }
        return ret;
    }

    public int hashCode() {
        return this.crawlerMetadata.hashCode();
    }

    public Metadata() {
        this.crawlerImplicitFields = new MetadataPart();
        this.crawlerFields = new MetadataPart();
        this.parserMetadata = new MetadataPart();
    }

    public Metadata(Metadata metadata) {
        this();
        this.crawlerMetadata.putAll(metadata.crawlerMetadata);
        this.crawlerImplicitFields.putAll(metadata.crawlerImplicitFields);
        this.crawlerFields.putAll(metadata.crawlerFields);
        this.parserMetadata.putAll(metadata.parserMetadata);
    }

    public void add(String key, boolean value) {
        this.getPart(null).add(key, value);
    }

    public void add(String key, boolean value, String textValue) {
        this.getPart(null).add(key, value, textValue);
    }

    public void add(String key, Date value) {
        this.getPart(null).add(key, value);
    }

    public void add(String key, Date value, String textValue) {
        this.getPart(null).add(key, value, textValue);
    }

    public void add(String key, double value) {
        this.getPart(null).add(key, value);
    }

    public void add(String key, double value, String textValue) {
        this.getPart(null).add(key, value, textValue);
    }

    public void add(String key, long value) {
        this.getPart(null).add(key, value);
    }

    public void add(String key, long value, String textValue) {
        this.getPart(null).add(key, value, textValue);
    }

    public void add(String key, String value) {
        this.getPart(null).add(key, value);
    }

    public void add(Type type, String key, boolean value) {
        this.getPart(type).add(key, value);
    }

    public void add(Type type, String key, boolean value, String textValue) {
        this.getPart(type).add(key, value, textValue);
    }

    public void add(Type type, String key, Date value) {
        this.getPart(type).add(key, value);
    }

    public void add(Type type, String key, Date value, String textValue) {
        this.getPart(type).add(key, value, textValue);
    }

    public void add(Type type, String key, double value) {
        this.getPart(type).add(key, value);
    }

    public void add(Type type, String key, double value, String textValue) {
        this.getPart(type).add(key, value, textValue);
    }

    public void add(Type type, String key, long value) {
        this.getPart(type).add(key, value);
    }

    public void add(Type type, String key, long value, String textValue) {
        this.getPart(type).add(key, value, textValue);
    }

    public void add(Type type, String key, String value) {
        this.getPart(type).add(key, value);
    }

    public boolean contains(String key) {
        return this.parserMetadata.contains(key) || this.crawlerMetadata.contains(key) || this.crawlerImplicitFields.contains(key) || this.crawlerFields.contains(key);
    }

    public ACL createACL(String domain) {
        this.acl = new ACL(domain);
        return this.acl;
    }

    public MetadataPart createMetadata(String type) {
        if (ATTR_CRAWLER_METADATA.equals(type)) {
            return this.crawlerMetadata;
        }
        if (ATTR_IMPLICIT_FIELDS.equals(type)) {
            return this.crawlerImplicitFields;
        }
        if (ATTR_CRAWLER_FIELDS.equals(type)) {
            return this.crawlerFields;
        }
        if (ATTR_PARSER_METADATA.equals(type)) {
            return this.parserMetadata;
        }
        return null;
    }

    public List<Map.Entry<String, String>> entries() {
        List<Map.Entry<String, String>> list = this.crawlerMetadata.entries();
        list.addAll(this.crawlerImplicitFields.entries());
        list.addAll(this.crawlerFields.entries());
        list.addAll(this.parserMetadata.entries());
        return list;
    }

    public void fix() {
        this.fixed = true;
    }

    public String get(String key) {
        String value = this.parserMetadata.get(key);
        if (value == null) {
            value = this.crawlerMetadata.get(key);
        }
        if (value == null) {
            value = this.crawlerImplicitFields.get(key);
        }
        if (value == null) {
            value = this.crawlerFields.get(key);
        }
        return value;
    }

    public List<MetadataPart.Value> getValues(String key) {
        List<MetadataPart.Value> values = this.parserMetadata.getValues(key);
        if (values == null) {
            values = this.crawlerMetadata.getValues(key);
        }
        if (values == null) {
            values = this.crawlerImplicitFields.getValues(key);
        }
        if (values == null) {
            values = this.crawlerFields.getValues(key);
        }
        if (values == null) {
            values = this.parserMetadata.getValues(key);
        }
        return values;
    }

    public ACL getACL() {
        return this.acl;
    }

    private MetadataPart getMetadataPart() {
        return this.fixed ? this.parserMetadata : this.crawlerMetadata;
    }

    public MetadataPart getMetadataPart(Type type) {
        switch (type) {
            case CrawlerFields: {
                return this.crawlerFields;
            }
            case CrawlerImplicit: {
                return this.crawlerImplicitFields;
            }
            case CrawlerMetadata: {
                return this.crawlerMetadata;
            }
            case ParserMetadata: {
                return this.parserMetadata;
            }
        }
        return null;
    }

    public void replaceMetadataPart(Type type, MetadataPart part) {
        switch (type) {
            case CrawlerFields: {
                this.crawlerFields = part;
                break;
            }
            case CrawlerImplicit: {
                this.crawlerImplicitFields = part;
                break;
            }
            case CrawlerMetadata: {
                this.crawlerMetadata = part;
                break;
            }
            case ParserMetadata: {
                this.parserMetadata = part;
                break;
            }
        }
    }

    private MetadataPart getPart(Type type) {
        if (type != null) {
            if (this.fixed && !type.equals((Object)Type.ParserMetadata)) {
                throw new IllegalArgumentException("This metadata has already been fixed.");
            }
            switch (type) {
                case CrawlerFields: {
                    return this.crawlerFields;
                }
                case CrawlerImplicit: {
                    return this.crawlerImplicitFields;
                }
                case CrawlerMetadata: {
                    return this.crawlerMetadata;
                }
                case ParserMetadata: {
                    return this.parserMetadata;
                }
            }
        }
        return this.fixed ? this.parserMetadata : this.crawlerFields;
    }

    public boolean isEmpty() {
        return this.parserMetadata.isEmpty() && this.crawlerMetadata.isEmpty() && this.crawlerImplicitFields.isEmpty() && this.crawlerFields.isEmpty();
    }

    public Set<String> keySet() {
        HashSet<String> keys = new HashSet<String>();
        keys.addAll(this.crawlerMetadata.keySet());
        keys.addAll(this.crawlerImplicitFields.keySet());
        keys.addAll(this.crawlerFields.keySet());
        keys.addAll(this.parserMetadata.keySet());
        return keys;
    }

    public void set(String key, boolean value) {
        this.getMetadataPart().set(key, value);
    }

    public void set(String key, boolean value, String textValue) {
        this.getMetadataPart().set(key, value, textValue);
    }

    public void set(String key, Date value) {
        this.getMetadataPart().set(key, value);
    }

    public void set(String key, Date value, String textValue) {
        this.getMetadataPart().set(key, value, textValue);
    }

    public void set(String key, double value) {
        this.getMetadataPart().set(key, value);
    }

    public void set(String key, double value, String textValue) {
        this.getMetadataPart().set(key, value, textValue);
    }

    public void set(String key, long value) {
        this.getMetadataPart().set(key, value);
    }

    public void set(String key, long value, String textValue) {
        this.getMetadataPart().set(key, value, textValue);
    }

    public void set(String key, String value) {
        this.getMetadataPart().set(key, value);
    }

    public void setACL(ACL acl) {
        this.acl = acl;
    }

    public int size() {
        return this.parserMetadata.size() + this.crawlerMetadata.size() + this.crawlerImplicitFields.size() + this.crawlerFields.size();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(128);
        if (this.acl != null) {
            sb.append("ACL : {" + this.acl.toString() + "}").append(NL);
        }
        sb.append("CrawlerMetadata : ").append(this.crawlerMetadata.toString()).append(NL).append("CrawlerImplicitFields : ").append(this.crawlerImplicitFields).append(NL).append("CrawlerFields : ").append(this.crawlerFields).append(NL).append("ParserMetadata : ").append(this.parserMetadata);
        return sb.toString();
    }

    public void writeTo(XMLTagger tagger) {
        tagger.startElement(ELEM_METADATA);
        this.crawlerMetadata.writeTo(tagger, ATTR_CRAWLER_METADATA);
        this.crawlerImplicitFields.writeTo(tagger, ATTR_IMPLICIT_FIELDS);
        this.crawlerFields.writeTo(tagger, ATTR_CRAWLER_FIELDS);
        this.parserMetadata.writeTo(tagger, ATTR_PARSER_METADATA);
        if (this.acl != null) {
            this.acl.writeTo(tagger);
        }
        tagger.endElement(ELEM_METADATA);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        CrawlerFields,
        CrawlerImplicit,
        CrawlerMetadata,
        ParserMetadata;

    }
}

