/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import com.ibm.es.nuvo.common.Message;
import java.util.ArrayList;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtendedException
extends Exception {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final long serialVersionUID = -7617243608521150152L;
    private static final String EndLine = System.getProperty("line.separator");
    private static final String DefaultIndentation = "   ";
    private static final Message CAUSES_OF_PROBLEM = new Message("A1741I.nested.exceptions");
    private static final String CAUSES_OF_PROBLEM_FALL_BACK = "Causes of the problem:";
    protected Message message = null;

    public ExtendedException(Message messageIn) {
        super(null == messageIn ? "G0020E.EXTERNAL_ERROR_MESSAGE" : messageIn.getKey());
        this.message = new Message(messageIn);
    }

    public ExtendedException(Message messageIn, Throwable cause) {
        super(null == messageIn ? "G0020E.EXTERNAL_ERROR_MESSAGE" : messageIn.getKey(), cause);
        this.message = new Message(messageIn);
    }

    public ExtendedException(String messageStr) {
        this(new Message("G0020E.EXTERNAL_ERROR_MESSAGE", messageStr));
    }

    public ExtendedException(Throwable cause) {
        this(null == cause ? "" : cause.toString(), cause);
    }

    public ExtendedException(String messageStr, Throwable cause) {
        this(new Message("G0020E.EXTERNAL_ERROR_MESSAGE", messageStr), cause);
    }

    public Message getNonLocalizedMessage() {
        return new Message(this.message);
    }

    public void setNonLocalizedMessage(Message msg) {
        this.message.setMessage(msg);
    }

    public String getFormattedText() {
        return this.getFormattedText(Locale.getDefault(), false);
    }

    public String getFormattedText(Locale locale) {
        return this.getFormattedText(locale, false);
    }

    public String getFormattedText(Locale locale, boolean printStackTrace) {
        StringBuilder toAppend = new StringBuilder();
        ExtendedException.appendFormattedText(toAppend, this, locale, printStackTrace, true);
        return toAppend.toString();
    }

    public String getHTMLFormattedText(Locale locale, boolean printStackTrace) {
        StringBuilder toAppend = new StringBuilder();
        ExtendedException.appendFormattedText(toAppend, this, locale, printStackTrace, true, IndentationType.Html);
        return toAppend.toString();
    }

    public boolean isACause(Class<?> causeClass) {
        if (null == causeClass) {
            return false;
        }
        for (Throwable currentCause = this.getCause(); null != currentCause; currentCause = currentCause.getCause()) {
            if (!currentCause.getClass().equals(causeClass)) continue;
            return true;
        }
        return false;
    }

    public boolean isACause(String msgKey) {
        if (null == msgKey) {
            return false;
        }
        for (Throwable currentCause = this.getCause(); null != currentCause; currentCause = currentCause.getCause()) {
            ExtendedException ee;
            if (!(currentCause instanceof ExtendedException) || !(ee = (ExtendedException)currentCause).getNonLocalizedMessage().getKey().equals(msgKey)) continue;
            return true;
        }
        return false;
    }

    public ArrayList<Message> getChainedMessages() {
        ArrayList<Message> messages = new ArrayList<Message>();
        messages.add(this.message);
        Throwable thrown = this.getCause();
        while (null != thrown) {
            ExtendedException ee = null;
            if (!(thrown instanceof ExtendedException)) {
                ee = new ExtendedException(thrown.toString());
                ee.setStackTrace(thrown.getStackTrace());
                ee.initCause(thrown.getCause());
                thrown = ee;
            } else {
                ee = (ExtendedException)thrown;
            }
            messages.add(ee.message);
            thrown = ee.getCause();
        }
        return messages;
    }

    public static void appendFormattedText(StringBuffer toAppend, Throwable thrown, Locale locale, boolean printStackTrace) {
        StringBuilder toAppendBuffer = new StringBuilder();
        ExtendedException.appendFormattedText(toAppendBuffer, thrown, locale, printStackTrace);
        toAppend.append((CharSequence)toAppendBuffer);
    }

    public static void appendFormattedText(StringBuilder toAppend, Throwable thrown, Locale locale, boolean printStackTrace) {
        ExtendedException.appendFormattedText(toAppend, thrown, locale, printStackTrace, true);
    }

    public static void appendFormattedText(StringBuilder toAppend, Throwable thrown, Locale locale, boolean printStackTrace, boolean withDisplayKey) {
        ExtendedException.appendFormattedText(toAppend, thrown, locale, printStackTrace, withDisplayKey, IndentationType.Console);
    }

    private static void appendFormattedText(StringBuilder toAppend, Throwable thrown, Locale locale, boolean printStackTrace, boolean withDisplayKey, IndentationType indenType) {
        boolean printedCausedBy = false;
        while (null != thrown) {
            ExtendedException ee = null;
            if (!(thrown instanceof ExtendedException)) {
                ee = new ExtendedException(thrown.toString());
                ee.setStackTrace(thrown.getStackTrace());
                ee.initCause(thrown.getCause());
            } else {
                ee = (ExtendedException)thrown;
            }
            if (withDisplayKey) {
                toAppend.append(ee.message.getFormattedTextWithDisplayKey(locale));
            } else {
                toAppend.append(ee.message.getFormattedText(locale));
            }
            if (printStackTrace) {
                StackTraceElement[] stes = ee.getStackTrace();
                for (int i = 0; i < stes.length; ++i) {
                    toAppend.append(indenType.lineSeparator);
                    toAppend.append(indenType.indentUnit);
                    if (printedCausedBy) {
                        toAppend.append(indenType.indentUnit);
                    }
                    toAppend.append(stes[i]);
                }
            }
            if ((thrown = ee.getCause()) == null) continue;
            if (!printedCausedBy) {
                printedCausedBy = true;
                String causedByText = null;
                causedByText = CAUSES_OF_PROBLEM.getFormattedText(locale);
                if (null == causedByText) {
                    causedByText = CAUSES_OF_PROBLEM_FALL_BACK;
                }
                toAppend.append(indenType.lineSeparator);
                toAppend.append(causedByText);
            }
            toAppend.append(indenType.lineSeparator);
            toAppend.append(indenType.indentUnit);
        }
    }

    public LogRecord toLogRecord() {
        LogRecord logRecord = new LogRecord(Level.SEVERE, this.getMessage());
        logRecord.setThrown(this);
        return logRecord;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + ": " + this.message.getFormattedText();
    }

    public Message getMessageObject() {
        return this.message;
    }

    static /* synthetic */ String access$000() {
        return EndLine;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum IndentationType {
        Console(ExtendedException.access$000(), "   "),
        Html("<br>" + ExtendedException.access$000(), "&nbsp;&nbsp;&nbsp;");

        private final String indentUnit;
        private final String lineSeparator;

        private IndentationType(String lineSeparator, String indentUnit) {
            this.lineSeparator = lineSeparator;
            this.indentUnit = indentUnit;
        }

        public String lineSeparator() {
            return this.lineSeparator;
        }

        public String getIndentUnit() {
            return this.indentUnit;
        }
    }
}

