/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;

public class DateTimeFormatter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final Map<String, DateFormat> dateFormatterMap = Collections.synchronizedMap(new TreeMap());
    private static final Map<String, DateFormat> timeFormatterMap = Collections.synchronizedMap(new TreeMap());
    private static final String DEFAULT_TIME_FORMAT = "HH:mm:ss.SSS z";

    public static synchronized DateFormat getTimeFormatter(Locale locale) {
        String localeStr;
        DateFormat result = null;
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null == (result = timeFormatterMap.get(localeStr = locale.toString()))) {
            result = new SimpleDateFormat(DEFAULT_TIME_FORMAT, locale);
            timeFormatterMap.put(localeStr, result);
        }
        return result;
    }

    public static synchronized DateFormat getDateFormatter(Locale locale) {
        String localeStr;
        DateFormat result = null;
        if (null == locale) {
            locale = Locale.getDefault();
        }
        if (null == (result = dateFormatterMap.get(localeStr = locale.toString()))) {
            result = DateFormat.getDateInstance(1, locale);
            dateFormatterMap.put(localeStr, result);
        }
        return result;
    }
}

