/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import com.ibm.es.nuvo.util.StringUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class CacheFilter
implements Filter {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    protected FilterConfig fc;

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String cacheControl;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        String ignore = this.fc.getInitParameter("Ignore-Types");
        ArrayList<String> ignoreList = new ArrayList<String>();
        if (!StringUtils.empty(ignore)) {
            StringTokenizer st = new StringTokenizer(ignore, ",");
            while (st.hasMoreTokens()) {
                ignoreList.add(st.nextToken());
            }
        }
        String requestUrl = httpRequest.getRequestURI();
        int idx = requestUrl.lastIndexOf(46);
        String type = null;
        if (idx > 0) {
            type = requestUrl.substring(idx + 1);
        }
        if (!(StringUtils.empty(cacheControl = this.fc.getInitParameter("Cache-Control")) || !StringUtils.empty(type) && ignoreList.contains(type))) {
            httpResponse.addHeader("Cache-Control", cacheControl);
        }
        chain.doFilter(request, response);
    }

    public void init(FilterConfig filterConfig) {
        this.fc = filterConfig;
    }

    public void destroy() {
        this.fc = null;
    }
}

