/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.common;

import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ACL {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private List<String> acls = new ArrayList<String>();
    private String domain;
    private static final String ACLElement = "acl";
    private static final String DomainElement = "domain";
    private static final String ACLTokenElement = "token";

    public static void prepareParseTree(String parentPath, ParseTree tree) {
        if (!parentPath.endsWith("/")) {
            parentPath = parentPath + "/";
        }
        tree.addSetSubcomponent(parentPath + ACLElement, "createACL", new String[]{DomainElement}, new String[]{null});
        parentPath = parentPath + ACLElement + "/";
        tree.addCallMethod(parentPath + ACLTokenElement, "addToken");
        tree.addCallMethod(parentPath + DomainElement, "setDomain");
    }

    public void writeTo(XMLTagger tagger) {
        tagger.openStartElement(ACLElement);
        tagger.writeAttr(DomainElement, this.domain);
        tagger.closeTag();
        for (String acl : this.acls) {
            tagger.startElement(ACLTokenElement);
            tagger.writeText(acl);
            tagger.endElement(ACLTokenElement);
        }
        tagger.endElement(ACLElement);
    }

    public boolean equals(Object o) {
        boolean ret = false;
        if (o instanceof ACL) {
            ACL other = (ACL)o;
            ret = ((Object)this.acls).equals(other.acls);
            if (ret) {
                ret = this.domain != null ? this.domain.equals(other.domain) : other.domain == null;
            }
        }
        return ret;
    }

    public int hashCode() {
        return ((Object)this.acls).hashCode();
    }

    ACL() {
    }

    public void addToken(String token) {
        this.acls.add(token);
    }

    public ACL(String domain) {
        this();
        this.domain = domain;
    }

    public void addACLToken(String principal, int level, boolean partial) {
        this.acls.add(ACL.generateACLToken(principal, level, partial));
    }

    public List<String> getACLTokens() {
        return this.acls;
    }

    public String getDomain() {
        return this.domain;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(64);
        sb.append("Domain : ").append(this.domain).append(", Tokens : ").append(this.acls);
        return sb.toString();
    }

    public static String generateACLToken(String principal, int level, boolean partial) {
        StringBuilder builder = new StringBuilder(32).append(principal).append('|').append(level).append('|').append(partial ? 1 : 0);
        return builder.toString();
    }
}

