/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.client.test;

import com.ibm.es.nuvo.client.api.AdminFactory;
import com.ibm.es.nuvo.client.api.AdminService;
import com.ibm.es.nuvo.client.api.CollectionExistsException;
import com.ibm.es.nuvo.client.api.CollectionNotExistsException;
import com.ibm.es.nuvo.client.api.ConnectionException;
import com.ibm.es.nuvo.client.api.IndexFactory;
import com.ibm.es.nuvo.client.api.IndexService;
import com.ibm.es.nuvo.client.api.InvalidQuerySyntaxException;
import com.ibm.es.nuvo.client.api.InvalidSearchPropertyException;
import com.ibm.es.nuvo.client.api.PropertyNames;
import com.ibm.es.nuvo.client.api.SearchFactory;
import com.ibm.es.nuvo.client.api.SearchService;
import com.ibm.es.nuvo.client.api.ServiceException;
import com.ibm.es.nuvo.client.api.SystemManager;
import com.ibm.es.nuvo.client.api.UnauthorizedException;
import com.ibm.es.nuvo.client.api.UpsertFileNameException;
import com.ibm.es.nuvo.client.util.CollectionProperties;
import com.ibm.es.nuvo.client.util.Credentials;
import com.ibm.es.nuvo.client.util.Document;
import com.ibm.es.nuvo.client.util.QueryProperties;
import com.ibm.es.nuvo.client.util.Result;
import com.ibm.es.nuvo.client.util.ResultSet;
import java.util.ArrayList;
import java.util.Locale;

public class Driver
implements PropertyNames {
    private static final String collectionName = "driverTest";

    public static void main(String[] args) {
        Credentials creds = new Credentials("12345");
        try {
            SystemManager systemManager = SystemManager.getInstance();
            AdminFactory adminFactory = systemManager.getAdminFactory();
            AdminService adminService = adminFactory.getService("localhost", 8888, creds);
            Driver.doAdminTasks(adminService);
            IndexFactory indexFactory = systemManager.getIndexFactory();
            IndexService indexService = indexFactory.getService("localhost", 8888, creds);
            Driver.doIndexTasks(indexService);
            SearchFactory searchFactory = systemManager.getSearchFactory();
            SearchService searchService = searchFactory.getService("localhost", 8888, creds);
            Driver.doSearchTasks(searchService);
        }
        catch (UnauthorizedException ue) {
        }
        catch (ConnectionException connectionException) {
            // empty catch block
        }
    }

    private static void doAdminTasks(AdminService service) {
        try {
            CollectionProperties properties = new CollectionProperties();
            properties.setDescription("description value");
            properties.setLocation("/home/collections/1");
            service.createCollection(collectionName, properties);
        }
        catch (CollectionExistsException ce) {
        }
        catch (ServiceException se) {
            System.err.println(se.getKey() + " " + se.getMessage());
        }
        try {
            service.deleteCollection(collectionName);
        }
        catch (CollectionNotExistsException ce) {
        }
        catch (ServiceException se) {
            System.err.println(se.getKey() + " " + se.getMessage());
        }
    }

    private static void doIndexTasks(IndexService service) {
        ArrayList<Document> documentList = new ArrayList<Document>();
        documentList.add(service.createDocument("docId1", "docLocation1"));
        documentList.add(service.createDocument("docId2", "docLocation2"));
        try {
            service.upsertDocs(collectionName, documentList);
        }
        catch (ServiceException se) {
            // empty catch block
        }
        try {
            service.upsertDocs(collectionName, "\\documents\\pushFileList");
        }
        catch (UpsertFileNameException ue) {
        }
        catch (ServiceException se) {
            // empty catch block
        }
        try {
            service.removeDocs(collectionName, documentList);
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    private static void doSearchTasks(SearchService service) {
        int start = 0;
        int numResults = 1000;
        QueryProperties props = new QueryProperties();
        props.setStart(start);
        props.setResults(numResults);
        props.setLocale(new Locale("en"));
        props.setProperty("queryLanguage", "es");
        String keywords = "silicon valley";
        try {
            ResultSet rs = service.search(collectionName, keywords, props);
            Result[] results = rs.getResults();
            while (results != null) {
                for (int i = 0; i < results.length; ++i) {
                    System.out.println(results[i].getDocumentId());
                    System.out.println(results[i].getScore());
                    System.out.println(results[i].getTitle());
                }
                props.setStart(start += numResults);
                rs = service.search(collectionName, keywords, props);
                results = rs.getResults();
            }
        }
        catch (InvalidQuerySyntaxException iq) {
        }
        catch (InvalidSearchPropertyException ip) {
        }
        catch (ServiceException se) {
            System.err.println(se.getKey() + " " + se.getMessage());
        }
    }
}

