/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.cache;

import com.ibm.es.nuvo.cache.CacheEvictionHandler;
import com.ibm.es.nuvo.cache.CacheException;
import com.ibm.es.nuvo.cache.CacheLoader;
import com.ibm.es.nuvo.cache.ObjectExistsException;
import com.ibm.es.nuvo.common.Message;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Properties;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectCache<K, V> {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private Properties cacheProps;
    private static final int defaultCacheSize = 100;
    private LinkedList<CachedObject<K, V>> cache;
    private Hashtable<K, CachedObject<K, V>> cacheIndex;
    private int cacheSize;
    private String cacheName;
    private CacheLoader<K, V> cacheLoader;
    private CacheEvictionHandler<V> evictionHandler;

    public ObjectCache(Properties cacheProperties) {
        this.cacheProps = cacheProperties;
        this.init();
    }

    public ObjectCache() throws IOException {
        URL properties = ObjectCache.class.getResource("cache.properties");
        this.cacheProps = new Properties();
        this.cacheProps.load(properties.openStream());
        this.init();
    }

    public synchronized void put(K name, V obj) throws CacheException {
        if (this.cacheIndex.containsKey(name)) {
            Message msg = new Message("G0028E.CACHED_OBJECT_ALREADY_EXISTS");
            msg.addArgument(name);
            msg.addArgument(this.cacheName);
            throw new ObjectExistsException(msg);
        }
        CachedObject<K, V> cachedObj = new CachedObject<K, V>(name, obj);
        if (this.cache.size() == this.cacheSize) {
            int evictionIndex = this.findEvictionCandidate();
            CachedObject<K, V> oldCachedObj = this.cache.get(evictionIndex);
            this.destroy(oldCachedObj.getName());
            if (this.evictionHandler != null) {
                this.evictionHandler.handle(oldCachedObj.getObject());
            }
        }
        this.cache.addLast(cachedObj);
        this.cacheIndex.put(name, cachedObj);
    }

    public synchronized void destroy(K name) throws CacheException {
        if (this.cacheIndex.containsKey(name)) {
            this.cache.remove(this.cacheIndex.get(name));
            this.cacheIndex.remove(name);
        }
    }

    public synchronized V get(K name) throws CacheException {
        V obj = null;
        if (name == null) {
            Message msg = new Message("G0029E.CACHED_OBJECT_BAD_NAME");
            msg.addArgument(this.cacheName);
            msg.addArgument("null");
            throw new CacheException(msg);
        }
        if (this.cacheIndex.containsKey(name)) {
            CachedObject<K, V> cachedObj = this.cacheIndex.get(name);
            cachedObj.setFlag(1);
            obj = cachedObj.getObject();
        } else {
            if (this.cacheLoader == null) {
                Message msg = new Message("G0030E.NO_CACHE_LOADER_PROVIDED");
                msg.addArgument(this.cacheName);
                throw new CacheException(msg);
            }
            try {
                obj = this.cacheLoader.load(name);
            }
            catch (Exception e) {
                Message msg = new Message("G0031E.CACHE_OBJECT_LOAD_FAILURE");
                msg.addArgument(name);
                msg.addArgument(this.cacheName);
                throw new CacheException(msg, (Throwable)e);
            }
            if (obj == null) {
                Message msg = new Message("G0031E.CACHE_OBJECT_LOAD_FAILURE");
                msg.addArgument(name);
                msg.addArgument(this.cacheName);
                throw new CacheException(msg);
            }
            this.put(name, obj);
        }
        return obj;
    }

    public synchronized boolean replace(K name, V obj, boolean insertIfNotExists) throws CacheException {
        boolean objectReplaced = false;
        if (name == null) {
            Message msg = new Message("G0029E.CACHED_OBJECT_BAD_NAME");
            msg.addArgument(this.cacheName);
            msg.addArgument("null");
            throw new CacheException(msg);
        }
        if (this.cacheIndex.containsKey(name)) {
            CachedObject<K, V> cachedObj = this.cacheIndex.get(name);
            cachedObj.setObject(obj);
            objectReplaced = true;
        } else if (insertIfNotExists) {
            this.put(name, obj);
            objectReplaced = true;
        }
        return objectReplaced;
    }

    public synchronized Vector<K> getAllNames() {
        Vector<K> keyList = new Vector<K>();
        Enumeration<K> keys = this.cacheIndex.keys();
        while (keys.hasMoreElements()) {
            keyList.add(keys.nextElement());
        }
        return keyList;
    }

    public synchronized boolean contains(K name) {
        return this.cacheIndex.containsKey(name);
    }

    public synchronized void setCacheLoader(CacheLoader<K, V> loader) {
        this.cacheLoader = loader;
    }

    public synchronized void setEvictionHandler(CacheEvictionHandler<V> handler) {
        this.evictionHandler = handler;
    }

    private void init() {
        try {
            this.cacheSize = Integer.parseInt(this.cacheProps.getProperty("cache.size", Integer.toString(100)));
        }
        catch (NumberFormatException e) {
            this.cacheSize = 100;
        }
        this.cacheName = this.cacheProps.getProperty("cache.name", "<Unknown>");
        this.cache = new LinkedList();
        this.cacheIndex = new Hashtable(this.cacheSize);
    }

    private int findEvictionCandidate() {
        int index = 0;
        CachedObject<K, V> obj = this.cache.get(0);
        while (obj.getFlag() == 1) {
            this.cache.remove(index);
            obj.setFlag(0);
            this.cache.addLast(obj);
            index = (index + 1) % this.cacheSize;
            obj = this.cache.get(index);
        }
        return index;
    }

    public static void main(String[] args) {
        Properties prop = new Properties();
        prop.setProperty("cache.size", "10");
        ObjectCache<String, String> oc = new ObjectCache<String, String>(prop);
        oc.setCacheLoader(new CacheLoader<String, String>(){

            @Override
            public String load(String name) {
                System.out.println("didn't find " + name + ", loading it...");
                return name;
            }
        });
        oc.setEvictionHandler(new CacheEvictionHandler<String>(){

            @Override
            public void handle(String name) {
                System.out.println("evicting " + name);
            }
        });
        try {
            oc.get("foo1");
            oc.get("foo2");
            oc.get("foo3");
            oc.get("foo4");
            oc.get("foo5");
            oc.get("foo6");
            oc.get("foo7");
            oc.get("foo8");
            oc.get("foo9");
            oc.get("foo10");
            oc.get("foo11");
            oc.get("foo12");
            oc.get("foo12");
            oc.get("foo12");
            oc.get("foo9");
            oc.get("foo8");
            oc.get("foo3");
            oc.get("foo4");
            oc.destroy("foo8");
            oc.get("foo1");
            oc.get("foo8");
            oc.destroy("foo33");
        }
        catch (CacheException e) {
            System.out.println("got exception" + e);
            e.printStackTrace();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CachedObject<K, V> {
        private K name;
        private V obj;
        private int flag;

        public CachedObject(K name, V obj) {
            this.name = name;
            this.obj = obj;
            this.flag = 0;
        }

        public K getName() {
            return this.name;
        }

        public V getObject() {
            return this.obj;
        }

        public int getFlag() {
            return this.flag;
        }

        public void setFlag(int flag) {
            this.flag = flag;
        }

        public void setObject(V obj) {
            this.obj = obj;
        }
    }
}

