/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup.jdbc;

import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ResultSetInputStreamIterator
implements Iterator<InputStream> {
    private final ResultSet resultSet;
    private final int columnIndex;
    private boolean hasMore;
    private boolean nextNeeded;

    public ResultSetInputStreamIterator(ResultSet resultSet, int columnIndex) throws SQLException {
        this.resultSet = resultSet;
        this.columnIndex = columnIndex;
        this.hasMore = this.resultSet.next();
    }

    @Override
    public boolean hasNext() {
        if (this.nextNeeded) {
            try {
                this.hasMore = this.resultSet.next();
            }
            catch (SQLException e) {
                RuntimeException r = new RuntimeException("SQL exception");
                r.initCause(e);
                throw r;
            }
            this.nextNeeded = false;
        }
        return this.hasMore;
    }

    @Override
    public InputStream next() {
        if (!this.hasMore) {
            throw new NoSuchElementException();
        }
        try {
            InputStream inputStream = this.resultSet.getBinaryStream(this.columnIndex);
            this.nextNeeded = true;
            return inputStream;
        }
        catch (SQLException sqle) {
            RuntimeException re = new RuntimeException();
            re.initCause(sqle);
            throw re;
        }
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

