/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup.jdbc;

import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class JDBCUtil {
    private String hostName;
    private String port;
    private String databaseName;
    private String tableName;
    private String userName;
    private String password;
    private long configuredSegmentBytes = 0x80000000L;
    private boolean testing;
    private static String jdbcCustomizationPropertyName = "BRJDBCDS";
    private String externalJDBCDriverName;
    private String externalJDBCScheme;
    private Connection databaseConnection;
    private Object connectionLock = new Object();
    private static final String db2DriverName = "com.ibm.db2.jcc.DB2Driver";
    private static final String db2Scheme = "jdbc:db2:";
    private static final String derbyDriverName = "org.apache.derby.jdbc.EmbeddedDriver";
    private static final String derbyScheme = "jdbc:derby:";
    private static final String derbyCreateFlag = ";create=true";
    public static final String derbyDirectory = "../BackupTestDB";
    private static final long BLOB_BYTES = 0x80000000L;
    private static final String[] derbyCreateDDL = new String[]{"CREATE TABLE backuptable(mtime BIGINT, blobid INTEGER, segid VARCHAR(512), checksum BIGINT, content BLOB(2G))", "CREATE INDEX segididx ON backuptable (segid)"};

    public JDBCUtil(BackupConfiguration configuration) throws ExtendedException {
        this.testing = configuration.getProperty("testing") != null;
        this.checkForJDBCCustomization();
        this.tableName = BackupUtil.checkNonempty(configuration, "tabName");
        if (!this.testing) {
            this.hostName = BackupUtil.checkNonempty(configuration, "dbHost");
            this.port = BackupUtil.checkNonempty(configuration, "dbPort");
            this.databaseName = BackupUtil.checkNonempty(configuration, "dbName");
            this.userName = BackupUtil.checkNonempty(configuration, "tabUID");
            String encryptedpw = BackupUtil.checkNonempty(configuration, "tabPassword");
            this.password = Encryption.decrypt(encryptedpw);
        }
        String[] tr = new String[1];
        if (!StringUtils.noData(configuration.getProperty("segBytes"), tr)) {
            try {
                this.configuredSegmentBytes = Long.parseLong(tr[0]);
            }
            catch (NumberFormatException nfe) {
                this.configuredSegmentBytes = 0x80000000L;
            }
        }
    }

    private void checkForJDBCCustomization() {
        String[] tr;
        String rawPropertyValue = System.getProperty(jdbcCustomizationPropertyName);
        if (StringUtils.noData(rawPropertyValue, tr = new String[1])) {
            return;
        }
        int semiIx = tr[0].indexOf(59);
        if (semiIx >= 0) {
            this.externalJDBCDriverName = tr[0].substring(0, semiIx);
            this.externalJDBCScheme = tr[0].substring(semiIx + 1);
        } else {
            this.externalJDBCDriverName = tr[0];
        }
    }

    public long getConfiguredSegmentBytes() {
        return this.configuredSegmentBytes;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getUserName() {
        return this.userName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void ensureConnection() throws ClassNotFoundException, IOException, SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.databaseConnection == null) {
                Connection connection = null;
                boolean error = true;
                try {
                    connection = this.testing ? this.openEmbeddedDerbyConnection() : this.openJDBCConnection();
                    error = false;
                }
                finally {
                    if (error) {
                        BackupUtil.assuredClose(connection);
                    } else {
                        this.databaseConnection = connection;
                    }
                }
            }
        }
    }

    private Connection openJDBCConnection() throws ClassNotFoundException, SQLException {
        if (this.externalJDBCDriverName == null) {
            Class.forName(db2DriverName);
        } else {
            Class.forName(this.externalJDBCDriverName);
        }
        StringBuilder connectionURL = new StringBuilder();
        String scheme = this.externalJDBCScheme;
        if (scheme == null) {
            scheme = db2Scheme;
        }
        connectionURL.append(scheme).append("//").append(this.hostName).append(":").append(this.port).append("/").append(this.databaseName);
        Connection connection = DriverManager.getConnection(connectionURL.toString(), this.userName, this.password);
        return connection;
    }

    private Connection openEmbeddedDerbyConnection() throws ClassNotFoundException, IOException, SQLException {
        try {
            Class.forName(derbyDriverName);
            File tmpDirectory = new File(System.getProperty("java.io.tmpdir"));
            File dbDirectory = new File(tmpDirectory, derbyDirectory);
            boolean preexisting = dbDirectory.exists();
            StringBuilder connectionURL = new StringBuilder(128);
            connectionURL.append(derbyScheme).append(dbDirectory.getCanonicalPath());
            if (!preexisting) {
                connectionURL.append(derbyCreateFlag);
            }
            Connection connection = DriverManager.getConnection(connectionURL.toString());
            if (!preexisting) {
                Statement s = connection.createStatement();
                for (int j = 0; j < derbyCreateDDL.length; ++j) {
                    s.execute(derbyCreateDDL[j]);
                }
                connection.commit();
            }
            return connection;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        catch (SQLException e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.databaseConnection != null) {
                this.closeConnectionPrivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (!this.databaseConnection.getAutoCommit()) {
                this.databaseConnection.commit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Statement createStatement() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.databaseConnection.createStatement();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PreparedStatement prepareStatement(String sqlString) throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            return this.databaseConnection.prepareStatement(sqlString);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollback() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            this.rollbackPrivate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rollbackAndClose() throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.databaseConnection != null) {
                try {
                    this.rollbackPrivate();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                this.closeConnectionPrivate();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAutoCommit(boolean yesno) throws SQLException {
        Object object = this.connectionLock;
        synchronized (object) {
            if (this.databaseConnection.getAutoCommit() != yesno) {
                this.databaseConnection.setAutoCommit(yesno);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeConnectionPrivate() throws SQLException {
        try {
            this.databaseConnection.close();
        }
        finally {
            this.databaseConnection = null;
        }
    }

    private void createDB2V9BackupTable(Connection connection) throws SQLException {
        String tableNameUC = this.tableName.toUpperCase();
        ResultSet resultSet = null;
        Statement statement = null;
        try {
            statement = connection.createStatement();
            StringBuilder sb = new StringBuilder();
            sb.append("SELECT NAME FROM SYSIBM.SYSTABLES WHERE NAME = '").append(tableNameUC).append("'");
            resultSet = statement.executeQuery(sb.toString());
            boolean found = resultSet.next();
            if (!found) {
                sb.delete(0, sb.length());
                sb.append("CREATE TABLE ").append(this.tableName).append("(mtime BIGINT, blobid INTEGER, segid VARCHAR(512),").append(" checksum BIGINT, content BLOB(2G))");
                statement.execute(sb.toString());
                sb.delete(0, sb.length());
                sb.append("CREATE INDEX segididx ON ").append(this.tableName).append("(segid)");
                statement.execute(sb.toString());
            }
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException sqle) {
            try {
                if (!connection.getAutoCommit()) {
                    try {
                        connection.rollback();
                    }
                    catch (SQLException sqle2) {
                        // empty catch block
                    }
                }
                throw sqle;
            }
            catch (Throwable throwable) {
                BackupUtil.assuredClose(resultSet);
                BackupUtil.assuredClose(statement);
                throw throwable;
            }
        }
        BackupUtil.assuredClose(resultSet);
        BackupUtil.assuredClose(statement);
    }

    private void rollbackPrivate() throws SQLException {
        if (!this.databaseConnection.getAutoCommit()) {
            this.databaseConnection.rollback();
        }
    }
}

