/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup.jdbc;

import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.backup.BackupMetadataSource;
import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.backup.jdbc.JDBCUtil;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.CollectionFile;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class JDBCBackupMetadata
implements BackupMetadataSource {
    private String backupTableName;
    private String collectionID;
    private String readSQL;
    private JDBCUtil jdbcUtil;
    private HashMap<String, CollectionFile> metadataTable;

    public JDBCBackupMetadata(BackupConfiguration configuration, JDBCUtil jdbcUtil) {
        this.collectionID = configuration.getProperty("collection");
        this.backupTableName = configuration.getProperty("tabName");
        this.jdbcUtil = jdbcUtil;
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT mtime, blobid, segid, checksum FROM ").append(this.backupTableName).append(" WHERE (blobid < 2)");
        this.readSQL = sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws SQLException, ExtendedException {
        HashMap<String, CollectionFile> table = new HashMap<String, CollectionFile>();
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.jdbcUtil.createStatement();
            resultSet = statement.executeQuery(this.readSQL);
            while (resultSet.next()) {
                long modificationTime = resultSet.getLong(1);
                String path = resultSet.getString(3);
                long checksum = resultSet.getLong(4);
                CollectionFile collectionFile = new CollectionFile(this.collectionID, path);
                collectionFile.setBackingStoreLastModified(modificationTime);
                collectionFile.setChecksum(checksum);
                table.put(path, collectionFile);
            }
        }
        catch (Throwable throwable) {
            BackupUtil.assuredClose(resultSet);
            BackupUtil.assuredClose(statement);
            throw throwable;
        }
        BackupUtil.assuredClose(resultSet);
        BackupUtil.assuredClose(statement);
        this.metadataTable = table;
    }

    @Override
    public HashMap<String, CollectionFile> getBackupMetadata() {
        return this.metadataTable;
    }
}

