/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup.jdbc;

import com.ibm.es.nuvo.backup.BackupAgent;
import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.backup.BackupManager;
import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.backup.DeflatingSegmentingInputStreamIterator;
import com.ibm.es.nuvo.backup.InputStreamConcatenator;
import com.ibm.es.nuvo.backup.TaskStatus;
import com.ibm.es.nuvo.backup.jdbc.JDBCBackupMetadata;
import com.ibm.es.nuvo.backup.jdbc.JDBCUtil;
import com.ibm.es.nuvo.backup.jdbc.ResultSetInputStreamIterator;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionFile;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.zip.InflaterInputStream;

class JDBCBackupAgent
extends BackupAgent {
    private JDBCUtil jdbcUtil;
    private PreparedStatement sqlDeleteFromBackup;
    private PreparedStatement sqlGetBackupGeneration;
    private PreparedStatement sqlGetFileContent;
    private PreparedStatement sqlInsertIntoBackup;

    protected JDBCBackupAgent(BackupManager.TransferDirection transferDirection) {
        super(transferDirection);
    }

    protected void configureDerivedBackupAgent(BackupConfiguration backupConfiguration) throws Throwable {
        try {
            this.jdbcUtil.ensureConnection();
            this.jdbcUtil.setAutoCommit(this.transferDirection == BackupManager.TransferDirection.Restore);
            if (!this.transferListBuilder.wasBackupVolumeFound()) {
                JDBCBackupMetadata jdbcMetadata = new JDBCBackupMetadata(backupConfiguration, this.jdbcUtil);
                jdbcMetadata.load();
                this.transferListBuilder.buildChangeLists(jdbcMetadata);
                this.taskStatus.setNumberOfSubtasksToBeDone(this.transferListBuilder.getNumberOfFilesAffected());
            }
            if (this.transferDirection == BackupManager.TransferDirection.Restore && !this.transferListBuilder.wasBackupVolumeFound()) {
                throw new ExtendedException(new Message("X0045W.BNR", this.collectionID));
            }
            this.configureSQLStatements();
        }
        catch (ClassNotFoundException e) {
            throw new ExtendedException(new Message("G0020E.EXTERNAL_ERROR_MESSAGE"), (Throwable)e);
        }
        catch (IOException e) {
            throw new ExtendedException(new Message("G0020E.EXTERNAL_ERROR_MESSAGE"), (Throwable)e);
        }
        catch (SQLException e) {
            throw new ExtendedException(new Message("G0020E.EXTERNAL_ERROR_MESSAGE"), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatus getBackupStatus() {
        TaskStatus taskStatus = this.taskStatus;
        synchronized (taskStatus) {
            return this.taskStatus.clone();
        }
    }

    protected void stopDerivedBackupAgent() {
        try {
            this.jdbcUtil.rollbackAndClose();
        }
        catch (SQLException sqle) {
            this.recordThrowable(sqle);
        }
    }

    protected void setJDBCUtil(JDBCUtil jdbcUtil) {
        this.jdbcUtil = jdbcUtil;
    }

    protected BackupAgent.BackupThread createBackupThread() {
        return new JDBCBackupThread();
    }

    private void configureSQLStatements() throws SQLException {
        String tableName = this.jdbcUtil.getTableName();
        StringBuilder sb = new StringBuilder();
        sb.append("DELETE FROM ").append(tableName).append(" WHERE segid=?");
        this.sqlDeleteFromBackup = this.jdbcUtil.prepareStatement(sb.toString());
        sb.delete(0, sb.length());
        sb.append("INSERT INTO ").append(tableName).append(" (mtime, blobid, segid, content) VALUES (?, ?, ?, ?)");
        this.sqlInsertIntoBackup = this.jdbcUtil.prepareStatement(sb.toString());
        sb.delete(0, sb.length());
        sb.append("SELECT content FROM ").append(tableName).append(" WHERE segid = '").append("backupgen.dat").append("'");
        this.sqlGetBackupGeneration = this.jdbcUtil.prepareStatement(sb.toString());
        sb.delete(0, sb.length());
        sb.append("SELECT content, blobid FROM ").append(tableName).append(" WHERE segid = ?").append(" ORDER BY blobid");
        this.sqlGetFileContent = this.jdbcUtil.prepareStatement(sb.toString());
    }

    protected boolean canSkipTransfer() throws Throwable {
        if (this.transferListBuilder.isTransferForced()) {
            return false;
        }
        long savedBackupGeneration = this.getSavedBackupGeneration();
        if (savedBackupGeneration < 0L) {
            return false;
        }
        long currentGeneration = this.transferListBuilder.getBackupGeneration();
        if (this.transferDirection == BackupManager.TransferDirection.Backup) {
            return savedBackupGeneration >= currentGeneration;
        }
        return currentGeneration >= savedBackupGeneration;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getSavedBackupGeneration() throws SQLException, IOException {
        ResultSet resultSet = null;
        DataInputStream dataInputStream = null;
        InflaterInputStream inflaterInputStream = null;
        long savedBackupGeneration = -1L;
        try {
            resultSet = this.sqlGetBackupGeneration.executeQuery();
            if (resultSet.next()) {
                Blob blob = resultSet.getBlob(1);
                inflaterInputStream = new InflaterInputStream(blob.getBinaryStream());
                dataInputStream = new DataInputStream(inflaterInputStream);
                savedBackupGeneration = dataInputStream.readLong();
            }
        }
        finally {
            BackupUtil.assuredClose(resultSet);
            BackupUtil.assuredClose(this.sqlGetBackupGeneration);
            BackupUtil.assuredClose(dataInputStream);
            BackupUtil.assuredClose(inflaterInputStream);
        }
        return savedBackupGeneration;
    }

    static /* synthetic */ TaskStatus access$300(JDBCBackupAgent x0) {
        return x0.taskStatus;
    }

    static /* synthetic */ TaskStatus access$400(JDBCBackupAgent x0) {
        return x0.taskStatus;
    }

    static /* synthetic */ PreparedStatement access$500(JDBCBackupAgent x0) {
        return x0.sqlInsertIntoBackup;
    }

    static /* synthetic */ String access$600(JDBCBackupAgent x0) {
        return x0.collectionID;
    }

    static /* synthetic */ TaskStatus access$700(JDBCBackupAgent x0) {
        return x0.taskStatus;
    }

    private class JDBCBackupThread
    extends BackupAgent.BackupThread {
        private JDBCBackupAgent This;

        public JDBCBackupThread() {
            this.This = JDBCBackupAgent.this;
        }

        protected void deleteFile(CollectionFile fileToDelete) throws Throwable {
            if (this.This.transferDirection == BackupManager.TransferDirection.Backup) {
                this.deleteFileFromBackup(fileToDelete);
            } else {
                this.deleteFileFromCollection(fileToDelete);
            }
        }

        protected void insertFile(CollectionFile fileToInsert) throws Throwable {
            if (this.This.transferDirection == BackupManager.TransferDirection.Backup) {
                this.insertFileIntoBackup(fileToInsert);
            } else {
                this.insertFileIntoCollection(fileToInsert);
            }
        }

        protected void notificationOfTransferOutcome(BackupManager.TransferOutcome outcome) throws Throwable {
            if (outcome == BackupManager.TransferOutcome.Successful) {
                this.This.jdbcUtil.commit();
            } else {
                this.This.jdbcUtil.rollback();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void insertFileIntoBackup(CollectionFile collectionFile) throws Throwable {
            block5: {
                cfis = null;
                dsisi = null;
                try {
                    cfis = collectionFile.openInputStream();
                    dsisi = new DeflatingSegmentingInputStreamIterator(cfis, JDBCBackupAgent.access$200(this.This).getConfiguredSegmentBytes(), 9, DeflatingSegmentingInputStreamIterator.CompressionMechanism.TmpFile);
                    JDBCBackupAgent.access$300(this.This).registerInterruptible(dsisi);
lbl7:
                    // 2 sources

                    while (dsisi.hasNext()) {
                        if (JDBCBackupAgent.access$400(this.This).isInterruptRequested()) {
                            break block5;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl32
                }
                catch (Throwable var6_6) {
                    BackupUtil.assuredClose(cfis);
                    JDBCBackupAgent.access$700(this.This).unregisterInterruptible(dsisi);
                    if (dsisi == null) throw var6_6;
                    dsisi.close();
                    throw var6_6;
                }
            }
            BackupUtil.assuredClose(cfis);
            JDBCBackupAgent.access$700(this.This).unregisterInterruptible(dsisi);
            if (dsisi == null) return;
            dsisi.close();
            return;
lbl-1000:
            // 1 sources

            {
                is = dsisi.next();
                JDBCBackupAgent.access$500(this.This).setLong(1, collectionFile.getLastModified());
                JDBCBackupAgent.access$500(this.This).setInt(2, dsisi.getSegmentNumber());
                JDBCBackupAgent.access$500(this.This).setString(3, collectionFile.getPathInCollection());
                JDBCBackupAgent.access$500(this.This).setBinaryStream(4, is, is.available());
                rowCount = JDBCBackupAgent.access$500(this.This).executeUpdate();
                if (rowCount > 0) ** GOTO lbl7
                throw new ExtendedException(new Message("X0046E.BNR", new Object[]{JDBCBackupAgent.access$600(this.This), collectionFile.getPathInCollection(), dsisi.getSegmentNumber()}));
lbl32:
                // 1 sources

                collectionFile.setBackingStoreLastModified(collectionFile.getLastModified());
                collectionFile.setChecksum(dsisi.getChecksum());
            }
            BackupUtil.assuredClose(cfis);
            JDBCBackupAgent.access$700(this.This).unregisterInterruptible(dsisi);
            if (dsisi == null) return;
            dsisi.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected void insertFileIntoCollection(CollectionFile fileToInsert) throws Throwable {
            byte[] buffer;
            OutputStream cfos = null;
            ResultSetInputStreamIterator rsisi = null;
            InflaterInputStream iis = null;
            InputStreamConcatenator isc = null;
            ResultSet resultSet = null;
            try {
                this.This.sqlGetFileContent.setString(1, fileToInsert.getPathInCollection());
                resultSet = this.This.sqlGetFileContent.executeQuery();
                rsisi = new ResultSetInputStreamIterator(resultSet, 1);
                isc = new InputStreamConcatenator(rsisi);
                iis = new InflaterInputStream(isc);
                cfos = fileToInsert.openOutputStream();
                buffer = new byte[4096];
                while (iis.available() > 0) {
                    if (!this.This.taskStatus.isInterruptRequested()) break block4;
                }
            }
            catch (Throwable throwable) {
                BackupUtil.assuredClose(cfos);
                BackupUtil.assuredClose(iis);
                BackupUtil.assuredClose(isc);
                BackupUtil.assuredClose(resultSet);
                throw throwable;
            }
            {
                block4: {
                    BackupUtil.assuredClose(cfos);
                    BackupUtil.assuredClose(iis);
                    BackupUtil.assuredClose(isc);
                    BackupUtil.assuredClose(resultSet);
                    return;
                }
                int bytesRead = iis.read(buffer, 0, 4096);
                if (bytesRead < 0) break;
                cfos.write(buffer, 0, bytesRead);
                continue;
            }
            BackupUtil.assuredClose(cfos);
            BackupUtil.assuredClose(iis);
            BackupUtil.assuredClose(isc);
            BackupUtil.assuredClose(resultSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void deleteFileFromBackup(CollectionFile collectionFile) throws Throwable {
            this.This.sqlDeleteFromBackup.setString(1, collectionFile.getPathInCollection());
            int rowCount = this.This.sqlDeleteFromBackup.executeUpdate();
            if (rowCount <= 0) {
                throw new ExtendedException(new Message("X0048E.BNR", this.This.collectionID, collectionFile.getPathInCollection()));
            }
        }
    }
}

