/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.Interruptible;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import java.lang.ref.WeakReference;
import java.util.LinkedList;

public class TaskStatus
implements Cloneable,
Interruptible {
    private ExecutionState executionState;
    private boolean interruptRequested;
    private LinkedList<WeakReference<Interruptible>> interruptibles;
    private Object interruptiblesLock = new Object();
    private Throwable throwable;
    private int numberOfSubtasks;
    private int numberOfSubtasksDone;
    private boolean threadDone;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public TaskStatus() {
        this(ExecutionState.Uninitialized);
    }

    public TaskStatus(ExecutionState executionState) {
        this.executionState = executionState;
    }

    public synchronized void requestExecutionState(ExecutionState newState) throws ExtendedException {
        if (newState.ordinal() - this.executionState.ordinal() != 1) {
            throw new ExtendedException(new Message("X0042W.BNR", newState.toString(), this.executionState.toString()));
        }
        this.setExecutionStateInternal(newState);
    }

    public TaskStatus clone() {
        TaskStatus taskStatus = null;
        try {
            taskStatus = (TaskStatus)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return taskStatus;
    }

    public synchronized ExecutionState getExecutionState() {
        return this.executionState;
    }

    public int getPercentComplete() {
        if (this.numberOfSubtasks <= 0) {
            return 0;
        }
        float t = this.numberOfSubtasks;
        float d = this.numberOfSubtasksDone;
        return (int)((double)(1.0f - (t - d) / t) * 100.0);
    }

    public Throwable getThrowable() {
        return this.throwable;
    }

    public void incrementSubtasksDoneSoFar(int increment) {
        this.numberOfSubtasksDone += increment;
    }

    public boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    public synchronized boolean isThreadDone() {
        return this.threadDone;
    }

    public synchronized Throwable recordFirstThrowable(Throwable newThrowable) {
        return this.throwable == null ? this.setThrowablePrivate(newThrowable) : this.throwable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerInterruptible(Interruptible interruptible) {
        if (interruptible == null) {
            return;
        }
        Object object = this.interruptiblesLock;
        synchronized (object) {
            if (this.interruptibles == null) {
                this.interruptibles = new LinkedList();
            }
            this.interruptibles.add(new WeakReference<Interruptible>(interruptible));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterInterruptible(Interruptible interruptible) {
        if (interruptible == null) {
            return;
        }
        Object object = this.interruptiblesLock;
        synchronized (object) {
            if (this.interruptibles == null) {
                return;
            }
            for (int j = 0; j < this.interruptibles.size(); ++j) {
                WeakReference<Interruptible> w = this.interruptibles.get(j);
                if (w.get() != interruptible) continue;
                this.interruptibles.remove(j);
                return;
            }
        }
    }

    public synchronized ExecutionState setExecutionState(ExecutionState newExecutionState) {
        ExecutionState oldExecutionState = this.executionState;
        this.setExecutionStateInternal(newExecutionState);
        return oldExecutionState;
    }

    public synchronized boolean setInterruptRequested(boolean newInterruptFlagValue) {
        boolean oldInterruptRequested = this.interruptRequested;
        this.interruptRequested = newInterruptFlagValue;
        if (this.interruptRequested && this.interruptibles != null) {
            for (int j = 0; j < this.interruptibles.size(); ++j) {
                Interruptible interruptible = (Interruptible)this.interruptibles.get(j).get();
                if (interruptible == null) continue;
                interruptible.setInterruptRequested(true);
            }
        }
        return oldInterruptRequested;
    }

    public void setNumberOfSubtasksToBeDone(int number) {
        this.numberOfSubtasks = number;
    }

    public synchronized Throwable setThrowable(Throwable newThrowable) {
        return this.setThrowablePrivate(newThrowable);
    }

    public synchronized void setThreadDone(boolean yesno) {
        this.threadDone = yesno;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TaskStatus(");
        sb.append((Object)this.executionState).append(",");
        sb.append(this.interruptRequested ? "int" : "").append(",");
        sb.append(this.numberOfSubtasksDone).append("/");
        sb.append(this.numberOfSubtasks).append(",");
        sb.append(this.throwable).append(")");
        return sb.toString();
    }

    private void setExecutionStateInternal(ExecutionState newState) {
        this.executionState = newState;
    }

    public Throwable setThrowablePrivate(Throwable newThrowable) {
        Throwable oldThrowable = this.throwable;
        this.throwable = newThrowable;
        return oldThrowable;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExecutionState {
        Uninitialized,
        Initializing,
        Initialized,
        Starting,
        Running,
        Stopping,
        Stopped;

    }
}

