/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.Interruptible;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Checksum;

public class LengthLimitedInputStream
extends InputStream
implements Interruptible {
    private long bytesRead;
    private long maxBytes;
    private Checksum checksum;
    private InputStream wrappedInputStream;
    private boolean interruptRequested;

    public LengthLimitedInputStream(InputStream wrappedInputStream, long maxBytes) {
        this(wrappedInputStream, maxBytes, null);
    }

    public LengthLimitedInputStream(InputStream wrappedInputStream, long maxBytes, Checksum checksum) {
        this.wrappedInputStream = wrappedInputStream;
        this.maxBytes = maxBytes;
        this.checksum = checksum;
    }

    public int available() throws IOException {
        int wrappedAvailable = this.wrappedInputStream.available();
        long limited = this.maxBytes - this.bytesRead;
        int limitedAsInt = limited > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)limited;
        return wrappedAvailable < limitedAsInt ? wrappedAvailable : limitedAsInt;
    }

    public void close() throws IOException {
    }

    public int read() throws IOException {
        if (this.interruptRequested) {
            return -1;
        }
        if (this.bytesRead >= this.maxBytes) {
            return -1;
        }
        int byteRead = this.wrappedInputStream.read();
        if (byteRead > 0) {
            ++this.bytesRead;
            if (this.checksum != null) {
                this.checksum.update(byteRead);
            }
        }
        return byteRead;
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.interruptRequested) {
            return -1;
        }
        int bytesToRead = len;
        if (this.maxBytes - this.bytesRead < (long)len) {
            bytesToRead = (int)(this.maxBytes - this.bytesRead);
        }
        if (bytesToRead <= 0) {
            return -1;
        }
        int bytesActuallyRead = this.wrappedInputStream.read(b, off, bytesToRead);
        if (bytesActuallyRead > 0) {
            this.bytesRead += (long)bytesActuallyRead;
            if (this.checksum != null) {
                this.checksum.update(b, off, bytesActuallyRead);
            }
        }
        return bytesActuallyRead;
    }

    public boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    public boolean setInterruptRequested(boolean newInterruptRequestedValue) {
        boolean oldValue = this.interruptRequested;
        this.interruptRequested = newInterruptRequestedValue;
        return oldValue;
    }
}

