/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InputStreamConcatenator
extends InputStream {
    private final Iterator<InputStream> iterator;
    private InputStream currentInputStream = new EmptyInputStream();

    public InputStreamConcatenator(Iterator<InputStream> inputStreamIterator) {
        this.iterator = inputStreamIterator;
    }

    @Override
    public int available() throws IOException {
        int avail = this.currentInputStream.available();
        if (avail <= 0) {
            this.nextStream();
            avail = this.currentInputStream.available();
        }
        return avail;
    }

    @Override
    public int read() throws IOException {
        int byteRead = this.currentInputStream.read();
        if (byteRead < 0) {
            this.nextStream();
            byteRead = this.currentInputStream.read();
        }
        return byteRead;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int numberOfBytesRead = this.currentInputStream.read(b, off, len);
        if (numberOfBytesRead < 0) {
            this.nextStream();
            numberOfBytesRead = this.currentInputStream.read(b, off, len);
        }
        return numberOfBytesRead;
    }

    private void nextStream() {
        BackupUtil.assuredClose(this.currentInputStream);
        this.currentInputStream = this.iterator.hasNext() ? this.iterator.next() : new EmptyInputStream();
    }

    private class EmptyInputStream
    extends InputStream {
        private EmptyInputStream() {
        }

        public int read() throws IOException {
            return -1;
        }

        public int read(byte[] b) throws IOException {
            return -1;
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return -1;
        }
    }
}

