/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.backup.DeflaterInputStream;
import com.ibm.es.nuvo.backup.FileInputStreamIterator;
import com.ibm.es.nuvo.backup.InputStreamConcatenator;
import com.ibm.es.nuvo.backup.Interruptible;
import com.ibm.es.nuvo.backup.LengthLimitedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.zip.Adler32;
import java.util.zip.InflaterInputStream;

public class DeflatingSegmentingInputStreamIterator
implements Iterator,
Interruptible {
    private InputStream wrappedInputStream;
    private File temporaryFile;
    private long maxSegmentBytes;
    private LengthLimitedInputStream currentInputStream;
    private int segmentNumber = -1;
    private Adler32 checksum = new Adler32();
    private long numberOfBytesInInputStream;
    private boolean interruptRequested;

    public DeflatingSegmentingInputStreamIterator(InputStream inputStream, long maxSegmentBytes) throws IOException {
        this(inputStream, maxSegmentBytes, 0);
    }

    public DeflatingSegmentingInputStreamIterator(InputStream inputStream, long maxSegmentBytes, int compressionLevel) throws IOException {
        this(inputStream, maxSegmentBytes, compressionLevel, CompressionMechanism.Streaming);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DeflatingSegmentingInputStreamIterator(InputStream inputStream, long maxSegmentBytes, int compressionLevel, CompressionMechanism compressionMechanism) throws IOException {
        this.wrappedInputStream = inputStream;
        this.maxSegmentBytes = maxSegmentBytes;
        if (compressionLevel == 0) return;
        this.wrappedInputStream = new DeflaterInputStream(this.wrappedInputStream, compressionLevel);
        if (compressionMechanism != CompressionMechanism.TmpFile) return;
        FileOutputStream fos = null;
        boolean error = false;
        try {
            this.temporaryFile = File.createTempFile("backup", null);
            fos = new FileOutputStream(this.temporaryFile);
            byte[] buffer = new byte[8192];
            int nbr = 1;
            while (nbr > 0) {
                nbr = this.wrappedInputStream.read(buffer, 0, 8192);
                if (nbr <= 0) continue;
                fos.write(buffer, 0, nbr);
            }
            fos.close();
            this.wrappedInputStream.close();
            this.wrappedInputStream = new FileInputStream(this.temporaryFile);
            this.numberOfBytesInInputStream = this.temporaryFile.length();
            if (!error) return;
        }
        catch (IOException ioe) {
            try {
                error = true;
                throw ioe;
            }
            catch (Throwable throwable) {
                if (!error) throw throwable;
                BackupUtil.assuredClose(this.wrappedInputStream);
                BackupUtil.assuredClose(fos);
                this.deleteTemporaryFile();
                throw throwable;
            }
        }
        BackupUtil.assuredClose(this.wrappedInputStream);
        BackupUtil.assuredClose(fos);
        this.deleteTemporaryFile();
        return;
    }

    public void close() {
        BackupUtil.assuredClose(this.wrappedInputStream);
        this.deleteTemporaryFile();
    }

    public long getChecksum() {
        return this.checksum.getValue();
    }

    public long getNumberOfBytesInInputStream() {
        return this.numberOfBytesInInputStream;
    }

    public int getSegmentNumber() {
        return this.segmentNumber;
    }

    public boolean hasNext() {
        if (this.interruptRequested) {
            return false;
        }
        try {
            return this.wrappedInputStream.available() > 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.currentInputStream = new LengthLimitedInputStream(this.wrappedInputStream, this.maxSegmentBytes);
        ++this.segmentNumber;
        return this.currentInputStream;
    }

    public void remove() {
        throw new UnsupportedOperationException();
    }

    public boolean isInterruptRequested() {
        return this.interruptRequested;
    }

    public boolean setInterruptRequested(boolean newInterruptRequestedValue) {
        boolean oldValue = this.interruptRequested;
        this.interruptRequested = newInterruptRequestedValue;
        if (this.interruptRequested && this.currentInputStream != null) {
            this.currentInputStream.setInterruptRequested(newInterruptRequestedValue);
        }
        return oldValue;
    }

    private void deleteTemporaryFile() {
        if (this.temporaryFile != null) {
            try {
                this.temporaryFile.delete();
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            this.temporaryFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        FileOutputStream fos = null;
        InputStream is = null;
        try {
            File f = new File(args[0]);
            DeflatingSegmentingInputStreamIterator it = new DeflatingSegmentingInputStreamIterator(new FileInputStream(f), 100000L, 9);
            byte[] b = new byte[8192];
            while (it.hasNext()) {
                is = it.next();
                File f2 = new File("C:\\tmp", "file" + it.getSegmentNumber());
                fos = new FileOutputStream(f2);
                while (is.available() > 0) {
                    int n = is.read(b);
                    fos.write(b, 0, n);
                }
                fos.close();
                is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BackupUtil.assuredClose(is);
            BackupUtil.assuredClose(fos);
        }
        FileInputStreamIterator fisi = new FileInputStreamIterator("C:\\tmp\\file");
        InputStreamConcatenator isc = new InputStreamConcatenator(fisi);
        InflaterInputStream iis = new InflaterInputStream(isc);
        try {
            int nbr;
            fos = new FileOutputStream("C:\\tmp\\testmerge");
            byte[] b = new byte[8192];
            while (iis.available() > 0 && (nbr = iis.read(b, 0, 8192)) > 0) {
                fos.write(b, 0, nbr);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            BackupUtil.assuredClose(isc);
            BackupUtil.assuredClose(iis);
            BackupUtil.assuredClose(fos);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CompressionMechanism {
        Streaming,
        TmpFile;

    }
}

