/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupUtil;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Deflater;

public class DeflaterInputStream
extends FilterInputStream {
    private int compressionLevel;
    private Deflater deflater;
    private byte[] uncompressedBytes = new byte[4096];
    private int numberOfUncompressedBytes;
    private byte[] compressedBytes = new byte[4096];
    private int numberOfCompressedBytes;
    private int numberOfCompressedBytesReturned;

    public DeflaterInputStream(InputStream inputStream, int compressionLevel) {
        super(inputStream);
        this.compressionLevel = compressionLevel;
        this.deflater = new Deflater(this.compressionLevel);
    }

    public int available() throws IOException {
        int a = this.in.available();
        if (a <= 0) {
            a = this.deflater.finished() ? 0 : 4096;
        }
        return a;
    }

    public void close() {
        BackupUtil.assuredClose(this.in);
    }

    public int read() throws IOException {
        if (this.isEmpty()) {
            return -1;
        }
        return this.compressedBytes[this.numberOfCompressedBytesReturned++];
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        if (this.isEmpty()) {
            return -1;
        }
        int bytesWritten = 0;
        for (int j = 0; j < len && this.numberOfCompressedBytesReturned < this.numberOfCompressedBytes; ++j) {
            b[off + j] = this.compressedBytes[this.numberOfCompressedBytesReturned++];
            ++bytesWritten;
        }
        return bytesWritten;
    }

    private boolean isEmpty() throws IOException {
        if (this.numberOfCompressedBytesReturned >= this.numberOfCompressedBytes) {
            this.numberOfCompressedBytes = 0;
            this.numberOfCompressedBytesReturned = 0;
            this.compress();
        }
        return this.numberOfCompressedBytesReturned >= this.numberOfCompressedBytes;
    }

    private void compress() throws IOException {
        boolean moreInput = true;
        while (moreInput) {
            int numberOfAdditionalCompressedBytes;
            if (this.deflater.needsInput()) {
                this.numberOfUncompressedBytes = this.in.read(this.uncompressedBytes, 0, 4096);
                if (this.numberOfUncompressedBytes < 0) {
                    this.deflater.finish();
                    moreInput = false;
                } else {
                    this.deflater.setInput(this.uncompressedBytes, 0, this.numberOfUncompressedBytes);
                }
            }
            if ((numberOfAdditionalCompressedBytes = this.deflater.deflate(this.compressedBytes, this.numberOfCompressedBytes, 4096 - this.numberOfCompressedBytes)) <= 0) continue;
            this.numberOfCompressedBytes += numberOfAdditionalCompressedBytes;
            break;
        }
    }
}

