/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class BackupUtil {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public static String checkNonempty(BackupConfiguration configuration, String propertyName) throws ExtendedException {
        String[] tr = new String[1];
        if (StringUtils.noData(configuration.getProperty(propertyName), tr)) {
            throw new ExtendedException(new Message("X0043W.BNR", propertyName));
        }
        return tr[0];
    }

    public static void assuredClose(InputStream inputStream) {
        if (inputStream != null) {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void assuredClose(OutputStream outputStream) {
        if (outputStream != null) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void assuredClose(ResultSet resultSet) {
        if (resultSet != null) {
            try {
                resultSet.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void assuredClose(Connection connection) {
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void assuredClose(Statement statement) {
        if (statement != null) {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }

    public static void copyFile(File inputFile, File outputFile) throws IOException {
        BackupUtil.copyInputStream(new FileInputStream(inputFile), outputFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyInputStream(InputStream inputStream, File outputFile) throws IOException {
        FileOutputStream fos = null;
        try {
            int nbr;
            fos = new FileOutputStream(outputFile);
            byte[] buf = new byte[4096];
            while ((nbr = inputStream.read(buf, 0, 4096)) > 0) {
                fos.write(buf, 0, nbr);
            }
        }
        finally {
            BackupUtil.assuredClose(inputStream);
            BackupUtil.assuredClose(fos);
        }
    }

    public static boolean contentMatch(InputStream stream1, File file2) throws IOException {
        FileInputStream stream2 = null;
        try {
            stream2 = new FileInputStream(file2);
            byte[] buf1 = new byte[4096];
            byte[] buf2 = new byte[4096];
            block6: while (true) {
                int nbr2;
                int nbr1;
                if ((nbr1 = stream1.read(buf1, 0, 4096)) <= 0) {
                    boolean bl = true;
                    return bl;
                }
                for (int ncib2 = 0; ncib2 < nbr1; ncib2 += nbr2) {
                    nbr2 = stream2.read(buf2, ncib2, nbr1 - ncib2);
                    if (nbr2 > 0) continue;
                    boolean bl = false;
                    return bl;
                }
                int j = 0;
                while (true) {
                    if (j >= nbr1) continue block6;
                    if (buf1[j] != buf2[j]) {
                        boolean bl = false;
                        return bl;
                    }
                    ++j;
                }
                break;
            }
        }
        finally {
            BackupUtil.assuredClose(stream1);
            BackupUtil.assuredClose(stream2);
        }
    }
}

