/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.backup.BackupManager;
import com.ibm.es.nuvo.backup.BackupMetadataFile;
import com.ibm.es.nuvo.backup.BackupMetadataSource;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.configuration.CollectionFile;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupTransferListBuilder {
    private LinkedList<CollectionFile> filesToBeDeleted;
    private LinkedList<CollectionFile> filesToBeInserted;
    private LinkedList<CollectionFile> filesToBeUpdated;
    private LinkedList<CollectionFile> filesNotAffected;
    private boolean backupVolumeFound;
    private boolean forcing;
    private CollectionConfiguration collectionConfiguration;
    private IndexDescriptor.IndexType[] managedIndexes;
    private String collectionID;
    private BackupManager.TransferDirection transferDirection;
    private boolean forceBackup;
    private boolean forceRestore;
    private long backupGeneration;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupTransferListBuilder(BackupConfiguration backupConfiguration, BackupManager.TransferDirection transferDirection) throws ExtendedException {
        this.transferDirection = transferDirection;
        this.collectionID = backupConfiguration.getProperty("collection");
        String fb = null;
        fb = backupConfiguration.getProperty("force_backup");
        this.forceBackup = fb != null && fb.equalsIgnoreCase("true");
        fb = backupConfiguration.getProperty("force_restore");
        this.forceRestore = fb == null || !fb.equalsIgnoreCase("false");
        this.managedIndexes = backupConfiguration.getIndexesManaged();
        ConfigurationManager cm = ConfigurationManager.getConfigurationManager();
        CollectionConfiguration cc = null;
        try {
            cc = cm.getCollection(this.collectionID);
        }
        catch (ConfigurationManagerException cme) {
        }
        finally {
            if (cc == null) {
                cc = CollectionConfiguration.createDefault();
                cc.setId(this.collectionID);
                cm.createCollection(cc);
            }
            this.collectionConfiguration = cc;
        }
        this.backupGeneration = this.collectionConfiguration.getBackupGeneration();
        BackupMetadataFile metadataFile = new BackupMetadataFile(this.collectionConfiguration.getBackupMetadataFile());
        try {
            metadataFile.load();
        }
        catch (IOException ioe) {
        }
        catch (ClassNotFoundException cnfe) {
            throw new ExtendedException(new Message("G0020E.EXTERNAL_ERROR_MESSAGE"), (Throwable)cnfe);
        }
        this.buildChangeListsPrivate(metadataFile);
    }

    public void buildChangeLists(BackupMetadataSource backupMetadataSource) throws ExtendedException {
        this.buildChangeListsPrivate(backupMetadataSource);
    }

    private void buildChangeListsPrivate(BackupMetadataSource backupMetadataSource) throws ExtendedException {
        Iterator<CollectionFile> localFiles = this.collectionConfiguration.getFilesForBackup(this.managedIndexes);
        HashMap<String, CollectionFile> lastBackupContent = backupMetadataSource.getBackupMetadata();
        this.backupVolumeFound = lastBackupContent != null && lastBackupContent.size() > 0;
        LinkedList<CollectionFile> localNoBackup = new LinkedList<CollectionFile>();
        LinkedList<CollectionFile> localAndBackup = new LinkedList<CollectionFile>();
        LinkedList<CollectionFile> backupNoLocal = new LinkedList<CollectionFile>();
        this.filesNotAffected = new LinkedList();
        boolean isBackup = this.transferDirection == BackupManager.TransferDirection.Backup;
        boolean bl = this.forcing = isBackup && this.forceBackup || !isBackup && this.forceRestore;
        while (localFiles.hasNext()) {
            CollectionFile backedUpFile;
            CollectionFile collectionFile = localFiles.next();
            CollectionFile collectionFile2 = backedUpFile = lastBackupContent == null ? null : lastBackupContent.remove(collectionFile.getPathInCollection());
            if (backedUpFile == null) {
                localNoBackup.add(collectionFile);
                continue;
            }
            boolean updateNeeded = this.forcing;
            if (!this.forcing) {
                boolean bl2 = updateNeeded = isBackup && collectionFile.getLastModified() > backedUpFile.getBackingStoreLastModified() || !isBackup && collectionFile.getLastModified() < backedUpFile.getBackingStoreLastModified();
            }
            if (updateNeeded) {
                localAndBackup.add(backedUpFile);
                continue;
            }
            this.filesNotAffected.add(backedUpFile);
        }
        if (lastBackupContent != null) {
            Iterator<Map.Entry<String, CollectionFile>> it = lastBackupContent.entrySet().iterator();
            while (it.hasNext()) {
                backupNoLocal.add(it.next().getValue());
            }
        }
        this.filesToBeInserted = isBackup ? localNoBackup : backupNoLocal;
        this.filesToBeDeleted = isBackup ? backupNoLocal : localNoBackup;
        this.filesToBeUpdated = localAndBackup;
    }

    public long getBackupGeneration() {
        return this.backupGeneration;
    }

    public LinkedList<CollectionFile> getFilesNotAffected() {
        return this.filesNotAffected;
    }

    public Iterator<CollectionFile> getFilesToBeDeleted() {
        return this.filesToBeDeleted.iterator();
    }

    public Iterator<CollectionFile> getFilesToBeInserted() {
        return this.filesToBeInserted.iterator();
    }

    public Iterator<CollectionFile> getFilesToBeUpdated() {
        return this.filesToBeUpdated.iterator();
    }

    public int getNumberOfFilesAffected() {
        return this.filesToBeDeleted.size() + this.filesToBeInserted.size() + this.filesToBeUpdated.size();
    }

    public boolean isTransferForced() {
        return this.forcing;
    }

    public boolean wasBackupVolumeFound() {
        return this.backupVolumeFound;
    }

    public void writeBackupMetadataFile(LinkedList<CollectionFile> backedUpFiles) throws IOException {
        BackupMetadataFile metadataFile = new BackupMetadataFile(this.collectionConfiguration.getBackupMetadataFile());
        Iterator it = backedUpFiles.iterator();
        while (it.hasNext()) {
            metadataFile.addCollectionFile((CollectionFile)it.next());
        }
        metadataFile.save();
    }
}

