/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupMetadataSource;
import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.configuration.CollectionFile;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OptionalDataException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupMetadataFile
implements BackupMetadataSource {
    File backupContentFile;
    HashMap<String, CollectionFile> backupContentTable = new HashMap();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public BackupMetadataFile(File backupContentFile) {
        this.backupContentFile = backupContentFile;
    }

    public CollectionFile addCollectionFile(CollectionFile newFile) {
        return this.backupContentTable.put(newFile.getPathInCollection(), newFile);
    }

    public File getBackupMetadataFile() {
        return this.backupContentFile;
    }

    @Override
    public HashMap<String, CollectionFile> getBackupMetadata() {
        return this.backupContentTable;
    }

    public int getNumberOfFiles() {
        return this.backupContentTable.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws ClassNotFoundException, IOException {
        ObjectInputStream ois = null;
        FileInputStream fis = null;
        this.backupContentTable.clear();
        try {
            fis = new FileInputStream(this.backupContentFile);
            ois = new ObjectInputStream(fis);
            try {
                while (true) {
                    CollectionFile collectionFile = (CollectionFile)ois.readObject();
                    this.backupContentTable.put(collectionFile.getPathInCollection(), collectionFile);
                }
            }
            catch (EOFException eofe) {
            }
            catch (OptionalDataException ode) {
                if (!ode.eof) {
                    throw ode;
                }
            }
        }
        catch (Throwable throwable) {
            BackupUtil.assuredClose(ois);
            BackupUtil.assuredClose(fis);
            throw throwable;
        }
        BackupUtil.assuredClose(ois);
        BackupUtil.assuredClose(fis);
    }

    public CollectionFile removeCollectionFile(String path) {
        return this.backupContentTable.remove(path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() throws IOException {
        ObjectOutputStream oos = null;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.backupContentFile);
            oos = new ObjectOutputStream(fos);
            Iterator<Map.Entry<String, CollectionFile>> it = this.backupContentTable.entrySet().iterator();
            while (it.hasNext()) {
                oos.writeObject(it.next().getValue());
            }
        }
        catch (Throwable throwable) {
            BackupUtil.assuredClose(oos);
            BackupUtil.assuredClose(fos);
            throw throwable;
        }
        BackupUtil.assuredClose(oos);
        BackupUtil.assuredClose(fos);
    }
}

