/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupAgent;
import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.backup.TaskStatus;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.logging.Loggers;
import com.ibm.es.nuvo.util.StringUtils;
import java.util.HashMap;
import java.util.logging.Level;

public abstract class BackupManager {
    private static BackupManager instance = null;
    private static Object lock = new Object();
    private HashMap<String, BackupConfiguration> configurationTable = new HashMap();
    private Object configurationLock = new Object();
    private HashMap<String, BackupAgent> agentsTable = new HashMap();
    private Object agentsLock = new Object();
    private boolean noMoreAgents = false;
    HashMap<String, TaskStatus> backupTaskStatuses = new HashMap();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BackupManager getInstance() {
        Object object = lock;
        synchronized (object) {
            return instance;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInstance(BackupManager manager) {
        Object object = lock;
        synchronized (object) {
            instance = manager;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutDownBackupAndRestore() {
        Object object = lock;
        synchronized (object) {
            if (instance != null) {
                instance.shutDownAllAgents();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void allowNewAgents() {
        Object object = lock;
        synchronized (object) {
            if (instance != null) {
                Object object2 = BackupManager.instance.agentsLock;
                synchronized (object2) {
                    BackupManager.instance.noMoreAgents = false;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupConfiguration storeBackupConfiguration(BackupConfiguration configuration) {
        Object object = this.configurationLock;
        synchronized (object) {
            String collectionID = configuration.getProperty("collection");
            if (StringUtils.noData(collectionID)) {
                collectionID = "default";
                configuration.setProperty("collection", collectionID);
            }
            return this.configurationTable.put(collectionID, configuration);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupAgent createBackupAgentForCollection(String collectionID, TransferDirection transferDirection) throws ExtendedException {
        Object object = this.agentsLock;
        synchronized (object) {
            BackupConfiguration configuration = this.getBackupConfigurationForCollection(collectionID);
            if (StringUtils.noData(collectionID)) {
                collectionID = "default";
            }
            configuration.setProperty("collection", collectionID);
            this.ensureNoAgent(collectionID);
            this.ensureNewAgentAllowed(collectionID);
            BackupAgent backupAgent = this.createBackupAgent(this.getBackupConfigurationForCollection(collectionID), transferDirection);
            if (backupAgent != null && backupAgent.getBackupAgentStatus().getExecutionState() != TaskStatus.ExecutionState.Stopped) {
                this.agentsTable.put(collectionID, backupAgent);
                this.backupTaskStatuses.put(collectionID, backupAgent.getBackupAgentStatus());
            }
            return backupAgent;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BackupAgent getBackupAgentForCollection(String collectionID) {
        Object object = this.agentsLock;
        synchronized (object) {
            return this.agentsTable.get(collectionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatus getBackupStatusForCollection(String collectionID) {
        Object object = this.agentsLock;
        synchronized (object) {
            return this.backupTaskStatuses.get(collectionID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAgentForCollection(String collectionID) {
        Object object = this.agentsLock;
        synchronized (object) {
            this.agentsTable.remove(collectionID);
        }
    }

    protected abstract BackupAgent createBackupAgent(BackupConfiguration var1, TransferDirection var2) throws ExtendedException;

    private void ensureNewAgentAllowed(String collectionID) throws ExtendedException {
        if (this.noMoreAgents) {
            throw new ExtendedException(new Message("X0039W.BNR", collectionID));
        }
    }

    private void ensureNoAgent(String collectionID) throws ExtendedException {
        if (this.agentsTable.get(collectionID) != null) {
            throw new ExtendedException(new Message("X0040W.BNR", collectionID));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BackupConfiguration getBackupConfigurationForCollection(String collectionID) {
        Object object = this.configurationLock;
        synchronized (object) {
            BackupConfiguration configuration = this.configurationTable.get(collectionID);
            if (configuration == null) {
                configuration = this.configurationTable.get("default");
            }
            return configuration;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void shutDownAllAgents() {
        Object object = this.agentsLock;
        synchronized (object) {
            this.noMoreAgents = true;
            for (String collectionID : this.agentsTable.keySet()) {
                BackupAgent agent = this.agentsTable.remove(collectionID);
                try {
                    agent.interruptBackupAgent();
                }
                catch (Throwable throwable) {
                    if (!Loggers.logger.isLoggable(Level.WARNING)) continue;
                    Loggers.logger.log(Level.WARNING, new ExtendedException(new Message("X0041W.BNR", collectionID), throwable));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransferOutcome {
        Successful,
        Unsuccessful;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransferDirection {
        Backup,
        Restore;

    }
}

