/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.IndexDescriptor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackupConfiguration {
    public static final String BC_COLLECTION_ID = "collection";
    public static final String BC_DEFAULT_COLLECTION_ID = "default";
    public static final String BC_FORCE_BACKUP = "force_backup";
    public static final String BC_FORCE_RESTORE = "force_restore";
    public static final String BC_INDEXES = "indexes";
    public static final String BC_TEST_CONNECTION = "test_connection";
    public static final String BC_TESTING = "testing";
    private Properties properties = new Properties();
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    public BackupConfiguration() {
        this(null);
    }

    public BackupConfiguration(Hashtable<String, String> nvTable) {
        if (nvTable != null && !nvTable.isEmpty()) {
            Enumeration<String> en = nvTable.keys();
            while (en.hasMoreElements()) {
                String key = en.nextElement();
                String val = nvTable.get(key);
                this.properties.setProperty(key, val);
            }
        }
    }

    public String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    public IndexDescriptor.IndexType[] getIndexesManaged() {
        String configuredIndexes = this.properties.getProperty(BC_INDEXES);
        IndexDescriptor.IndexType[] allTypes = IndexDescriptor.IndexType.values();
        if (configuredIndexes == null) {
            return allTypes;
        }
        LinkedList<IndexDescriptor.IndexType> indexTypeList = new LinkedList<IndexDescriptor.IndexType>();
        configuredIndexes = configuredIndexes.toLowerCase();
        for (int j = 0; j < allTypes.length; ++j) {
            if (!configuredIndexes.contains(allTypes[j].toString().toLowerCase())) continue;
            indexTypeList.add(allTypes[j]);
        }
        return indexTypeList.size() > 0 ? indexTypeList.toArray(new IndexDescriptor.IndexType[indexTypeList.size()]) : null;
    }

    public boolean isTestConnectionOnly() {
        String propertyValue = this.properties.getProperty(BC_TEST_CONNECTION);
        return propertyValue != null && propertyValue.equals("true");
    }

    public void load(File restoreConfigFile) throws ExtendedException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(restoreConfigFile);
            this.properties.load(fis);
        }
        catch (IOException ioe) {
            try {
                throw new ExtendedException(new Message("G0020E.EXTERNAL_ERROR_MESSAGE"), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                BackupUtil.assuredClose(fis);
                throw throwable;
            }
        }
        BackupUtil.assuredClose(fis);
    }

    public void save(File restoreConfigFile) throws ExtendedException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(restoreConfigFile);
            this.properties.store(fos, null);
        }
        catch (IOException ioe) {
            try {
                throw new ExtendedException(new Message("G0020E.EXTERNAL_ERROR_MESSAGE"), (Throwable)ioe);
            }
            catch (Throwable throwable) {
                BackupUtil.assuredClose(fos);
                throw throwable;
            }
        }
        BackupUtil.assuredClose(fos);
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("BackupConfiguration [");
        Iterator<Map.Entry<Object, Object>> it = this.properties.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<Object, Object> entry = it.next();
            sb.append(entry.getKey()).append("=").append(entry.getValue());
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

