/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.backup;

import com.ibm.es.nuvo.backup.BackupConfiguration;
import com.ibm.es.nuvo.backup.BackupManager;
import com.ibm.es.nuvo.backup.BackupTransferListBuilder;
import com.ibm.es.nuvo.backup.BackupUtil;
import com.ibm.es.nuvo.backup.TaskStatus;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.CollectionFile;
import com.ibm.es.nuvo.configuration.ConfigurationManager;
import com.ibm.es.nuvo.logging.Loggers;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.logging.Level;

public abstract class BackupAgent {
    protected final BackupManager.TransferDirection transferDirection;
    protected String collectionID;
    protected boolean removeUponCompletion = true;
    protected TaskStatus taskStatus = new TaskStatus();
    protected BackupTransferListBuilder transferListBuilder;
    protected BackupThread backupThread;
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";

    protected BackupAgent(BackupManager.TransferDirection transferDirection) {
        this.transferDirection = transferDirection;
    }

    public final synchronized void configureBackupAgent(BackupConfiguration backupConfiguration) {
        if (this.taskStatus.isInterruptRequested()) {
            this.stopBackupAgent();
            return;
        }
        try {
            this.taskStatus.requestExecutionState(TaskStatus.ExecutionState.Initializing);
            this.collectionID = BackupUtil.checkNonempty(backupConfiguration, "collection");
            this.transferListBuilder = new BackupTransferListBuilder(backupConfiguration, this.transferDirection);
            this.taskStatus.setNumberOfSubtasksToBeDone(this.transferListBuilder.getNumberOfFilesAffected());
            this.configureDerivedBackupAgent(backupConfiguration);
            if (backupConfiguration.isTestConnectionOnly()) {
                this.stopBackupAgent();
                return;
            }
            this.backupThread = this.createBackupThread();
            this.taskStatus.requestExecutionState(TaskStatus.ExecutionState.Initialized);
            if (this.taskStatus.isInterruptRequested()) {
                this.stopBackupAgent();
            }
        }
        catch (Throwable throwable) {
            this.recordThrowable(throwable);
            this.stopBackupAgent();
        }
    }

    protected void configureDerivedBackupAgent(BackupConfiguration backupConfiguration) throws Throwable {
    }

    protected abstract BackupThread createBackupThread();

    public final synchronized void startBackupAgent() {
        if (this.taskStatus.isInterruptRequested()) {
            this.stopBackupAgent();
            return;
        }
        try {
            this.taskStatus.requestExecutionState(TaskStatus.ExecutionState.Starting);
            if (this.canSkipTransfer()) {
                this.stopBackupAgent();
                return;
            }
            if (this.backupThread != null) {
                this.backupThread.start();
            }
            this.taskStatus.requestExecutionState(TaskStatus.ExecutionState.Running);
            if (this.taskStatus.isInterruptRequested()) {
                this.stopBackupAgent();
            }
        }
        catch (Throwable throwable) {
            this.recordThrowable(throwable);
            this.stopBackupAgent();
        }
    }

    protected boolean canSkipTransfer() throws Throwable {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void stopBackupAgent() {
        try {
            if (this.taskStatus.getExecutionState() == TaskStatus.ExecutionState.Stopped || this.taskStatus.getExecutionState() == TaskStatus.ExecutionState.Stopping) {
                return;
            }
            Object oldExecutionState = this.taskStatus.setExecutionState(TaskStatus.ExecutionState.Stopping);
            if (oldExecutionState.ordinal() >= TaskStatus.ExecutionState.Running.ordinal()) {
                if (this.backupThread != null && !this.taskStatus.isThreadDone()) {
                    this.taskStatus.setInterruptRequested(true);
                }
                if (this.transferDirection == BackupManager.TransferDirection.Restore) {
                    ConfigurationManager.getConfigurationManager().refreshCacheForCollection(this.collectionID);
                }
            }
            this.stopDerivedBackupAgent();
        }
        catch (Throwable throwable) {
            this.recordThrowable(throwable);
        }
        finally {
            TaskStatus taskStatus = this.taskStatus;
            synchronized (taskStatus) {
                this.taskStatus.setExecutionState(TaskStatus.ExecutionState.Stopped);
            }
            if (this.removeUponCompletion) {
                BackupManager.getInstance().releaseAgentForCollection(this.collectionID);
            }
        }
    }

    protected void stopDerivedBackupAgent() throws Throwable {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TaskStatus getBackupAgentStatus() {
        TaskStatus taskStatus = this.taskStatus;
        synchronized (taskStatus) {
            return this.taskStatus;
        }
    }

    public BackupManager.TransferDirection getTransferDirection() {
        return this.transferDirection;
    }

    public synchronized void interruptBackupAgent() {
        this.taskStatus.setInterruptRequested(true);
    }

    public void setRemoveUponCompletion(boolean shouldRemove) {
        this.removeUponCompletion = shouldRemove;
    }

    public boolean willRemoveUponCompletion() {
        return this.removeUponCompletion;
    }

    protected void recordThrowable(Throwable throwable) {
        this.taskStatus.recordFirstThrowable(throwable);
        if (Loggers.logger.isLoggable(Level.WARNING)) {
            Loggers.logger.log(Level.WARNING, new ExtendedException(new Message("X0044W.BNR", this.collectionID), throwable));
        }
    }

    protected abstract class BackupThread
    extends Thread {
        private BackupAgent This;

        protected BackupThread() {
            this.setDaemon(true);
            this.This = BackupAgent.this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block43: {
                Iterator<CollectionFile> insertFiles = this.This.transferListBuilder.getFilesToBeInserted();
                Iterator<CollectionFile> updateFiles = this.This.transferListBuilder.getFilesToBeUpdated();
                Iterator<CollectionFile> deleteFiles = this.This.transferListBuilder.getFilesToBeDeleted();
                LinkedList<CollectionFile> remainingFiles = this.This.transferListBuilder.getFilesNotAffected();
                while (!this.This.taskStatus.isInterruptRequested()) {
                    if (deleteFiles.hasNext()) {
                        CollectionFile fileToDelete = deleteFiles.next();
                        this.deleteFile(fileToDelete);
                        this.This.taskStatus.incrementSubtasksDoneSoFar(1);
                        continue;
                    }
                    if (updateFiles.hasNext()) {
                        CollectionFile fileToUpdate = updateFiles.next();
                        this.updateFile(fileToUpdate);
                        remainingFiles.add(fileToUpdate);
                        this.This.taskStatus.incrementSubtasksDoneSoFar(1);
                        continue;
                    }
                    if (!insertFiles.hasNext()) break;
                    CollectionFile fileToInsert = insertFiles.next();
                    this.insertFile(fileToInsert);
                    remainingFiles.add(fileToInsert);
                    this.This.taskStatus.incrementSubtasksDoneSoFar(1);
                }
                this.This.transferListBuilder.writeBackupMetadataFile(remainingFiles);
                Object var7_7 = null;
                try {
                    if (this.This.taskStatus.getThrowable() == null && !this.This.taskStatus.isInterruptRequested()) {
                        this.notificationOfTransferOutcome(BackupManager.TransferOutcome.Successful);
                    }
                    this.notificationOfTransferOutcome(BackupManager.TransferOutcome.Unsuccessful);
                }
                catch (Throwable t2) {
                    this.This.recordThrowable(t2);
                }
                finally {
                    BackupAgent backupAgent = this.This;
                    synchronized (backupAgent) {
                        this.This.taskStatus.setThreadDone(true);
                        this.This.stopBackupAgent();
                    }
                }
                {
                    catch (Throwable t) {
                        BackupAgent backupAgent;
                        this.This.recordThrowable(t);
                        Object var7_8 = null;
                        try {
                            if (this.This.taskStatus.getThrowable() == null && !this.This.taskStatus.isInterruptRequested()) {
                                this.notificationOfTransferOutcome(BackupManager.TransferOutcome.Successful);
                            } else {
                                this.notificationOfTransferOutcome(BackupManager.TransferOutcome.Unsuccessful);
                            }
                            backupAgent = this.This;
                        }
                        catch (Throwable t2) {
                            try {}
                            catch (Throwable throwable) {
                                BackupAgent backupAgent2 = this.This;
                                synchronized (backupAgent2) {
                                    this.This.taskStatus.setThreadDone(true);
                                    this.This.stopBackupAgent();
                                }
                                throw throwable;
                            }
                            this.This.recordThrowable(t2);
                            BackupAgent backupAgent3 = this.This;
                            synchronized (backupAgent3) {
                                this.This.taskStatus.setThreadDone(true);
                                this.This.stopBackupAgent();
                                break block43;
                            }
                        }
                        synchronized (backupAgent) {
                            this.This.taskStatus.setThreadDone(true);
                            this.This.stopBackupAgent();
                            break block43;
                        }
                    }
                }
                catch (Throwable throwable) {
                    block45: {
                        BackupAgent backupAgent;
                        Object var7_9 = null;
                        try {
                            if (this.This.taskStatus.getThrowable() == null && !this.This.taskStatus.isInterruptRequested()) {
                                this.notificationOfTransferOutcome(BackupManager.TransferOutcome.Successful);
                            } else {
                                this.notificationOfTransferOutcome(BackupManager.TransferOutcome.Unsuccessful);
                            }
                            backupAgent = this.This;
                        }
                        catch (Throwable t2) {
                            try {}
                            catch (Throwable throwable2) {
                                BackupAgent backupAgent4 = this.This;
                                synchronized (backupAgent4) {
                                    this.This.taskStatus.setThreadDone(true);
                                    this.This.stopBackupAgent();
                                }
                                throw throwable2;
                            }
                            this.This.recordThrowable(t2);
                            BackupAgent backupAgent5 = this.This;
                            synchronized (backupAgent5) {
                                this.This.taskStatus.setThreadDone(true);
                                this.This.stopBackupAgent();
                                break block45;
                            }
                        }
                        synchronized (backupAgent) {
                            this.This.taskStatus.setThreadDone(true);
                            this.This.stopBackupAgent();
                        }
                    }
                    throw throwable;
                }
            }
        }

        protected abstract void deleteFile(CollectionFile var1) throws Throwable;

        protected abstract void insertFile(CollectionFile var1) throws Throwable;

        protected void updateFile(CollectionFile fileToUpdate) throws Throwable {
            this.deleteFile(fileToUpdate);
            this.insertFile(fileToUpdate);
        }

        protected abstract void notificationOfTransferOutcome(BackupManager.TransferOutcome var1) throws Throwable;

        protected void deleteFileFromCollection(CollectionFile fileToDelete) throws Throwable {
            fileToDelete.deleteFromCollection();
        }
    }
}

