/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.authentication;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.authentication.AuthenticationException;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.authentication.DefaultAuthenticationModule;
import com.ibm.es.nuvo.authentication.UserIdPasswordException;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;

public class PropertyFileAuthenticationModule
extends DefaultAuthenticationModule {
    private AuthenticationData authData = null;

    public PropertyFileAuthenticationModule() {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
        this.authData.setAuthenticationType(AuthenticationData.AuthenticationType.PropertyFile);
    }

    public PropertyFileAuthenticationModule(String userId, String passwd) throws ConfigurationManagerException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.AuthenticationData);
        this.authData.setAuthenticationType(AuthenticationData.AuthenticationType.PropertyFile);
        this.authData.setUserId(userId);
        this.authData.setPassword(passwd);
        configMgr.updateStateObject(SettingsConfigurationManager.SettingsType.AuthenticationData, this.authData);
    }

    public void changePassword(String userId, String originalPwd, String newPwd) throws AuthenticationException, ConfigurationManagerException, ExtendedException {
        if (userId != null && userId.equals(this.authData.getUserId())) {
            if (originalPwd == null || !originalPwd.equals(this.authData.getPassword())) {
                Message msg = new Message("G0113E.PASSWORD_CHANGE_BAD_ORIGINAL_PWD");
                throw new AuthenticationException(msg, (AuthenticationModule)this);
            }
        } else {
            throw new RuntimeException("Invalid userid " + userId);
        }
        this.authData.setPassword(newPwd);
        this.saveData();
    }

    public boolean doesPasswordExist() {
        try {
            return this.authData.getPassword() != null;
        }
        catch (ExtendedException extendedException) {
            return false;
        }
    }

    public void renameUserId(String originalUserId, String newUserId) throws ConfigurationManagerException, ExtendedException {
        if (newUserId == null || newUserId.length() <= 0) {
            throw new RuntimeException("Invalid userid " + newUserId);
        }
        this.authData.setUserId(newUserId);
        this.saveData();
    }

    public boolean validate(String userId, String pwd) throws ExtendedException {
        boolean valid = false;
        if (userId != null && userId.equals(this.authData.getUserId()) && pwd != null && pwd.equals(this.authData.getPassword())) {
            valid = true;
        }
        if (!valid) {
            throw new UserIdPasswordException(this);
        }
        return valid;
    }

    private synchronized void saveData() throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        AuthenticationData newAuthData = (AuthenticationData)configMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.AuthenticationData);
        newAuthData.setUserId(this.authData.getUserId());
        newAuthData.setPassword(this.authData.getPassword());
        newAuthData.setAuthenticationType(this.authData.getAuthenticationType());
        configMgr.updateStateObject(SettingsConfigurationManager.SettingsType.AuthenticationData, newAuthData);
        this.authData = newAuthData;
    }

    public String getPassword() {
        try {
            return this.authData.getPassword();
        }
        catch (ExtendedException e) {
            return null;
        }
    }

    public String getUserId() {
        return this.authData.getUserId();
    }
}

