/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.authentication;

import com.ibm.es.nuvo.GlobalSystem;
import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.authentication.AuthenticationException;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.authentication.DefaultAuthenticationModule;
import com.ibm.es.nuvo.authentication.UserIdPasswordException;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.crawler.security.DSSecurityManager;
import com.ibm.es.nuvo.crawler.security.DomainValidationException;
import com.ibm.es.nuvo.crawler.security.model.SecurityDomain;
import com.ibm.es.nuvo.crawler.security.model.UserPasswordCredential;
import com.ibm.es.nuvo.crawler.security.model.UserValidationResult;
import com.ibm.es.nuvo.search.security.IdentityContext;
import java.util.List;

public class LocalOSAuthenticationModule
extends DefaultAuthenticationModule {
    private AuthenticationData authData = null;
    private static String domainName = null;
    private static String computerName = null;
    private static Object nameMutex = new Object();

    public LocalOSAuthenticationModule(String userId, String password) throws ExtendedException {
        userId = LocalOSAuthenticationModule.getFullyQualifiedUserId(userId);
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
        this.authData.setAuthenticationType(AuthenticationData.AuthenticationType.LocalOS);
        this.authData.setUserId(userId);
        this.validate(userId, password);
        this.saveData();
    }

    public LocalOSAuthenticationModule(String userId) throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
        this.authData.setAuthenticationType(AuthenticationData.AuthenticationType.LocalOS);
        this.authData.setUserId(userId);
        this.saveData();
    }

    private synchronized void saveData() throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        AuthenticationData newAuthData = (AuthenticationData)configMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.AuthenticationData);
        newAuthData.setUserId(this.authData.getUserId());
        newAuthData.setAuthenticationType(this.authData.getAuthenticationType());
        configMgr.updateStateObject(SettingsConfigurationManager.SettingsType.AuthenticationData, newAuthData);
        this.authData = newAuthData;
    }

    public void changePassword(String userId, String originalPwd, String newPwd) throws AuthenticationException, ConfigurationManagerException, ExtendedException {
        throw new RuntimeException("Not supported");
    }

    public boolean doesPasswordExist() {
        return false;
    }

    public String getPassword() {
        return null;
    }

    public String getUserId() {
        return this.authData.getUserId();
    }

    public void renameUserId(String originalUserId, String newUserId) throws ConfigurationManagerException, ExtendedException {
        throw new RuntimeException("Not supported");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String loadDefaultDomain() throws DomainValidationException {
        Object object = nameMutex;
        synchronized (object) {
            if (computerName == null) {
                DSSecurityManager manager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getSecurityManager();
                domainName = manager.getDomainName();
                computerName = manager.getComputerName();
            }
            if (domainName != null) {
                return domainName;
            }
            return computerName;
        }
    }

    public static String getWindowsDomain() throws DomainValidationException {
        LocalOSAuthenticationModule.loadDefaultDomain();
        return domainName;
    }

    public boolean validate(String userId, String password) throws ExtendedException {
        String qualifiedDataUserId;
        boolean authenticated = false;
        String qualifiedUserId = LocalOSAuthenticationModule.getFullyQualifiedUserId(userId);
        if (qualifiedUserId.equals(qualifiedDataUserId = LocalOSAuthenticationModule.getFullyQualifiedUserId(this.authData.getUserId())) || userId.equalsIgnoreCase(this.authData.getUserId())) {
            try {
                DSSecurityManager manager = GlobalSystem.getSingleInstance().getGlobalCrawlerManager().getSecurityManager();
                List<SecurityDomain> domains = manager.getAllDomainNames();
                if (domains.size() <= 0) {
                    throw new UserIdPasswordException(null);
                }
                UserPasswordCredential credential = new UserPasswordCredential();
                credential.setUsername(userId);
                credential.setPassword(password);
                IdentityContext identityContext = new IdentityContext();
                identityContext.setDomain(domains.get(0));
                identityContext.setCredential(credential);
                UserValidationResult result = manager.validateUserInformation(identityContext);
                authenticated = result.isValid();
            }
            catch (DomainValidationException e) {
                throw new UserIdPasswordException(e, (AuthenticationModule)this);
            }
        }
        if (!authenticated) {
            throw new UserIdPasswordException(this);
        }
        return authenticated;
    }

    public static String getFullyQualifiedUserId(String userId) throws DomainValidationException {
        String separator = System.getProperty("file.separator");
        String lowerCaseUserId = userId.toLowerCase();
        String retUserId = userId;
        LocalOSAuthenticationModule.loadDefaultDomain();
        if (domainName == null) {
            String lowerCaseComputerName = computerName.toLowerCase();
            if (!lowerCaseUserId.startsWith(lowerCaseComputerName)) {
                retUserId = computerName + separator + userId;
            }
        } else {
            String lowerCaseDomainName = domainName.toLowerCase();
            if (!lowerCaseUserId.startsWith(lowerCaseDomainName)) {
                retUserId = domainName + separator + userId;
            }
        }
        boolean normalize = true;
        if (normalize) {
            retUserId = retUserId.toLowerCase();
        }
        return retUserId;
    }
}

