/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.authentication;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.authentication.AuthenticationException;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.authentication.DefaultAuthenticationModule;
import com.ibm.es.nuvo.authentication.HostPortException;
import com.ibm.es.nuvo.authentication.UserIdPasswordException;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import java.util.Properties;
import javax.naming.CommunicationException;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;

public class LDAPAuthenticationModule
extends DefaultAuthenticationModule {
    private AuthenticationData authData = null;

    public LDAPAuthenticationModule(String userId, String serverName, String serverPort, String password) throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
        this.authData.setAuthenticationType(AuthenticationData.AuthenticationType.Ldap);
        this.authData.setServerName(serverName);
        this.authData.setServerPort(serverPort);
        this.authData.setUserId(userId);
        this.validate(userId, password);
        this.saveData();
    }

    public LDAPAuthenticationModule(String userId, String serverName, String serverPort) throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
        this.authData.setAuthenticationType(AuthenticationData.AuthenticationType.Ldap);
        this.authData.setServerName(serverName);
        this.authData.setServerPort(serverPort);
        this.authData.setUserId(userId);
        this.saveData();
    }

    public void changePassword(String userId, String originalPwd, String newPwd) throws AuthenticationException, ConfigurationManagerException, ExtendedException {
        throw new RuntimeException("Not supported");
    }

    public boolean doesPasswordExist() {
        return false;
    }

    public void renameUserId(String originalUserId, String newUserId) throws ConfigurationManagerException, ExtendedException {
        throw new RuntimeException("Not supported");
    }

    public boolean validate(String userId, String pwd) throws ExtendedException {
        boolean valid = false;
        if (userId != null && userId.equals(this.authData.getUserId())) {
            Properties props = new Properties();
            props.setProperty("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
            String ldapURL = "ldap://" + this.authData.getServerName() + ":" + this.authData.getServerPort();
            props.setProperty("java.naming.provider.url", ldapURL);
            props.setProperty("java.naming.security.authentication", "simple");
            props.setProperty("java.naming.security.principal", userId);
            props.setProperty("java.naming.security.credentials", pwd);
            try {
                InitialDirContext ctx = new InitialDirContext(props);
                ctx.close();
                valid = true;
            }
            catch (CommunicationException e) {
                throw new HostPortException(e, (AuthenticationModule)this);
            }
            catch (javax.naming.AuthenticationException e) {
                throw new UserIdPasswordException(e, (AuthenticationModule)this);
            }
            catch (NamingException e) {
                throw new AuthenticationException(e, (AuthenticationModule)this);
            }
        }
        return valid;
    }

    private synchronized void saveData() throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        AuthenticationData newAuthData = (AuthenticationData)configMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.AuthenticationData);
        newAuthData.setServerName(this.authData.getServerName());
        newAuthData.setServerPort(this.authData.getServerPort());
        newAuthData.setUserId(this.authData.getUserId());
        newAuthData.setAuthenticationType(this.authData.getAuthenticationType());
        configMgr.updateStateObject(SettingsConfigurationManager.SettingsType.AuthenticationData, newAuthData);
        this.authData = newAuthData;
    }

    public String getPassword() {
        return null;
    }

    public String getUserId() {
        return this.authData.getUserId();
    }
}

