/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.authentication;

import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.jvm.JvmSupportManager;
import com.ibm.es.nuvo.util.Base64;
import java.security.SecureRandom;
import java.util.Random;

public abstract class DefaultAuthenticationModule
implements AuthenticationModule {
    public String getDefaultUserId() {
        return "admin";
    }

    public String getDefaultPassword() {
        return "";
    }

    public boolean isDefaultLogin() throws ExtendedException {
        return this.getDefaultPassword().equals(this.getPassword()) && this.getDefaultUserId().equals(this.getUserId());
    }

    public String generatePassword(String userId, String seed) throws ExtendedException {
        String pwd = null;
        try {
            SecureRandom secureRandom = JvmSupportManager.getJvmSupportInterface().getSecureRandom();
            Random random = new Random();
            if (seed != null && seed.length() > 0) {
                byte[] seedBytes = seed.getBytes();
                secureRandom.setSeed(seedBytes);
                random.setSeed(seedBytes[0]);
            }
            int pwdSize = 4 + random.nextInt(2);
            byte[] randomBytes = new byte[pwdSize];
            secureRandom.nextBytes(randomBytes);
            pwd = Base64.encode(randomBytes);
        }
        catch (Exception e) {
            throw new ExtendedException(e);
        }
        return pwd;
    }

    public String getServerHostName() {
        return null;
    }

    public int getServerPort() {
        return 0;
    }
}

