/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.authentication;

import com.ibm.es.nuvo.authentication.APIAuthenticationModule;
import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.authentication.AuthenticationService;
import com.ibm.es.nuvo.authentication.DefaultAuthenticationModule;
import com.ibm.es.nuvo.authentication.LDAPAuthenticationModule;
import com.ibm.es.nuvo.authentication.LocalOSAuthenticationModule;
import com.ibm.es.nuvo.authentication.PropertyFileAuthenticationModule;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;
import com.ibm.es.nuvo.logging.Loggers;
import java.io.File;
import java.util.HashMap;

public class AuthenticationManager
implements AuthenticationService {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    public static final String AuthenticationSessionIdAttributeName = "nuvo.j_session_id";
    private static AuthenticationManager authenticationManager = null;
    private AuthenticationModule adminModule = null;
    private AuthenticationModule apiModule = null;
    private AuthenticationModule searchModule = null;
    private HashMap<String, ExtendedException> errorMap = new HashMap();

    public static AuthenticationManager getInstance() {
        if (authenticationManager == null) {
            authenticationManager = new AuthenticationManager();
            authenticationManager.setApiModule(new APIAuthenticationModule());
            SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
            AuthenticationData authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
            try {
                AuthenticationData.AuthenticationType authType = authData.getAuthenticationType();
                DefaultAuthenticationModule authModule = null;
                if (authType == AuthenticationData.AuthenticationType.PropertyFile) {
                    authModule = new PropertyFileAuthenticationModule(authData.getUserId(), authData.getPassword());
                } else if (authType == AuthenticationData.AuthenticationType.Ldap) {
                    authModule = new LDAPAuthenticationModule(authData.getUserId(), authData.getServerName(), authData.getServerPort());
                } else if (authType == AuthenticationData.AuthenticationType.LocalOS) {
                    authModule = new LocalOSAuthenticationModule(authData.getUserId());
                }
                authenticationManager.setAdminModule(authModule);
            }
            catch (ExtendedException e) {
                Loggers.logger.log(e);
            }
        }
        return authenticationManager;
    }

    private AuthenticationManager() {
    }

    public AuthenticationModule getAdminModule() {
        return this.adminModule;
    }

    public AuthenticationModule getApiModule() {
        return this.apiModule;
    }

    public AuthenticationModule getSearchModule() {
        return this.searchModule;
    }

    public void setAdminModule(AuthenticationModule module) {
        this.adminModule = module;
    }

    public void setApiModule(AuthenticationModule module) {
        this.apiModule = module;
    }

    public void setSearchModule(AuthenticationModule module) {
        this.searchModule = module;
    }

    public boolean isShutdownAllowed() {
        String shutdownFileName = GlobalConfiguration.getConfiguration().getShutdownFileName();
        File shutdownFile = new File(shutdownFileName);
        return shutdownFile.exists();
    }

    public boolean isInitialLogin() {
        try {
            return this.adminModule == null || this.adminModule.isDefaultLogin();
        }
        catch (ExtendedException e) {
            Loggers.logger.log(e);
            return true;
        }
    }

    public ExtendedException retrieveLastError(String id) {
        ExtendedException lastError = this.errorMap.remove(id);
        return lastError;
    }

    public void insertLastError(String id, ExtendedException error) {
        this.errorMap.put(id, error);
    }
}

