/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.authentication;

import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.configuration.GlobalConfiguration;
import com.ibm.es.nuvo.configuration.SettingsObject;
import com.ibm.es.nuvo.util.Encryption;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;

public class AuthenticationData
implements SettingsObject {
    private static final String copyright = "IBM Confidential OCO Source Materials 5724-R21 \u00a9 Copyright IBM Corp.  2006, 2007.   All Rights Reserved. The source code for this program is not published or otherwise divested of its trade secrets, irrespective of what has been deposited with the U.S. Copyright Office.";
    private static final String AuthElement = "authentication";
    private static final String IdListElement = "id_list";
    private static final String IdElement = "id";
    private static final String NameElement = "name";
    private static final String PasswordElement = "password";
    private static final String ApiPasswordElement = "api_password";
    private static final String AuthTypeElement = "auth_type";
    private static final String ServerNameElement = "server_name";
    private static final String ServerPortElement = "server_port";
    private static final String VersionAttribute = "version";
    public static final String DefaultUserId = "admin";
    public static final String DefaultPassword = "";
    protected static final int DefaultReadLimit = 0x100000;
    protected static final AuthenticationType DefaultAuthType = AuthenticationType.PropertyFile;
    private static final String AuthFileName = "authentication.xml";
    private String userId = "admin";
    private String password = "";
    private String apiPassword = null;
    private String serverName = null;
    private AuthenticationType authType = DefaultAuthType;
    private String serverPort = null;
    private String tempEncryptedPassword = null;
    private String tempEncryptedApiPassword = null;

    public AuthenticationType getAuthenticationType() {
        return this.authType;
    }

    protected String getPassword() throws ExtendedException {
        this.loadEncryptedPasswords();
        return this.password;
    }

    protected String getUserId() {
        return this.userId;
    }

    public String getApiPassword() throws ExtendedException {
        this.loadEncryptedPasswords();
        return this.apiPassword;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setApiPassword(String apiPassword) {
        this.apiPassword = apiPassword;
        this.tempEncryptedApiPassword = null;
    }

    protected boolean doesApiPasswordExist() {
        return this.apiPassword != null || this.tempEncryptedApiPassword != null;
    }

    protected void setPassword(String password) {
        this.password = password;
        this.tempEncryptedPassword = null;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public void setServerName(String name) {
        this.serverName = name;
    }

    public void setServerPort(String port) {
        this.serverPort = port;
    }

    public void setAuthenticationType(AuthenticationType type) {
        this.authType = type;
    }

    public void setAuthenticationType(String type) {
        this.authType = AuthenticationType.valueOf(type);
    }

    public void writeTo(OutputStream os) throws IOException, ExtendedException {
        XMLTagger xmlTagger = new XMLTagger(true, true);
        this.loadEncryptedPasswords();
        xmlTagger.openStartElement(AuthElement);
        xmlTagger.writeAttr(VersionAttribute, "1.0");
        xmlTagger.closeTag();
        xmlTagger.startElement(IdListElement);
        if (this.userId != null) {
            xmlTagger.startElement(IdElement);
            xmlTagger.startElement(NameElement);
            xmlTagger.writeText(this.userId);
            xmlTagger.endElement(NameElement);
            if (this.password != null) {
                xmlTagger.startElement(PasswordElement);
                xmlTagger.writeText(Encryption.encrypt(this.password));
                xmlTagger.endElement(PasswordElement);
            }
            if (this.apiPassword != null) {
                xmlTagger.startElement(ApiPasswordElement);
                xmlTagger.writeText(Encryption.encrypt(this.apiPassword));
                xmlTagger.endElement(ApiPasswordElement);
            }
            if (this.authType != null) {
                xmlTagger.startElement(AuthTypeElement);
                xmlTagger.writeText(this.authType.toString());
                xmlTagger.endElement(AuthTypeElement);
            }
            if (this.serverName != null) {
                xmlTagger.startElement(ServerNameElement);
                xmlTagger.writeText(this.serverName);
                xmlTagger.endElement(ServerNameElement);
            }
            if (this.serverPort != null) {
                xmlTagger.startElement(ServerPortElement);
                xmlTagger.writeText(this.serverPort);
                xmlTagger.endElement(ServerPortElement);
            }
            xmlTagger.endElement(IdElement);
        }
        xmlTagger.endElement(IdListElement);
        xmlTagger.endElement(AuthElement);
        String xml = xmlTagger.getXML();
        try {
            os.write(xml.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException ignore) {
            // empty catch block
        }
    }

    public void loadFrom(InputStream is) throws ExtendedException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        String basePath = "/authentication/id_list/id/";
        tree.addPath(basePath + NameElement, "setUserId");
        tree.addPath(basePath + PasswordElement, "setTempEncryptedPassword");
        tree.addPath(basePath + ApiPasswordElement, "setTempEncryptedApiPassword");
        tree.addPath(basePath + AuthTypeElement, "setAuthenticationType");
        tree.addPath(basePath + ServerNameElement, "setServerName");
        tree.addPath(basePath + ServerPortElement, "setServerPort");
        parser.parse(is, tree, this);
    }

    private void loadEncryptedPasswords() throws ExtendedException {
        if (this.tempEncryptedPassword != null) {
            this.password = Encryption.decrypt(this.tempEncryptedPassword);
            this.tempEncryptedPassword = null;
        }
        if (this.tempEncryptedApiPassword != null) {
            this.apiPassword = Encryption.decrypt(this.tempEncryptedApiPassword);
            this.tempEncryptedApiPassword = null;
        }
    }

    public void setTempEncryptedPassword(String tempEncryptedPassword) {
        this.tempEncryptedPassword = tempEncryptedPassword;
    }

    public void setTempEncryptedApiPassword(String tempEncryptedApiPassword) {
        this.tempEncryptedApiPassword = tempEncryptedApiPassword;
    }

    public String getPersistantFileName() {
        StringBuffer sb = new StringBuffer(200);
        GlobalConfiguration gc = GlobalConfiguration.getConfiguration();
        sb.append(gc.getConfigPath());
        sb.append(File.separator);
        sb.append(AuthFileName);
        return sb.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum AuthenticationType {
        PropertyFile,
        Ldap,
        LocalOS;

    }
}

