/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.authentication;

import com.ibm.es.nuvo.authentication.AuthenticationData;
import com.ibm.es.nuvo.authentication.AuthenticationException;
import com.ibm.es.nuvo.authentication.AuthenticationModule;
import com.ibm.es.nuvo.authentication.DefaultAuthenticationModule;
import com.ibm.es.nuvo.common.ExtendedException;
import com.ibm.es.nuvo.common.Message;
import com.ibm.es.nuvo.configuration.ConfigurationManagerException;
import com.ibm.es.nuvo.configuration.SettingsConfigurationManager;

public class APIAuthenticationModule
extends DefaultAuthenticationModule {
    private AuthenticationData authData = null;

    public APIAuthenticationModule() {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        this.authData = (AuthenticationData)configMgr.getSettings(SettingsConfigurationManager.SettingsType.AuthenticationData);
    }

    public void changePassword(String userId, String originalPwd, String newPwd) throws AuthenticationException, ConfigurationManagerException, ExtendedException {
        if (originalPwd == null || !originalPwd.equals(this.authData.getPassword())) {
            Message msg = new Message("G0113E.PASSWORD_CHANGE_BAD_ORIGINAL_PWD");
            throw new AuthenticationException(msg, (AuthenticationModule)this);
        }
        this.authData.setPassword(newPwd);
        this.saveData();
    }

    public String generatePassword(String userId, String seed) throws ExtendedException {
        String newPass = super.generatePassword(userId, seed);
        this.authData.setApiPassword(newPass);
        this.saveData();
        return newPass;
    }

    public boolean doesPasswordExist() {
        return this.authData.doesApiPasswordExist();
    }

    public void renameUserId(String originalUserId, String newUserId) throws ConfigurationManagerException, ExtendedException {
        throw new RuntimeException("not supported");
    }

    public boolean validate(String userId, String pwd) throws ExtendedException {
        boolean valid = false;
        if (pwd != null && pwd.equals(this.authData.getApiPassword())) {
            valid = true;
        }
        return valid;
    }

    private synchronized void saveData() throws ExtendedException {
        SettingsConfigurationManager configMgr = SettingsConfigurationManager.getConfigurationManager();
        AuthenticationData newAuthData = (AuthenticationData)configMgr.getSettingsForUpdate(SettingsConfigurationManager.SettingsType.AuthenticationData);
        newAuthData.setApiPassword(this.authData.getApiPassword());
        configMgr.updateStateObject(SettingsConfigurationManager.SettingsType.AuthenticationData, newAuthData);
        this.authData = newAuthData;
    }

    public String getPassword() {
        try {
            return this.authData.getApiPassword();
        }
        catch (ExtendedException extendedException) {
            return null;
        }
    }

    public String getUserId() {
        return null;
    }
}

