/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.es.nuvo.api.common;

import com.ibm.es.nuvo.configuration.CollectionConfiguration;
import com.ibm.es.nuvo.util.XMLTagger;
import com.ibm.es.nuvo.util.parser.ParseException;
import com.ibm.es.nuvo.util.parser.ParseTree;
import com.ibm.es.nuvo.util.parser.Parser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IndexList {
    private Vector<IndexItem> indexItems = null;

    public Vector<IndexItem> getIndexItems() {
        return this.indexItems;
    }

    public static IndexList loadFrom(InputStream is) throws ParseException {
        Parser parser = new Parser();
        ParseTree tree = new ParseTree();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("enabled", "enabled");
        map.put("default", "default");
        tree.addSetSubcomponent("/collections/collection", "buildIndexItem");
        tree.addAttributesRule("/collections/collection/", map);
        tree.addCallMethod("/collections/collection/name/", "setName");
        tree.addCallMethod("/collections/collection/state/", "setState");
        IndexList list = new IndexList();
        parser.parse(is, tree, list);
        return list;
    }

    public String toXML() {
        XMLTagger tagger = new XMLTagger();
        tagger.startPI("version = 1.0 encoding=\"UTF-8\"");
        tagger.endPI();
        tagger.writeText("\n");
        tagger.startElement("collections version=\"1.0\"");
        for (IndexItem item : this.indexItems) {
            tagger.openStartElement("collection");
            tagger.writeAttr("enabled", Boolean.toString(item.isEnabled()));
            if (item.isDefault) {
                tagger.writeAttr("default", Boolean.toString(true));
            }
            tagger.closeTag();
            if (item.getName() != null) {
                tagger.startElement("name");
                tagger.writeText(item.getName());
                tagger.endElement("name");
            }
            if (item.getState() != null) {
                tagger.startElement("state");
                String externalStateStr = item.getState().toString();
                if (externalStateStr.equals(CollectionConfiguration.State.Normal.toString())) {
                    externalStateStr = "Available";
                }
                tagger.writeText(externalStateStr);
                tagger.endElement("state");
            }
            tagger.endElement("collection");
        }
        tagger.endElement("collections");
        return tagger.getXML();
    }

    public IndexItem buildIndexItem() {
        if (this.indexItems == null) {
            this.indexItems = new Vector();
        }
        IndexItem indexItem = new IndexItem();
        this.indexItems.add(indexItem);
        return indexItem;
    }

    public class IndexItem {
        private String name = null;
        private CollectionConfiguration.State state = null;
        private boolean isEnabled = false;
        private boolean isSecure = false;
        private boolean isDefault = false;

        public void setName(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setState(String state) {
            if (state.equals("Available")) {
                state = CollectionConfiguration.State.Normal.toString();
            }
            this.state = CollectionConfiguration.State.valueOf(state);
        }

        public CollectionConfiguration.State getState() {
            return this.state;
        }

        public void setEnabled(String isEnabled) {
            this.isEnabled = Boolean.parseBoolean(isEnabled);
        }

        public boolean isEnabled() {
            return this.isEnabled;
        }

        public void setSecure(String isSecure) {
            this.isSecure = Boolean.parseBoolean(isSecure);
        }

        public boolean isSecure() {
            return this.isSecure;
        }

        public void setDefault(String isDefault) {
            this.isDefault = Boolean.parseBoolean(isDefault);
        }

        public boolean isDefault() {
            return this.isDefault;
        }
    }
}

